/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.LocalDateTimeTextFieldSkin;
import jfxtras.internal.scene.control.skin.TextFieldSkin;
import jfxtras.scene.control.LocalDateTimePicker;

public class LocalDateTimeTextField
extends Control {
    private final ObjectProperty<LocalDateTime> localDateTimeObjectProperty = new SimpleObjectProperty((Object)this, "localDateTime");
    private final ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty<Locale>(Locale.getDefault()){

        public void set(Locale value) {
            super.set((Object)value);
            if (!LocalDateTimeTextField.this.dateFormatManual) {
                LocalDateTimeTextField.this.setDateTimeFormatter(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(LocalDateTimeTextField.this.getLocale()));
            }
        }
    };
    private final ObjectProperty<DateTimeFormatter> dateTimeFormatterObjectProperty = new SimpleObjectProperty<DateTimeFormatter>((Object)this, "dateTimeFormatter", DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(this.getLocale())){

        public void set(DateTimeFormatter value) {
            super.set((Object)(value != null ? value : DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(LocalDateTimeTextField.this.getLocale())));
            LocalDateTimeTextField.this.dateFormatManual = value != null;
        }
    };
    private boolean dateFormatManual = false;
    ListProperty<DateTimeFormatter> dateTimeFormattersProperty = new SimpleListProperty(FXCollections.observableList(new ArrayList()));
    private final ObjectProperty<String> promptTextObjectProperty = new SimpleObjectProperty((Object)this, "promptText", null);
    private final ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackObjectProperty = new SimpleObjectProperty((Object)this, "parseErrorCallback", null);
    private final ObservableList<LocalDateTime> highlightedLocalDateTimes = FXCollections.observableArrayList();
    private final ObservableList<LocalDateTime> disabledLocalDateTimes = FXCollections.observableArrayList();
    private final ObjectProperty<Callback<LocalDateTimePicker.LocalDateTimeRange, Void>> localDateTimeRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "localDateTimeRangeCallback", null);
    private final ObjectProperty<Callback<LocalDateTime, Boolean>> valueValidationCallbackObjectProperty = new SimpleObjectProperty((Object)this, "valueValidationCallback", null);
    private volatile ObjectProperty<LocalDateTime> displayedLocalDateTimeObjectProperty = new SimpleObjectProperty((Object)this, "displayedLocalDateTimeRange");
    private volatile BooleanProperty allowNullProperty = new SimpleBooleanProperty((Object)this, "allowNull", true);
    private final ObjectProperty<String> textObjectProperty = new SimpleObjectProperty((Object)this, "text", null);
    private final BooleanProperty pickerShowingProperty = new SimpleBooleanProperty();
    private final BooleanProperty editableProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty immediateProperty = new SimpleBooleanProperty(false);

    public LocalDateTimeTextField() {
        this.construct();
    }

    public LocalDateTimeTextField(LocalDateTime localDateTime) {
        this.construct();
        this.setLocalDateTime(localDateTime);
    }

    private void construct() {
        this.constructDisplayedLocalDateTime();
    }

    public Skin createDefaultSkin() {
        return new LocalDateTimeTextFieldSkin(this);
    }

    public void selectAll() {
        if (this.getSkin() != null && this.getSkin() instanceof TextFieldSkin) {
            ((TextFieldSkin)this.getSkin()).selectAll();
        }
    }

    public ObjectProperty<LocalDateTime> localDateTimeProperty() {
        return this.localDateTimeObjectProperty;
    }

    public LocalDateTime getLocalDateTime() {
        return (LocalDateTime)this.localDateTimeObjectProperty.getValue();
    }

    public void setLocalDateTime(LocalDateTime value) {
        this.localDateTimeObjectProperty.setValue((Object)value);
    }

    public LocalDateTimeTextField withLocalDateTime(LocalDateTime value) {
        this.setLocalDateTime(value);
        return this;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public LocalDateTimeTextField withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        return this.dateTimeFormatterObjectProperty;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatterObjectProperty.getValue();
    }

    public void setDateTimeFormatter(DateTimeFormatter value) {
        this.dateTimeFormatterObjectProperty.setValue((Object)value);
    }

    public LocalDateTimeTextField withDateTimeFormatter(DateTimeFormatter value) {
        this.setDateTimeFormatter(value);
        return this;
    }

    public ListProperty<DateTimeFormatter> dateTimeFormattersProperty() {
        return this.dateTimeFormattersProperty;
    }

    public ObservableList<DateTimeFormatter> getDateTimeFormatters() {
        return this.dateTimeFormattersProperty.getValue();
    }

    public void setDateTimeFormatters(ObservableList<DateTimeFormatter> value) {
        this.dateTimeFormattersProperty.setValue(value);
    }

    public LocalDateTimeTextField withDateTimeFormatter(ObservableList<DateTimeFormatter> value) {
        this.setDateTimeFormatters(value);
        return this;
    }

    public ObjectProperty<String> promptTextProperty() {
        return this.promptTextObjectProperty;
    }

    public String getPromptText() {
        return (String)this.promptTextObjectProperty.get();
    }

    public void setPromptText(String value) {
        this.promptTextObjectProperty.set((Object)value);
    }

    public LocalDateTimeTextField withPromptText(String value) {
        this.setPromptText(value);
        return this;
    }

    public ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackProperty() {
        return this.parseErrorCallbackObjectProperty;
    }

    public Callback<Throwable, Void> getParseErrorCallback() {
        return (Callback)this.parseErrorCallbackObjectProperty.getValue();
    }

    public void setParseErrorCallback(Callback<Throwable, Void> value) {
        this.parseErrorCallbackObjectProperty.setValue(value);
    }

    public LocalDateTimeTextField withParseErrorCallback(Callback<Throwable, Void> value) {
        this.setParseErrorCallback(value);
        return this;
    }

    public ObservableList<LocalDateTime> highlightedLocalDateTimes() {
        return this.highlightedLocalDateTimes;
    }

    public ObservableList<LocalDateTime> disabledLocalDateTimes() {
        return this.disabledLocalDateTimes;
    }

    public ObjectProperty<Callback<LocalDateTimePicker.LocalDateTimeRange, Void>> LocalDateTimeRangeCallbackProperty() {
        return this.localDateTimeRangeCallbackObjectProperty;
    }

    public Callback<LocalDateTimePicker.LocalDateTimeRange, Void> getLocalDateTimeRangeCallback() {
        return (Callback)this.localDateTimeRangeCallbackObjectProperty.getValue();
    }

    public void setLocalDateTimeRangeCallback(Callback<LocalDateTimePicker.LocalDateTimeRange, Void> value) {
        this.localDateTimeRangeCallbackObjectProperty.setValue(value);
    }

    public LocalDateTimeTextField withLocalDateTimeRangeCallback(Callback<LocalDateTimePicker.LocalDateTimeRange, Void> value) {
        this.setLocalDateTimeRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateTime, Boolean>> valueValidationCallbackProperty() {
        return this.valueValidationCallbackObjectProperty;
    }

    public Callback<LocalDateTime, Boolean> getValueValidationCallback() {
        return (Callback)this.valueValidationCallbackObjectProperty.getValue();
    }

    public void setValueValidationCallback(Callback<LocalDateTime, Boolean> value) {
        this.valueValidationCallbackObjectProperty.setValue(value);
    }

    public LocalDateTimeTextField withValueValidationCallback(Callback<LocalDateTime, Boolean> value) {
        this.setValueValidationCallback(value);
        return this;
    }

    public ObjectProperty<LocalDateTime> displayedLocalDateTime() {
        return this.displayedLocalDateTimeObjectProperty;
    }

    public LocalDateTime getDisplayedLocalDateTime() {
        return (LocalDateTime)this.displayedLocalDateTimeObjectProperty.getValue();
    }

    public void setDisplayedLocalDateTime(LocalDateTime value) {
        this.displayedLocalDateTimeObjectProperty.setValue((Object)value);
    }

    public LocalDateTimeTextField withDisplayedLocalDateTime(LocalDateTime value) {
        this.setDisplayedLocalDateTime(value);
        return this;
    }

    private void constructDisplayedLocalDateTime() {
        this.setDisplayedLocalDateTime(LocalDateTime.now());
    }

    public BooleanProperty allowNullProperty() {
        return this.allowNullProperty;
    }

    public boolean getAllowNull() {
        return this.allowNullProperty.get();
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNullProperty.set(allowNull);
    }

    public LocalDateTimeTextField withAllowNull(boolean value) {
        this.setAllowNull(value);
        return this;
    }

    public ObjectProperty<String> textProperty() {
        return this.textObjectProperty;
    }

    public String getText() {
        return (String)this.textObjectProperty.get();
    }

    public void setText(String value) {
        this.textObjectProperty.set((Object)value);
    }

    public LocalDateTimeTextField withText(String value) {
        this.setText(value);
        return this;
    }

    public BooleanProperty pickerShowingProperty() {
        return this.pickerShowingProperty;
    }

    public boolean isPickerShowing() {
        return this.pickerShowingProperty.get();
    }

    public void setPickerShowing(boolean value) {
        this.pickerShowingProperty.set(value);
    }

    public LocalDateTimeTextField withPickerShowing(boolean value) {
        this.setPickerShowing(value);
        return this;
    }

    public BooleanProperty editableProperty() {
        return this.editableProperty;
    }

    public boolean isEditable() {
        return this.editableProperty.get();
    }

    public void setEditable(boolean value) {
        this.editableProperty.set(value);
    }

    public LocalDateTimeTextField withEditable(boolean value) {
        this.setEditable(value);
        return this;
    }

    public BooleanProperty immediateProperty() {
        return this.immediateProperty;
    }

    public boolean isImmediate() {
        return this.immediateProperty.get();
    }

    public void setImmediate(boolean value) {
        this.immediateProperty.set(value);
    }

    public LocalDateTimeTextField withImmediate(boolean value) {
        this.setImmediate(value);
        return this;
    }
}

