/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import jfxtras.scene.control.AccordionPane;
import jfxtras.scene.layout.VBox;

public class AccordionSkin
extends SkinBase<AccordionPane> {
    private final VBox vbox = new VBox();
    private long idCounter = 0L;

    public AccordionSkin(AccordionPane control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((AccordionPane)this.getSkinnable()).visibleTabProperty().addListener(observable -> {
            if (((AccordionPane)this.getSkinnable()).getVisibleTab() != null) {
                this.show(((AccordionPane)this.getSkinnable()).getVisibleTab().getNode());
            }
        });
        this.monitorTabs();
    }

    private void monitorTabs() {
        ((AccordionPane)this.getSkinnable()).tabs().addListener((ListChangeListener)new ListChangeListener<AccordionPane.Tab>(){

            public void onChanged(ListChangeListener.Change<? extends AccordionPane.Tab> change) {
                while (change.next()) {
                    for (AccordionPane.Tab lTab : change.getAddedSubList()) {
                        AccordionSkin.this.addTab(lTab);
                    }
                    for (AccordionPane.Tab lTab : change.getRemoved()) {
                        AccordionSkin.this.removeTab(lTab);
                    }
                }
            }
        });
        for (AccordionPane.Tab lTab : ((AccordionPane)this.getSkinnable()).tabs()) {
            this.addTab(lTab);
        }
    }

    private void createNodes() {
        ((AccordionPane)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.vbox);
    }

    private void addTab(AccordionPane.Tab tab) {
        if (tab.getNode() == null) {
            throw new NullPointerException("Harmonica tabs must have node set");
        }
        ++this.idCounter;
        TabButton lTabButton = new TabButton(tab);
        this.vbox.add((Node)lTabButton, (VBox.C)new VBox.C().maxWidth(Double.MAX_VALUE));
        TabPane lTabPane = new TabPane(tab);
        this.vbox.add((Node)lTabPane, ((VBox.C)new VBox.C().maxWidth(Double.MAX_VALUE)).vgrow(Priority.ALWAYS));
        lTabButton.onActionProperty().set(event -> this.show(lTabPane.getContent()));
        if (((AccordionPane)this.getSkinnable()).getVisibleTab() == null) {
            ((AccordionPane)this.getSkinnable()).setVisibleTab(tab);
        }
        this.refresh();
    }

    private void removeTab(AccordionPane.Tab lTab) {
        for (int i = this.vbox.getChildren().size() - 1; i >= 0; i -= 2) {
            Node lNode = (Node)this.vbox.getChildren().get(i);
            TabPane lTabPane = (TabPane)lNode;
            if (lTabPane.getContent() != lTab.getNode()) continue;
            this.vbox.getChildren().remove(i);
            this.vbox.getChildren().remove(i - 1);
        }
        if (lTab == ((AccordionPane)this.getSkinnable()).getVisibleTab()) {
            ((AccordionPane)this.getSkinnable()).setVisibleTab(((AccordionPane)this.getSkinnable()).tabs().size() == 0 ? null : (AccordionPane.Tab)((AccordionPane)this.getSkinnable()).tabs().get(0));
        }
        this.refresh();
    }

    private void show(Node node) {
        for (int i = 1; i < this.vbox.getChildren().size(); i += 2) {
            TabPane lTabPane;
            lTabPane.setVisible(node == (lTabPane = (TabPane)((Object)this.vbox.getChildren().get(i))).getContent());
            lTabPane.setManaged(lTabPane.isVisible());
            if (lTabPane.isVisible()) {
                lTabPane.getContent().requestFocus();
            }
            for (AccordionPane.Tab lTab : ((AccordionPane)this.getSkinnable()).tabs()) {
                if (lTab.getNode() != node) continue;
                ((AccordionPane)this.getSkinnable()).setVisibleTab(lTab);
            }
        }
    }

    private void refresh() {
        if (((AccordionPane)this.getSkinnable()).getVisibleTab() != null) {
            this.show(((AccordionPane)this.getSkinnable()).getVisibleTab().getNode());
        }
    }

    class TabButton
    extends Button {
        TabButton(AccordionPane.Tab tab) {
            this.setId(((Object)((Object)this)).getClass().getSimpleName() + "-" + AccordionSkin.this.idCounter);
            this.textProperty().bind(tab.textProperty());
            this.graphicProperty().bind(tab.iconProperty());
        }
    }

    class TabPane
    extends BorderPane {
        TabPane(AccordionPane.Tab tab) {
            super(tab.getNode());
            this.setId(((Object)((Object)this)).getClass().getSimpleName() + "-" + AccordionSkin.this.idCounter);
        }

        Node getContent() {
            return this.getCenter();
        }
    }
}

