/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.css.converters.SimpleDateFormatConverter;
import jfxtras.scene.control.CalendarTimePicker;

public class CalendarTimePickerSkin
extends SkinBase<CalendarTimePicker> {
    private final ObjectProperty<ShowTickLabels> showTickLabels = new SimpleStyleableObjectProperty<ShowTickLabels>(StyleableProperties.SHOW_TICKLABELS, (Object)this, "showTickLabels", (ShowTickLabels)((Object)StyleableProperties.SHOW_TICKLABELS.getInitialValue(null))){
        {
            this.addListener(invalidationEvent -> CalendarTimePickerSkin.this.refreshLayout());
        }
    };
    private final ObjectProperty<DateFormat> labelDateFormat = new SimpleStyleableObjectProperty<DateFormat>(StyleableProperties.LABEL_DATEFORMAT, (Object)this, "labelDateFormat", (DateFormat)StyleableProperties.LABEL_DATEFORMAT.getInitialValue(null)){
        {
            this.addListener(invalidationEvent -> {
                CalendarTimePickerSkin.this.refreshLayout();
                CalendarTimePickerSkin.this.refresh();
            });
        }
    };
    private final Slider hourScrollSlider = new Slider();
    private final Slider minuteScrollSlider = new Slider();
    private final Slider secondScrollSlider = new Slider();
    private final Text timeText = new Text("XX:XX:XX");
    final Pane hourLabelsPane = new Pane(){
        {
            this.prefWidthProperty().bind((ObservableValue)CalendarTimePickerSkin.this.hourScrollSlider.prefWidthProperty());
            this.layoutChildren();
        }

        protected void layoutChildren() {
            double lX;
            Text lText;
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            Text lText2 = new Text("0");
            Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText2.prefHeight(0.0));
            lRectangle.setFill((Paint)Color.TRANSPARENT);
            this.getChildren().add((Object)lRectangle);
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 24;
            if (lNumberOfLabels >= 24) {
                lStep = 1;
            } else if (lNumberOfLabels >= 12) {
                lStep = 2;
            } else if (lNumberOfLabels >= 8) {
                lStep = 3;
            } else if (lNumberOfLabels >= 6) {
                lStep = 4;
            } else if (lNumberOfLabels > 4) {
                lStep = 6;
            } else if (lNumberOfLabels > 2) {
                lStep = 12;
            }
            for (i = 0; i < 24; i += lStep) {
                lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 23 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i < 24; ++i) {
                lText = new Text("0");
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, lText.prefHeight(0.0) + 3.0, lX, lText.prefHeight(0.0) + 3.0 + 3.0));
            }
        }
    };
    final Pane minuteLabelsPane = new Pane(){
        {
            this.layoutChildren();
        }

        protected void layoutChildren() {
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            if (CalendarTimePickerSkin.this.getShowTickLabels() == ShowTickLabels.YES) {
                Text lText = new Text("0");
                Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText.prefHeight(0.0));
                lRectangle.setFill((Paint)Color.TRANSPARENT);
                this.getChildren().add((Object)lRectangle);
            }
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 60;
            if (lNumberOfLabels >= 60) {
                lStep = 1;
            } else if (lNumberOfLabels >= 30) {
                lStep = 2;
            } else if (lNumberOfLabels >= 20) {
                lStep = 3;
            } else if (lNumberOfLabels >= 15) {
                lStep = 4;
            } else if (lNumberOfLabels >= 12) {
                lStep = 5;
            } else if (lNumberOfLabels >= 6) {
                lStep = 10;
            } else if (lNumberOfLabels >= 4) {
                lStep = 15;
            } else if (lNumberOfLabels >= 2) {
                lStep = 30;
            }
            if (lStep < ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep()) {
                lStep = ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep();
            }
            for (i = 0; i <= 59; i += lStep) {
                Text lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 59 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i <= 59; ++i) {
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, 0.0, lX, 3.0));
            }
        }
    };
    static final int UNIQUE_NUMBER_FOR_H = 2;
    static final int UNIQUE_NUMBER_FOR_M = 3;
    static final int UNIQUE_NUMBER_FOR_S = 4;
    static final Date DATE_WITH_UNIQUE_NUMBERS_FOR_HMS = new Date(8099, 0, 1, 2, 3, 4);
    private final AtomicInteger refreshingAtomicInteger = new AtomicInteger(0);
    private Calendar changingCalendar = null;

    public CalendarTimePickerSkin(CalendarTimePicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTimePicker)this.getSkinnable()).calendarProperty().addListener(observable -> this.refresh());
        ((CalendarTimePicker)this.getSkinnable()).hourStepProperty().addListener(observable -> this.hourScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getHourStep().doubleValue()));
        this.hourScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getHourStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).minuteStepProperty().addListener(observable -> this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue()));
        this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).secondStepProperty().addListener(observable -> this.secondScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue()));
        this.secondScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).localeProperty().addListener(observable -> this.refresh());
        this.refresh();
    }

    public final ObjectProperty<ShowTickLabels> showTickLabelsProperty() {
        return this.showTickLabels;
    }

    public final void setShowTickLabels(ShowTickLabels value) {
        this.showTickLabelsProperty().set((Object)value);
    }

    public final ShowTickLabels getShowTickLabels() {
        return (ShowTickLabels)((Object)this.showTickLabels.get());
    }

    public final CalendarTimePickerSkin withShowTickLabels(ShowTickLabels value) {
        this.setShowTickLabels(value);
        return this;
    }

    public final ObjectProperty<DateFormat> labelDateFormatProperty() {
        return this.labelDateFormat;
    }

    public final void setLabelDateFormat(DateFormat value) {
        this.labelDateFormatProperty().set((Object)value);
    }

    public final DateFormat getLabelDateFormat() {
        if (this.labelDateFormat.get() == null) {
            return this.getLABEL_DATEFORMAT_DEFAULT();
        }
        DateFormat labelDateFormat = (DateFormat)this.labelDateFormat.get();
        if (labelDateFormat.getCalendar() == null) {
            labelDateFormat.setCalendar(Calendar.getInstance(((CalendarTimePicker)this.getSkinnable()).getLocale()));
        }
        if (labelDateFormat.getNumberFormat() == null) {
            labelDateFormat.setNumberFormat(NumberFormat.getInstance(((CalendarTimePicker)this.getSkinnable()).getLocale()));
        }
        labelDateFormat = (DateFormat)labelDateFormat.clone();
        labelDateFormat.setTimeZone(TimeZone.getDefault());
        return labelDateFormat;
    }

    public final CalendarTimePickerSkin withLabelDateFormat(DateFormat value) {
        this.setLabelDateFormat(value);
        return this;
    }

    private DateFormat getLABEL_DATEFORMAT_DEFAULT() {
        return DateFormat.getTimeInstance(3, ((CalendarTimePicker)this.getSkinnable()).getLocale());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CalendarTimePickerSkin.getClassCssMetaData();
    }

    private void createNodes() {
        this.hourScrollSlider.setId("hourSlider");
        this.hourScrollSlider.minProperty().set(0.0);
        this.hourScrollSlider.maxProperty().set(23.0);
        this.hourScrollSlider.setMajorTickUnit(12.0);
        this.hourScrollSlider.setMinorTickCount(3);
        this.hourScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.modifyChangingCalendarHour(newValue.intValue());
            if (!this.hourScrollSlider.valueChangingProperty().get()) {
                this.acceptChangingCalendar();
            }
        });
        this.hourScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.minuteScrollSlider.setId("minuteSlider");
        this.minuteScrollSlider.minProperty().set(0.0);
        this.minuteScrollSlider.maxProperty().set(59.0);
        this.minuteScrollSlider.setMajorTickUnit(10.0);
        this.minuteScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.modifyChangingCalendarMinute(newValue.intValue());
            if (!this.minuteScrollSlider.valueChangingProperty().get()) {
                this.acceptChangingCalendar();
            }
        });
        this.minuteScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.secondScrollSlider.setId("secondSlider");
        this.secondScrollSlider.minProperty().set(0.0);
        this.secondScrollSlider.maxProperty().set(59.0);
        this.secondScrollSlider.setMajorTickUnit(10.0);
        this.secondScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.modifyChangingCalendarSecond(newValue.intValue());
            if (!this.secondScrollSlider.valueChangingProperty().get()) {
                this.acceptChangingCalendar();
            }
        });
        this.secondScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.timeText.setDisable(true);
        this.timeText.getStyleClass().add((Object)"timeLabel");
        this.timeText.setMouseTransparent(true);
        this.refreshLayout();
        ((CalendarTimePicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public void modifyChangingCalendarSecond(int seconds) {
        Calendar lCalendar = this.getChangingCalendar();
        lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
        int lSecondStep = ((CalendarTimePicker)this.getSkinnable()).getSecondStep();
        if (lSecondStep > 1 && (seconds += ((CalendarTimePicker)this.getSkinnable()).getSecondStep() / 2) > 59) {
            seconds -= lSecondStep;
        }
        CalendarTimePickerSkin.setSeconds(lCalendar, seconds);
        lCalendar = CalendarTimePickerSkin.blockSecondsToStep(lCalendar, ((CalendarTimePicker)this.getSkinnable()).getSecondStep());
        this.setChangingCalendar(lCalendar);
    }

    public void modifyChangingCalendarMinute(int minutes) {
        Calendar lCalendar = this.getChangingCalendar();
        lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
        int lMinuteStep = ((CalendarTimePicker)this.getSkinnable()).getMinuteStep();
        if (lMinuteStep > 1 && (minutes += ((CalendarTimePicker)this.getSkinnable()).getMinuteStep() / 2) > 59) {
            minutes -= lMinuteStep;
        }
        CalendarTimePickerSkin.setMinutes(lCalendar, minutes);
        lCalendar = CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimePicker)this.getSkinnable()).getMinuteStep());
        this.setChangingCalendar(lCalendar);
    }

    public void modifyChangingCalendarHour(int hour) {
        Calendar lCalendar = this.getChangingCalendar();
        lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
        int lHourStep = ((CalendarTimePicker)this.getSkinnable()).getHourStep();
        if (lHourStep > 1 && (hour += ((CalendarTimePicker)this.getSkinnable()).getHourStep() / 2) > 23) {
            hour -= lHourStep;
        }
        CalendarTimePickerSkin.setHours(lCalendar, hour);
        lCalendar = CalendarTimePickerSkin.blockHoursToStep(lCalendar, ((CalendarTimePicker)this.getSkinnable()).getHourStep());
        this.setChangingCalendar(lCalendar);
    }

    private void refreshLayout() {
        DateFormat labelDateFormat = this.getLabelDateFormat();
        String formattedDate = labelDateFormat.format(DATE_WITH_UNIQUE_NUMBERS_FOR_HMS);
        this.getChildren().clear();
        StackPane lStackPane = new StackPane();
        VBox lVBox = new VBox(0.0);
        lVBox.alignmentProperty().set((Object)Pos.CENTER);
        if (formattedDate.contains("2")) {
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.hourLabelsPane);
            }
            lVBox.getChildren().add((Object)this.hourScrollSlider);
        }
        if (formattedDate.contains("3")) {
            lVBox.getChildren().add((Object)this.minuteScrollSlider);
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.minuteLabelsPane);
            }
        }
        if (formattedDate.contains("4")) {
            lVBox.getChildren().add((Object)this.secondScrollSlider);
        }
        lStackPane.getChildren().add((Object)lVBox);
        lStackPane.getChildren().add((Object)this.timeText);
        StackPane.setAlignment((Node)this.timeText, (Pos)(this.getShowTickLabels() == ShowTickLabels.YES ? Pos.CENTER : Pos.TOP_CENTER));
        this.getChildren().add((Object)lStackPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        try {
            this.refreshingAtomicInteger.addAndGet(1);
            Calendar lCalendar = this.getChangingCalendar();
            int lHour = lCalendar == null ? 0 : lCalendar.getTime().getHours();
            int lMinute = lCalendar == null ? 0 : lCalendar.getTime().getMinutes();
            int lSecond = lCalendar == null ? 0 : lCalendar.getTime().getSeconds();
            this.hourScrollSlider.valueProperty().set((double)lHour);
            this.minuteScrollSlider.valueProperty().set((double)lMinute);
            this.secondScrollSlider.valueProperty().set((double)lSecond);
            String lTimeText = lCalendar == null ? "\u00d8" : this.getLabelDateFormat().format(lCalendar.getTime());
            this.timeText.setText(lTimeText);
        }
        finally {
            this.refreshingAtomicInteger.addAndGet(-1);
        }
    }

    public static Calendar blockHoursToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null || stepSize == 1) {
            return calendar;
        }
        int lValue = calendar.getTime().getHours();
        lValue /= stepSize.intValue();
        if (calendar.getTime().getHours() != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            CalendarTimePickerSkin.setHours(lCalendar, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    public static Calendar blockMinutesToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null || stepSize == 1) {
            return calendar;
        }
        int lValue = calendar.getTime().getMinutes();
        lValue /= stepSize.intValue();
        if (calendar.getTime().getMinutes() != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            CalendarTimePickerSkin.setMinutes(lCalendar, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    public static Calendar blockSecondsToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null || stepSize == 1) {
            return calendar;
        }
        int lValue = calendar.getTime().getSeconds();
        lValue /= stepSize.intValue();
        if (calendar.getTime().getSeconds() != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            CalendarTimePickerSkin.setSeconds(lCalendar, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    private Calendar getChangingCalendar() {
        if (this.changingCalendar != null) {
            return this.changingCalendar;
        }
        return ((CalendarTimePicker)this.getSkinnable()).getCalendar();
    }

    public void setChangingCalendar(Calendar lCalendar) {
        if (!lCalendar.equals(this.getChangingCalendar())) {
            this.changingCalendar = lCalendar;
            this.refresh();
        }
    }

    public void acceptChangingCalendar() {
        if (this.changingCalendar != null) {
            if (this.callValueValidationCallback((Calendar)this.changingCalendar.clone())) {
                ((CalendarTimePicker)this.getSkinnable()).setCalendar(this.changingCalendar);
            }
            this.changingCalendar = null;
            this.refresh();
        }
    }

    private boolean callValueValidationCallback(Calendar value) {
        Callback<Calendar, Boolean> lCallback = ((CalendarTimePicker)this.getSkinnable()).getValueValidationCallback();
        if (lCallback == null) {
            return true;
        }
        return (Boolean)lCallback.call((Object)value);
    }

    private static void setHours(Calendar calendar, int hours) {
        if (calendar == null) {
            return;
        }
        Date date = calendar.getTime();
        date.setHours(hours);
        calendar.setTime(date);
    }

    private static void setMinutes(Calendar calendar, int minutes) {
        if (calendar == null) {
            return;
        }
        Date date = calendar.getTime();
        date.setMinutes(minutes);
        calendar.setTime(date);
    }

    private static void setSeconds(Calendar calendar, int seconds) {
        if (calendar == null) {
            return;
        }
        Date date = calendar.getTime();
        date.setSeconds(seconds);
        calendar.setTime(date);
    }

    private static class StyleableProperties {
        private static final CssMetaData<CalendarTimePicker, ShowTickLabels> SHOW_TICKLABELS = new CssMetaDataForSkinProperty<CalendarTimePicker, CalendarTimePickerSkin, ShowTickLabels>("-fxx-show-ticklabels", (StyleConverter)new EnumConverter(ShowTickLabels.class), ShowTickLabels.NO){

            protected ObjectProperty<ShowTickLabels> getProperty(CalendarTimePickerSkin s) {
                return s.showTickLabelsProperty();
            }
        };
        private static final CssMetaData<CalendarTimePicker, DateFormat> LABEL_DATEFORMAT = new CssMetaDataForSkinProperty<CalendarTimePicker, CalendarTimePickerSkin, DateFormat>("-fxx-label-dateformat", (StyleConverter)new SimpleDateFormatConverter(), null){

            protected ObjectProperty<DateFormat> getProperty(CalendarTimePickerSkin s) {
                return s.labelDateFormatProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(SHOW_TICKLABELS);
            styleables.add(LABEL_DATEFORMAT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum ShowTickLabels {
        YES,
        NO;

    }
}

