/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin;
import jfxtras.internal.scene.control.skin.TextFieldSkin;
import jfxtras.scene.control.CalendarPicker;

public class CalendarTextField
extends Control {
    private final InvalidationListener focusInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            CalendarTextField.this.setFocused(((CalendarTextFieldSkin)CalendarTextField.this.getSkin()).focusForwardingProperty.get());
        }
    };
    private final ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty((Object)this, "calendar", null);
    private final ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty<Locale>(Locale.getDefault()){

        public void set(Locale value) {
            super.set((Object)value);
            if (!CalendarTextField.this.dateFormatManual) {
                CalendarTextField.this.setDateFormat(CalendarTextField.this.getShowTime() != false ? SimpleDateFormat.getDateTimeInstance(2, 1, value) : SimpleDateFormat.getDateInstance(1, value));
            }
        }
    };
    private volatile ObjectProperty<Boolean> showTimeObjectProperty = new SimpleObjectProperty<Boolean>((Object)this, "showTime", Boolean.valueOf(false)){

        public void set(Boolean value) {
            super.set((Object)value);
            if (!CalendarTextField.this.dateFormatManual) {
                CalendarTextField.this.setDateFormat(CalendarTextField.this.getShowTime() != false ? SimpleDateFormat.getDateTimeInstance(2, 1, CalendarTextField.this.getLocale()) : SimpleDateFormat.getDateInstance(1, CalendarTextField.this.getLocale()));
            }
        }
    };
    private final ObjectProperty<DateFormat> dateFormatObjectProperty = new SimpleObjectProperty<DateFormat>((Object)this, "dateFormat", SimpleDateFormat.getDateInstance(1, this.getLocale())){

        public void set(DateFormat value) {
            super.set((Object)(value != null ? value : (CalendarTextField.this.getShowTime() != false ? SimpleDateFormat.getDateTimeInstance(2, 1, CalendarTextField.this.getLocale()) : SimpleDateFormat.getDateInstance(1, CalendarTextField.this.getLocale()))));
            CalendarTextField.this.dateFormatManual = value != null;
        }
    };
    private boolean dateFormatManual = false;
    private final ObjectProperty<String> promptTextObjectProperty = new SimpleObjectProperty((Object)this, "promptText", null);
    ListProperty<DateFormat> dateFormatsProperty = new SimpleListProperty(FXCollections.observableList(new ArrayList()));
    private final ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackObjectProperty = new SimpleObjectProperty((Object)this, "parseErrorCallback", null);
    private final ObservableList<Calendar> highlightedCalendars = FXCollections.observableArrayList();
    private final ObservableList<Calendar> disabledCalendars = FXCollections.observableArrayList();
    private final ObjectProperty<Callback<CalendarPicker.CalendarRange, Void>> calendarRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "calendarRangeCallback", null);
    private final ObjectProperty<Callback<Calendar, Boolean>> valueValidationCallbackObjectProperty = new SimpleObjectProperty((Object)this, "valueValidationCallback", null);
    private volatile ObjectProperty<Calendar> displayedCalendarObjectProperty = new SimpleObjectProperty((Object)this, "displayedCalendar");
    private volatile BooleanProperty allowNullProperty = new SimpleBooleanProperty((Object)this, "allowNull", true){

        public void set(boolean value) {
            super.set(value);
            if (!value && CalendarTextField.this.getCalendar() == null) {
                CalendarTextField.this.setCalendar(Calendar.getInstance(CalendarTextField.this.getLocale()));
            }
        }
    };
    private final ObjectProperty<String> textObjectProperty = new SimpleObjectProperty((Object)this, "text", null);
    private final BooleanProperty pickerShowingProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty editableProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty immediateProperty = new SimpleBooleanProperty(false);

    public CalendarTextField() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)CalendarTextField.class.getSimpleName());
        this.setFocusTraversable(false);
        this.skinProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue instanceof CalendarTextFieldSkin) {
                ((CalendarTextFieldSkin)oldValue).focusForwardingProperty.removeListener(this.focusInvalidationListener);
            }
            if (newValue instanceof CalendarTextFieldSkin) {
                ((CalendarTextFieldSkin)newValue).focusForwardingProperty.addListener(this.focusInvalidationListener);
            }
        });
        this.constructDisplayedCalendar();
    }

    public String getUserAgentStylesheet() {
        return CalendarTextField.class.getResource("/jfxtras/internal/scene/control/" + CalendarTextField.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new CalendarTextFieldSkin(this);
    }

    public void selectAll() {
        if (this.getSkin() != null && this.getSkin() instanceof TextFieldSkin) {
            ((TextFieldSkin)this.getSkin()).selectAll();
        }
    }

    public CalendarTextField withId(String value) {
        this.setId(value);
        return this;
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendarObjectProperty;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.calendarObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<Boolean> showTimeProperty() {
        return this.showTimeObjectProperty;
    }

    public Boolean getShowTime() {
        return (Boolean)this.showTimeObjectProperty.getValue();
    }

    public void setShowTime(Boolean value) {
        this.showTimeObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withShowTime(Boolean value) {
        this.setShowTime(value);
        return this;
    }

    public ObjectProperty<DateFormat> dateFormatProperty() {
        return this.dateFormatObjectProperty;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormatObjectProperty.getValue();
    }

    public void setDateFormat(DateFormat value) {
        this.dateFormatObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withDateFormat(DateFormat value) {
        this.setDateFormat(value);
        return this;
    }

    public ObjectProperty<String> promptTextProperty() {
        return this.promptTextObjectProperty;
    }

    public String getPromptText() {
        return (String)this.promptTextObjectProperty.get();
    }

    public void setPromptText(String value) {
        this.promptTextObjectProperty.set((Object)value);
    }

    public CalendarTextField withPromptText(String value) {
        this.setPromptText(value);
        return this;
    }

    public ListProperty<DateFormat> dateFormatsProperty() {
        return this.dateFormatsProperty;
    }

    public ObservableList<DateFormat> getDateFormats() {
        return this.dateFormatsProperty.getValue();
    }

    public void setDateFormats(ObservableList<DateFormat> value) {
        this.dateFormatsProperty.setValue(value);
    }

    public CalendarTextField withDateFormat(ObservableList<DateFormat> value) {
        this.setDateFormats(value);
        return this;
    }

    public ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackProperty() {
        return this.parseErrorCallbackObjectProperty;
    }

    public Callback<Throwable, Void> getParseErrorCallback() {
        return (Callback)this.parseErrorCallbackObjectProperty.getValue();
    }

    public void setParseErrorCallback(Callback<Throwable, Void> value) {
        this.parseErrorCallbackObjectProperty.setValue(value);
    }

    public CalendarTextField withParseErrorCallback(Callback<Throwable, Void> value) {
        this.setParseErrorCallback(value);
        return this;
    }

    public ObservableList<Calendar> highlightedCalendars() {
        return this.highlightedCalendars;
    }

    public ObservableList<Calendar> disabledCalendars() {
        return this.disabledCalendars;
    }

    public ObjectProperty<Callback<CalendarPicker.CalendarRange, Void>> calendarRangeCallbackProperty() {
        return this.calendarRangeCallbackObjectProperty;
    }

    public Callback<CalendarPicker.CalendarRange, Void> getCalendarRangeCallback() {
        return (Callback)this.calendarRangeCallbackObjectProperty.getValue();
    }

    public void setCalendarRangeCallback(Callback<CalendarPicker.CalendarRange, Void> value) {
        this.calendarRangeCallbackObjectProperty.setValue(value);
    }

    public CalendarTextField withCalendarRangeCallback(Callback<CalendarPicker.CalendarRange, Void> value) {
        this.setCalendarRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<Calendar, Boolean>> valueValidationCallbackProperty() {
        return this.valueValidationCallbackObjectProperty;
    }

    public Callback<Calendar, Boolean> getValueValidationCallback() {
        return (Callback)this.valueValidationCallbackObjectProperty.getValue();
    }

    public void setValueValidationCallback(Callback<Calendar, Boolean> value) {
        this.valueValidationCallbackObjectProperty.setValue(value);
    }

    public CalendarTextField withValueValidationCallback(Callback<Calendar, Boolean> value) {
        this.setValueValidationCallback(value);
        return this;
    }

    public ObjectProperty<Calendar> displayedCalendar() {
        return this.displayedCalendarObjectProperty;
    }

    public Calendar getDisplayedCalendar() {
        return (Calendar)this.displayedCalendarObjectProperty.getValue();
    }

    public void setDisplayedCalendar(Calendar value) {
        this.displayedCalendarObjectProperty.setValue((Object)value);
    }

    public CalendarTextField withDisplayedCalendar(Calendar value) {
        this.setDisplayedCalendar(value);
        return this;
    }

    private void constructDisplayedCalendar() {
        this.setDisplayedCalendar(Calendar.getInstance(this.getLocale()));
    }

    public BooleanProperty allowNullProperty() {
        return this.allowNullProperty;
    }

    public boolean getAllowNull() {
        return this.allowNullProperty.get();
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNullProperty.set(allowNull);
    }

    public CalendarTextField withAllowNull(boolean value) {
        this.setAllowNull(value);
        return this;
    }

    public ObjectProperty<String> textProperty() {
        return this.textObjectProperty;
    }

    public String getText() {
        return (String)this.textObjectProperty.get();
    }

    public void setText(String value) {
        this.textObjectProperty.set((Object)value);
    }

    public CalendarTextField withText(String value) {
        this.setText(value);
        return this;
    }

    public BooleanProperty pickerShowingProperty() {
        return this.pickerShowingProperty;
    }

    public boolean isPickerShowing() {
        return this.pickerShowingProperty.get();
    }

    public void setPickerShowing(boolean value) {
        this.pickerShowingProperty.set(value);
    }

    public CalendarTextField withPickerShowing(boolean value) {
        this.setPickerShowing(value);
        return this;
    }

    public BooleanProperty editableProperty() {
        return this.editableProperty;
    }

    public boolean isEditable() {
        return this.editableProperty.get();
    }

    public void setEditable(boolean value) {
        this.editableProperty.set(value);
    }

    public CalendarTextField withEditable(boolean value) {
        this.setEditable(value);
        return this;
    }

    public BooleanProperty immediateProperty() {
        return this.immediateProperty;
    }

    public boolean isImmediate() {
        return this.immediateProperty.get();
    }

    public void setImmediate(boolean value) {
        this.immediateProperty.set(value);
    }

    public CalendarTextField withImmediate(boolean value) {
        this.setImmediate(value);
        return this;
    }
}

