/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import com.sun.javafx.css.converters.EnumConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.css.converters.SimpleDateFormatConverter;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$1;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$2;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$3;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$4;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$5;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$6;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$7;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$8;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$$Lambda$9;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$3$$Lambda$1;
import jfxtras.internal.scene.control.skin.CalendarPickerControlSkin$4$$Lambda$1;
import jfxtras.internal.scene.control.skin.CalendarPickerMonthlySkinAbstract;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.CalendarTimePicker;
import jfxtras.scene.control.ListSpinner;
import jfxtras.scene.control.ListSpinnerIntegerList;
import jfxtras.scene.layout.GridPane;
import jfxtras.util.NodeUtil;

public class CalendarPickerControlSkin
extends CalendarPickerMonthlySkinAbstract<CalendarPickerControlSkin> {
    private ObjectProperty<ShowWeeknumbers> showWeeknumbers = new SimpleStyleableObjectProperty<ShowWeeknumbers>(StyleableProperties.access$100(), (Object)this, "showWeeknumbers", (ShowWeeknumbers)((Object)StyleableProperties.access$100().getInitialValue(null))){
        {
            this.addListener(CalendarPickerControlSkin$3$$Lambda$1.lambdaFactory$(this));
        }

        private /* synthetic */ void lambda$new$7(Observable invalidationEvent) {
            CalendarPickerControlSkin.this.layoutNodes();
        }

        static /* synthetic */ void access$lambda$0(3 var0, Observable observable) {
            var0.lambda$new$7(observable);
        }
    };
    private ObjectProperty<DateFormat> labelDateFormat = new SimpleStyleableObjectProperty<DateFormat>(StyleableProperties.access$300(), (Object)this, "labelDateFormat", (DateFormat)StyleableProperties.access$300().getInitialValue(null)){
        {
            this.addListener(CalendarPickerControlSkin$4$$Lambda$1.lambdaFactory$(this));
        }

        private /* synthetic */ void lambda$new$8(Observable invalidationEvent) {
            CalendarPickerControlSkin.this.refreshDayButtonsVisibilityAndLabel();
        }

        static /* synthetic */ void access$lambda$0(4 var0, Observable observable) {
            var0.lambda$new$8(observable);
        }
    };
    private static final SimpleDateFormat ID_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private ListSpinner<String> monthListSpinner = null;
    private ListSpinner<Integer> yearListSpinner = null;
    private Button todayButton = new Button("   ");
    private final List<Label> weekdayLabels = new ArrayList<Label>();
    private final List<Label> weeknumberLabels = new ArrayList<Label>();
    private final List<ToggleButton> dayButtons = new ArrayList<ToggleButton>();
    private final CalendarTimePicker timePicker = new CalendarTimePicker();
    private final Map<BooleanProperty, ToggleButton> booleanPropertyToDayToggleButtonMap = new WeakHashMap<BooleanProperty, ToggleButton>();
    private final EventHandler<MouseEvent> toggleButtonMouseReleasedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            ToggleButton lToggleButton = (ToggleButton)event.getSource();
            CalendarPickerControlSkin.this.toggle(lToggleButton, event.isShiftDown());
        }
    };
    private final EventHandler<KeyEvent> toggleButtonKeyReleasedPropertyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            ToggleButton lToggleButton = (ToggleButton)event.getSource();
            if (" ".equals(event.getText())) {
                CalendarPickerControlSkin.this.toggle(lToggleButton, event.isShiftDown());
            }
        }
    };
    private final EventHandler<MouseEvent> weekdayLabelMouseClickedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE) {
                return;
            }
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                return;
            }
            int lColIdx = (Integer)((Label)event.getSource()).getUserData();
            for (int lRowIdx = 0; lRowIdx < 6; ++lRowIdx) {
                int lIdx = lRowIdx * 7 + lColIdx;
                ToggleButton lToggleButton = (ToggleButton)CalendarPickerControlSkin.this.dayButtons.get(lIdx);
                if (!lToggleButton.isVisible()) continue;
                CalendarPickerControlSkin.this.toggle(lToggleButton, false);
            }
        }
    };
    private final EventHandler<MouseEvent> weeknumerLabelMouseClickedPropertyEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE) {
                return;
            }
            if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                ((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).calendars().clear();
            }
            int lRowIdx = (Integer)((Label)event.getSource()).getUserData();
            for (int i = lRowIdx * 7; i < lRowIdx * 7 + 7; ++i) {
                ToggleButton lToggleButton = (ToggleButton)CalendarPickerControlSkin.this.dayButtons.get(i);
                if (((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) {
                    Calendar lCalendar = CalendarPickerControlSkin.this.calendarForToggleButton(lToggleButton);
                    if (!CalendarPickerControlSkin.this.callValueValidationCallback(lCalendar)) continue;
                    ((CalendarPicker)CalendarPickerControlSkin.this.getSkinnable()).calendars().add((Object)lCalendar);
                    continue;
                }
                CalendarPickerControlSkin.this.toggle(lToggleButton, false);
            }
        }
    };
    private Calendar iLastSelected = null;
    private final AtomicInteger iRefreshingSelection = new AtomicInteger(0);

    public CalendarPickerControlSkin(CalendarPicker control) {
        super(control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        this.layoutNodes();
        ((CalendarPicker)this.getSkinnable()).calendarProperty().addListener(CalendarPickerControlSkin$$Lambda$1.lambdaFactory$(this));
        if (((CalendarPicker)this.getSkinnable()).getCalendar() != null) {
            ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(((CalendarPicker)this.getSkinnable()).getCalendar());
        }
        ((CalendarPicker)this.getSkinnable()).calendars().addListener(CalendarPickerControlSkin$$Lambda$2.lambdaFactory$(this));
        ((CalendarPicker)this.getSkinnable()).localeProperty().addListener(CalendarPickerControlSkin$$Lambda$3.lambdaFactory$(this));
        ((CalendarPicker)this.getSkinnable()).showTimeProperty().addListener(CalendarPickerControlSkin$$Lambda$4.lambdaFactory$(this));
        ((CalendarPicker)this.getSkinnable()).disabledCalendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> change) {
                CalendarPickerControlSkin.this.refreshDayButtonsVisibilityAndLabel();
            }
        });
        ((CalendarPicker)this.getSkinnable()).highlightedCalendars().addListener((ListChangeListener)new ListChangeListener<Calendar>(){

            public void onChanged(ListChangeListener.Change<? extends Calendar> arg0) {
                CalendarPickerControlSkin.this.refreshDayButtonsVisibilityAndLabel();
            }
        });
        ((CalendarPicker)this.getSkinnable()).displayedCalendar().addListener(CalendarPickerControlSkin$$Lambda$5.lambdaFactory$(this));
        this.refresh();
    }

    private Calendar deriveDisplayedCalendar(Calendar displayedCalendar) {
        Calendar lCalendar = Calendar.getInstance(((CalendarPicker)this.getSkinnable()).getLocale());
        lCalendar.set(5, 1);
        lCalendar.set(2, displayedCalendar.get(2));
        lCalendar.set(1, displayedCalendar.get(1));
        lCalendar.set(11, 0);
        lCalendar.set(12, 0);
        lCalendar.set(13, 0);
        lCalendar.set(14, 0);
        return lCalendar;
    }

    public final ObjectProperty<ShowWeeknumbers> showWeeknumbersProperty() {
        return this.showWeeknumbers;
    }

    public final void setShowWeeknumbers(ShowWeeknumbers value) {
        this.showWeeknumbersProperty().set((Object)value);
    }

    public final ShowWeeknumbers getShowWeeknumbers() {
        return (ShowWeeknumbers)((Object)this.showWeeknumbers.get());
    }

    public final CalendarPickerControlSkin withShowWeeknumbers(ShowWeeknumbers value) {
        this.setShowWeeknumbers(value);
        return this;
    }

    public final ObjectProperty<DateFormat> labelDateFormatProperty() {
        return this.labelDateFormat;
    }

    public final void setLabelDateFormat(DateFormat value) {
        this.labelDateFormatProperty().set((Object)value);
    }

    public final DateFormat getLabelDateFormat() {
        return (DateFormat)this.labelDateFormat.get();
    }

    public final CalendarPickerControlSkin withLabelDateFormat(DateFormat value) {
        this.setLabelDateFormat(value);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CalendarPickerControlSkin.getClassCssMetaData();
    }

    private void createNodes() {
        Label lLabel;
        int i;
        ColumnConstraints lColumnConstraintsAlwaysGrow = new ColumnConstraints();
        lColumnConstraintsAlwaysGrow.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnConstraintsNeverGrow = new ColumnConstraints();
        lColumnConstraintsNeverGrow.setHgrow(Priority.NEVER);
        List<String> lMonthLabels = this.getMonthLabels();
        this.monthListSpinner = new ListSpinner<String>(lMonthLabels).withIndex(Calendar.getInstance().get(2)).withCyclic(Boolean.TRUE);
        this.monthListSpinner.setId("monthListSpinner");
        this.monthListSpinner.setOnCycle((EventHandler<ListSpinner.CycleEvent>)CalendarPickerControlSkin$$Lambda$6.lambdaFactory$(this));
        this.monthListSpinner.valueProperty().addListener(CalendarPickerControlSkin$$Lambda$7.lambdaFactory$(this));
        this.yearListSpinner = new ListSpinner<Integer>(new ListSpinnerIntegerList()).withValue(Calendar.getInstance().get(1));
        this.yearListSpinner.setId("yearListSpinner");
        this.yearListSpinner.valueProperty().addListener(CalendarPickerControlSkin$$Lambda$8.lambdaFactory$(this));
        this.todayButton = new Button("   ");
        this.todayButton.getStyleClass().add((Object)"today-button");
        this.todayButton.setMinSize(16.0, 16.0);
        this.todayButton.setOnAction(CalendarPickerControlSkin$$Lambda$9.lambdaFactory$(this));
        for (i = 0; i < 7; ++i) {
            lLabel = new Label("" + i);
            lLabel.getStyleClass().add((Object)"weekday-label");
            lLabel.setMaxWidth(2.147483647E9);
            lLabel.setUserData((Object)i);
            lLabel.onMouseClickedProperty().set(this.weekdayLabelMouseClickedPropertyEventHandler);
            this.weekdayLabels.add(lLabel);
        }
        for (i = 0; i < 6; ++i) {
            lLabel = new Label("" + i);
            lLabel.getStyleClass().add((Object)"weeknumber");
            lLabel.setAlignment(Pos.BASELINE_RIGHT);
            this.weeknumberLabels.add(lLabel);
            lLabel.setUserData((Object)i);
            lLabel.onMouseClickedProperty().set(this.weeknumerLabelMouseClickedPropertyEventHandler);
        }
        for (i = 0; i < 42; ++i) {
            ToggleButton lToggleButton = new ToggleButton("" + i);
            lToggleButton.setId("day" + i);
            lToggleButton.getStyleClass().add((Object)"day-button");
            lToggleButton.onMouseReleasedProperty().set(this.toggleButtonMouseReleasedPropertyEventHandler);
            lToggleButton.onKeyReleasedProperty().set(this.toggleButtonKeyReleasedPropertyEventHandler);
            this.booleanPropertyToDayToggleButtonMap.put(lToggleButton.selectedProperty(), lToggleButton);
            lToggleButton.setMaxWidth(Double.MAX_VALUE);
            lToggleButton.setAlignment(Pos.BASELINE_CENTER);
            this.dayButtons.add(lToggleButton);
        }
        Bindings.bindBidirectional(this.timePicker.calendarProperty(), ((CalendarPicker)this.getSkinnable()).calendarProperty());
        Bindings.bindBidirectional(this.timePicker.valueValidationCallbackProperty(), ((CalendarPicker)this.getSkinnable()).valueValidationCallbackProperty());
        Bindings.bindBidirectional(this.timePicker.localeProperty(), ((CalendarPicker)this.getSkinnable()).localeProperty());
        ((CalendarPicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    private void layoutNodes() {
        int i;
        this.getChildren().clear();
        GridPane gridPane = new GridPane();
        gridPane = new GridPane();
        gridPane.setVgap(2.0);
        gridPane.setHgap(2.0);
        this.getChildren().add((Object)gridPane);
        boolean lShowWeeknumbers = ShowWeeknumbers.YES.equals((Object)this.getShowWeeknumbers());
        int lWeeknumbersCols = lShowWeeknumbers ? 1 : 0;
        ColumnConstraints lColumnConstraintsAlwaysGrow = new ColumnConstraints();
        lColumnConstraintsAlwaysGrow.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnConstraintsNeverGrow = new ColumnConstraints();
        lColumnConstraintsNeverGrow.setHgrow(Priority.NEVER);
        if (lShowWeeknumbers) {
            gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnConstraintsNeverGrow});
        }
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow, lColumnConstraintsAlwaysGrow});
        gridPane.add(this.monthListSpinner, new GridPane.C().col(lWeeknumbersCols).row(0).colSpan(4).rowSpan(1));
        gridPane.add(this.yearListSpinner, new GridPane.C().col(lWeeknumbersCols + 4).row(0).colSpan(3).rowSpan(1));
        if (lShowWeeknumbers) {
            gridPane.add((Node)this.todayButton, new GridPane.C().col(0).row(1));
        }
        for (i = 0; i < 7; ++i) {
            gridPane.add((Node)this.weekdayLabels.get(i), new GridPane.C().col(lWeeknumbersCols + i).row(1));
        }
        if (lShowWeeknumbers) {
            for (i = 0; i < 6; ++i) {
                gridPane.add((Node)this.weeknumberLabels.get(i), new GridPane.C().col(0).row(i + 2).margin(new Insets(0.0, 0.0, 0.0, 0.0)));
            }
        }
        for (i = 0; i < 42; ++i) {
            gridPane.add((Node)this.dayButtons.get(i), new GridPane.C().col(lWeeknumbersCols + i % 7).row(i / 7 + 2));
        }
        if (((CalendarPicker)this.getSkinnable()).getMode().equals((Object)CalendarPicker.Mode.SINGLE) && ((Boolean)((CalendarPicker)this.getSkinnable()).showTimeProperty().get()).booleanValue()) {
            gridPane.add((Node)this.timePicker, new GridPane.C().col(lWeeknumbersCols).row(8).colSpan(7).rowSpan(1));
        }
    }

    private Calendar calendarForToggleButton(ToggleButton toggleButton) {
        int lDayToggleButtonIdx = this.dayButtons.indexOf(toggleButton);
        int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        int lDayOfMonth = lDayToggleButtonIdx - lFirstOfMonthIdx + 1;
        Calendar lToggledCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lToggledCalendar.set(1, ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().get(1));
        lToggledCalendar.set(2, ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().get(2));
        lToggledCalendar.set(5, lDayOfMonth);
        if (this.timePicker.isVisible() && this.timePicker.getCalendar() != null) {
            lToggledCalendar.set(11, this.timePicker.getCalendar().get(11));
            lToggledCalendar.set(12, this.timePicker.getCalendar().get(12));
            lToggledCalendar.set(13, this.timePicker.getCalendar().get(13));
        }
        return lToggledCalendar;
    }

    private void toggle(ToggleButton toggleButton, boolean shiftIsPressed) {
        Calendar lToggledCalendar = this.calendarForToggleButton(toggleButton);
        ObservableList<Calendar> lCalendars = ((CalendarPicker)this.getSkinnable()).calendars();
        Calendar lFoundCalendar = this.find((List<Calendar>)lCalendars, lToggledCalendar);
        if (lFoundCalendar == null) {
            if ((((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.SINGLE || ((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE && !shiftIsPressed) && this.callValueValidationCallback(lToggledCalendar)) {
                lCalendars.add(lToggledCalendar);
                while (lCalendars.size() > 1) {
                    lCalendars.remove(0);
                }
            }
            if (((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.MULTIPLE && !shiftIsPressed && this.callValueValidationCallback(lToggledCalendar)) {
                lCalendars.add(lToggledCalendar);
            }
            if ((((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.MULTIPLE || ((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) && shiftIsPressed && this.iLastSelected != null) {
                Calendar lOtherCalendar = this.iLastSelected;
                int lDirection = lOtherCalendar.after(lToggledCalendar) ? -1 : 1;
                Calendar lWalker = (Calendar)lOtherCalendar.clone();
                lWalker.add(5, lDirection);
                Calendar lTarget = (Calendar)lToggledCalendar.clone();
                lTarget.add(5, lDirection);
                while (!lWalker.equals(lTarget)) {
                    if (this.callValueValidationCallback(lWalker)) {
                        lCalendars.add((Calendar)lWalker.clone());
                    } else if (((CalendarPicker)this.getSkinnable()).getMode() == CalendarPicker.Mode.RANGE) break;
                    lWalker.add(5, lDirection);
                }
            }
            this.iLastSelected = (Calendar)lToggledCalendar.clone();
        } else {
            Calendar lCalendar;
            if (lCalendars.size() == 1 && !((CalendarPicker)this.getSkinnable()).getAllowNull() && this.callValueValidationCallback(lCalendar = (Calendar)lFoundCalendar.clone())) {
                ((CalendarPicker)this.getSkinnable()).setCalendar(lCalendar);
            }
            if (lCalendars.size() > 1 || ((CalendarPicker)this.getSkinnable()).getAllowNull()) {
                lCalendars.remove(lFoundCalendar);
                this.iLastSelected = null;
            }
        }
        this.refreshDayButtonToggleState();
    }

    private void setDisplayedCalendarFromSpinners() {
        int lYear = this.yearListSpinner.getValue();
        int lMonth = this.monthListSpinner.getIndex();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lCalendar.set(1, lYear);
        lCalendar.set(2, lMonth);
        lCalendar = this.deriveDisplayedCalendar(lCalendar);
        ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(lCalendar);
    }

    private void setDisplayedCalendarToToday() {
        Calendar lTodayCalendar = Calendar.getInstance();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lCalendar.set(1, lTodayCalendar.get(1));
        lCalendar.set(2, lTodayCalendar.get(2));
        ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(lCalendar);
    }

    @Override
    protected void refresh() {
        this.calendarRangeCallback();
        this.refreshSpinner();
        this.refreshWeekdayLabels();
        this.refreshWeeknumberLabels();
        this.refreshDayButtonsVisibilityAndLabel();
        this.refreshDayButtonToggleState();
    }

    private void refreshSpinner() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        Calendar lCalendar = ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar();
        List<String> lMonthLabels = this.getMonthLabels();
        String lMonthLabel = lMonthLabels.get(lCalendar.get(2));
        this.monthListSpinner.setValue(lMonthLabel);
        this.yearListSpinner.setValue(lCalendar.get(1));
    }

    private void refreshWeekdayLabels() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        List<String> lWeekdayLabels = this.getWeekdayLabels();
        for (int i = 0; i < this.weekdayLabels.size(); ++i) {
            Label lLabel = this.weekdayLabels.get(i);
            lLabel.setText(lWeekdayLabels.get(i));
            if (this.isWeekdayWeekend(i)) {
                NodeUtil.removeStyleClass((Node)lLabel, (String)"weekday");
                NodeUtil.addStyleClass((Node)lLabel, (String)"weekend");
                continue;
            }
            NodeUtil.removeStyleClass((Node)lLabel, (String)"weekend");
            NodeUtil.addStyleClass((Node)lLabel, (String)"weekday");
        }
    }

    private void refreshWeeknumberLabels() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        List<Integer> lWeeknumbers = this.getWeeknumbers();
        for (int i = 0; i < lWeeknumbers.size(); ++i) {
            Label lLabel = this.weeknumberLabels.get(i);
            lLabel.setText((lWeeknumbers.get(i) < 10 ? "0" : "") + lWeeknumbers.get(i).toString());
        }
    }

    private void refreshDayButtonsVisibilityAndLabel() {
        int i;
        int i2;
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        ObservableList<Calendar> highlightedCalendars = ((CalendarPicker)this.getSkinnable()).highlightedCalendars();
        ObservableList<Calendar> disabledCalendars = ((CalendarPicker)this.getSkinnable()).disabledCalendars();
        int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
        for (i2 = 0; i2 < lFirstOfMonthIdx; ++i2) {
            ToggleButton lToggleButton = this.dayButtons.get(i2);
            lToggleButton.setVisible(false);
            lToggleButton.setId("day" + i2);
        }
        for (i2 = 1; i2 < 6; ++i2) {
            this.weeknumberLabels.get(i2).setVisible(false);
        }
        int lDaysInMonth = this.determineDaysInMonth();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        for (i = 1; i <= lDaysInMonth; ++i) {
            lCalendar.set(5, i);
            int lIdx = lFirstOfMonthIdx + i - 1;
            ToggleButton lToggleButton = this.dayButtons.get(lIdx);
            lToggleButton.setId(ID_DATEFORMAT.format(lCalendar.getTime()));
            lToggleButton.setVisible(true);
            lToggleButton.setText(this.getLabelDateFormat().format(lCalendar.getTime()));
            lToggleButton.setAlignment(Pos.BASELINE_CENTER);
            if (this.isWeekdayWeekend(lIdx % 7)) {
                NodeUtil.addStyleClass((Node)lToggleButton, (String)"weekend");
                NodeUtil.removeStyleClass((Node)lToggleButton, (String)"weekday");
            } else {
                NodeUtil.addStyleClass((Node)lToggleButton, (String)"weekday");
                NodeUtil.removeStyleClass((Node)lToggleButton, (String)"weekend");
            }
            lToggleButton.setDisable(disabledCalendars != null && this.find((List<Calendar>)disabledCalendars, lCalendar) != null);
            this.weeknumberLabels.get(lIdx / 7).setVisible(true);
            if (this.isToday(lCalendar)) {
                NodeUtil.addStyleClass((Node)lToggleButton, (String)"today");
            } else {
                NodeUtil.removeStyleClass((Node)lToggleButton, (String)"today");
            }
            if (highlightedCalendars != null && this.find((List<Calendar>)highlightedCalendars, lCalendar) != null) {
                NodeUtil.addStyleClass((Node)lToggleButton, (String)"highlight");
                continue;
            }
            NodeUtil.removeStyleClass((Node)lToggleButton, (String)"highlight");
        }
        for (i = lFirstOfMonthIdx + lDaysInMonth; i < 42; ++i) {
            ToggleButton lToggleButton = this.dayButtons.get(i);
            lToggleButton.setVisible(false);
            lToggleButton.setId("day" + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDayButtonToggleState() {
        if (this.calendarRangeCallbackAtomicInteger.get() != 0) {
            return;
        }
        this.iRefreshingSelection.addAndGet(1);
        try {
            int lFirstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
            ObservableList<Calendar> lCalendars = ((CalendarPicker)this.getSkinnable()).calendars();
            int lDaysInMonth = this.determineDaysInMonth();
            Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
            for (int i = 1; i <= lDaysInMonth; ++i) {
                lCalendar.set(5, i);
                int lIdx = lFirstOfMonthIdx + i - 1;
                boolean lSelected = this.find((List<Calendar>)lCalendars, lCalendar) != null;
                ToggleButton lToggleButton = this.dayButtons.get(lIdx);
                if (lSelected == lToggleButton.isSelected()) continue;
                lToggleButton.setSelected(lSelected);
            }
        }
        finally {
            this.iRefreshingSelection.addAndGet(-1);
        }
    }

    private Calendar find(List<Calendar> calendars, Calendar calendar) {
        for (Calendar c : calendars) {
            if (c.get(1) != calendar.get(1) || c.get(2) != calendar.get(2) || c.get(5) != calendar.get(5)) continue;
            return c;
        }
        return null;
    }

    private boolean callValueValidationCallback(Calendar value) {
        Callback<Calendar, Boolean> lCallback = ((CalendarPicker)this.getSkinnable()).getValueValidationCallback();
        if (lCallback == null) {
            return true;
        }
        return (Boolean)lCallback.call(value == null ? null : (Calendar)value.clone());
    }

    private /* synthetic */ void lambda$createNodes$12(ActionEvent event) {
        this.setDisplayedCalendarToToday();
    }

    private /* synthetic */ void lambda$createNodes$11(ObservableValue observable, Integer oldValue, Integer newValue) {
        this.setDisplayedCalendarFromSpinners();
    }

    private /* synthetic */ void lambda$createNodes$10(ObservableValue observable, String oldValue, String newValue) {
        this.setDisplayedCalendarFromSpinners();
    }

    private /* synthetic */ void lambda$createNodes$9(ListSpinner.CycleEvent cycleEvent) {
        if (cycleEvent.cycledDown()) {
            this.yearListSpinner.increment();
        } else {
            this.yearListSpinner.decrement();
        }
    }

    private /* synthetic */ void lambda$construct$6(Observable observable) {
        this.refresh();
    }

    private /* synthetic */ void lambda$construct$5(Observable observable) {
        this.layoutNodes();
    }

    private /* synthetic */ void lambda$construct$4(Observable observable) {
        this.monthListSpinner.setItems((ObservableList<String>)FXCollections.observableArrayList(this.getMonthLabels()));
        ((CalendarPicker)this.getSkinnable()).displayedCalendar().set((Object)((Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone()));
        this.refresh();
    }

    private /* synthetic */ void lambda$construct$3(Observable observable) {
        this.refreshDayButtonToggleState();
    }

    private /* synthetic */ void lambda$construct$2(Observable observable) {
        Calendar calendar = ((CalendarPicker)this.getSkinnable()).getCalendar();
        Calendar displayedCalendar = ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar();
        if (calendar != null && (displayedCalendar == null || calendar.get(1) != displayedCalendar.get(1) || calendar.get(2) != displayedCalendar.get(2))) {
            ((CalendarPicker)this.getSkinnable()).setDisplayedCalendar(calendar);
        }
    }

    static /* synthetic */ void access$lambda$0(CalendarPickerControlSkin calendarPickerControlSkin, Observable observable) {
        calendarPickerControlSkin.lambda$construct$2(observable);
    }

    static /* synthetic */ void access$lambda$1(CalendarPickerControlSkin calendarPickerControlSkin, Observable observable) {
        calendarPickerControlSkin.lambda$construct$3(observable);
    }

    static /* synthetic */ void access$lambda$2(CalendarPickerControlSkin calendarPickerControlSkin, Observable observable) {
        calendarPickerControlSkin.lambda$construct$4(observable);
    }

    static /* synthetic */ void access$lambda$3(CalendarPickerControlSkin calendarPickerControlSkin, Observable observable) {
        calendarPickerControlSkin.lambda$construct$5(observable);
    }

    static /* synthetic */ void access$lambda$4(CalendarPickerControlSkin calendarPickerControlSkin, Observable observable) {
        calendarPickerControlSkin.lambda$construct$6(observable);
    }

    static /* synthetic */ void access$lambda$5(CalendarPickerControlSkin calendarPickerControlSkin, ListSpinner.CycleEvent cycleEvent) {
        calendarPickerControlSkin.lambda$createNodes$9(cycleEvent);
    }

    static /* synthetic */ void access$lambda$6(CalendarPickerControlSkin calendarPickerControlSkin, ObservableValue observableValue, String string, String string2) {
        calendarPickerControlSkin.lambda$createNodes$10(observableValue, string, string2);
    }

    static /* synthetic */ void access$lambda$7(CalendarPickerControlSkin calendarPickerControlSkin, ObservableValue observableValue, Integer n, Integer n2) {
        calendarPickerControlSkin.lambda$createNodes$11(observableValue, n, n2);
    }

    static /* synthetic */ void access$lambda$8(CalendarPickerControlSkin calendarPickerControlSkin, ActionEvent actionEvent) {
        calendarPickerControlSkin.lambda$createNodes$12(actionEvent);
    }

    private static class StyleableProperties {
        private static final CssMetaData<CalendarPicker, ShowWeeknumbers> SHOW_WEEKNUMBERS = new CssMetaDataForSkinProperty<CalendarPicker, CalendarPickerControlSkin, ShowWeeknumbers>("-fxx-show-weeknumbers", (StyleConverter)new EnumConverter(ShowWeeknumbers.class), ShowWeeknumbers.YES){

            protected ObjectProperty<ShowWeeknumbers> getProperty(CalendarPickerControlSkin s) {
                return s.showWeeknumbersProperty();
            }
        };
        private static final CssMetaData<CalendarPicker, DateFormat> LABEL_DATEFORMAT = new CssMetaDataForSkinProperty<CalendarPicker, CalendarPickerControlSkin, DateFormat>("-fxx-label-dateformat", (StyleConverter)new SimpleDateFormatConverter(), (DateFormat)new SimpleDateFormat("d")){

            protected ObjectProperty<DateFormat> getProperty(CalendarPickerControlSkin s) {
                return s.labelDateFormatProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$100() {
            return SHOW_WEEKNUMBERS;
        }

        static /* synthetic */ CssMetaData access$300() {
            return LABEL_DATEFORMAT;
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(SHOW_WEEKNUMBERS);
            styleables.add(LABEL_DATEFORMAT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum ShowWeeknumbers {
        YES,
        NO;

    }
}

