/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.Observable;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.CalendarPickerMonthlySkinAbstract$$Lambda$1;
import jfxtras.scene.control.CalendarPicker;

public abstract class CalendarPickerMonthlySkinAbstract<S>
extends SkinBase<CalendarPicker> {
    private static final List<String> sunWeekendDaysCountries = Arrays.asList("GQ", "IN", "TH", "UG");
    private static final List<String> fryWeekendDaysCountries = Arrays.asList("DJ", "IR");
    private static final List<String> frySunWeekendDaysCountries = Arrays.asList("BN");
    private static final List<String> thuFryWeekendDaysCountries = Arrays.asList("AF");
    private static final List<String> frySatWeekendDaysCountries = Arrays.asList("AE", "DZ", "BH", "BD", "EG", "IQ", "IL", "JO", "KW", "LY", "MV", "MR", "OM", "PS", "QA", "SA", "SD", "SY", "YE");
    private SimpleDateFormat simpleDateFormat = null;
    protected final AtomicInteger calendarRangeCallbackAtomicInteger = new AtomicInteger(0);

    public CalendarPickerMonthlySkinAbstract(CalendarPicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        ((CalendarPicker)this.getSkinnable()).localeProperty().addListener(CalendarPickerMonthlySkinAbstract$$Lambda$1.lambdaFactory$(this));
        this.refreshLocale();
    }

    private void refreshLocale() {
        this.simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1, ((CalendarPicker)this.getSkinnable()).getLocale());
    }

    protected abstract void refresh();

    protected void calendarRangeCallback() {
        if (((CalendarPicker)this.getSkinnable()).calendarRangeCallbackProperty().get() != null) {
            Calendar lStartCalendar = this.periodStartCalendar();
            Calendar lEndCalendar = this.periodEndCalendar();
            try {
                this.calendarRangeCallbackAtomicInteger.incrementAndGet();
                ((Callback)((CalendarPicker)this.getSkinnable()).calendarRangeCallbackProperty().get()).call((Object)new CalendarPicker.CalendarRange(lStartCalendar, lEndCalendar));
            }
            finally {
                this.calendarRangeCallbackAtomicInteger.decrementAndGet();
            }
        }
    }

    protected Calendar periodStartCalendar() {
        return (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
    }

    protected Calendar periodEndCalendar() {
        Calendar lEndCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lEndCalendar.add(2, 1);
        lEndCalendar.set(5, 1);
        lEndCalendar.add(5, -1);
        return lEndCalendar;
    }

    protected List<String> getWeekdayLabels() {
        ArrayList<String> lWeekdayLabels = new ArrayList<String>();
        this.simpleDateFormat.applyPattern("E");
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 6, 5);
        for (int i = 0; i < 7; ++i) {
            lCalendar.set(5, 4 + ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().getFirstDayOfWeek() + i);
            lWeekdayLabels.add(this.simpleDateFormat.format(lCalendar.getTime()));
        }
        return lWeekdayLabels;
    }

    protected List<Integer> getWeeknumbers() {
        ArrayList<Integer> lWeekLabels = new ArrayList<Integer>();
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        for (int i = 0; i <= 5; ++i) {
            lWeekLabels.add(lCalendar.get(3));
            lCalendar.add(5, 7);
        }
        return lWeekLabels;
    }

    protected List<String> getMonthLabels() {
        ArrayList<String> lMonthLabels = new ArrayList<String>();
        this.simpleDateFormat.applyPattern("MMMM");
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 0, 1);
        for (int i = 0; i < 12; ++i) {
            lCalendar.set(2, i);
            lMonthLabels.add(this.simpleDateFormat.format(lCalendar.getTime()));
        }
        return lMonthLabels;
    }

    protected boolean isWeekday(int idx, int weekdaynr) {
        GregorianCalendar lCalendar = new GregorianCalendar(2009, 6, 4 + ((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().getFirstDayOfWeek());
        ((Calendar)lCalendar).add(5, idx);
        int lDayOfWeek = lCalendar.get(7);
        return lDayOfWeek == weekdaynr;
    }

    protected boolean isWeekdayWeekend(int idx) {
        Locale locale = ((CalendarPicker)this.getSkinnable()).getLocale();
        if (thuFryWeekendDaysCountries.contains(locale.getCountry())) {
            return this.isWeekday(idx, 5) || this.isWeekday(idx, 6);
        }
        if (frySunWeekendDaysCountries.contains(locale.getCountry())) {
            return this.isWeekday(idx, 6) || this.isWeekday(idx, 1);
        }
        if (fryWeekendDaysCountries.contains(locale.getCountry())) {
            return this.isWeekday(idx, 6);
        }
        if (sunWeekendDaysCountries.contains(locale.getCountry())) {
            return this.isWeekday(idx, 1);
        }
        if (frySatWeekendDaysCountries.contains(locale.getCountry())) {
            return this.isWeekday(idx, 6) || this.isWeekday(idx, 7);
        }
        return this.isWeekday(idx, 7) || this.isWeekday(idx, 1);
    }

    protected int determineFirstOfMonthDayOfWeek() {
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lCalendar.set(5, 1);
        int lDayOfWeek = lCalendar.get(7);
        int lFirstDayOfWeek = lCalendar.getFirstDayOfWeek();
        int lFirstOfMonthIdx = lDayOfWeek - lFirstDayOfWeek;
        if (lFirstOfMonthIdx < 0) {
            lFirstOfMonthIdx += 7;
        }
        return lFirstOfMonthIdx;
    }

    protected int determineDaysInMonth() {
        Calendar lCalendar = (Calendar)((CalendarPicker)this.getSkinnable()).getDisplayedCalendar().clone();
        lCalendar.add(2, 1);
        lCalendar.set(5, 1);
        lCalendar.add(5, -1);
        return lCalendar.get(5);
    }

    protected boolean isToday(Calendar calendar) {
        int lYear = calendar.get(1);
        int lMonth = calendar.get(2);
        int lDay = calendar.get(5);
        Calendar today = Calendar.getInstance();
        int lTodayYear = today.get(1);
        int lTodayMonth = today.get(2);
        int lTodayDay = today.get(5);
        return lYear == lTodayYear && lMonth == lTodayMonth && lDay == lTodayDay;
    }

    private /* synthetic */ void lambda$construct$1(Observable observable) {
        this.refreshLocale();
    }

    static /* synthetic */ void access$lambda$0(CalendarPickerMonthlySkinAbstract calendarPickerMonthlySkinAbstract, Observable observable) {
        calendarPickerMonthlySkinAbstract.lambda$construct$1(observable);
    }
}

