/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javafx.beans.Observable;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$1;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$10;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$11;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$12;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$13;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$14;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$15;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$16;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$17;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$18;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$19;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$3;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$4;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$5;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$6;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$7;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$8;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper$$Lambda$9;

public class DateTimeToCalendarHelper {
    public static Calendar createCalendarFromLocalDate(LocalDate localDate, TimeZone timeZone, Locale locale) {
        if (localDate == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(timeZone, locale);
        lCalendar.set(1, localDate.getYear());
        lCalendar.set(2, localDate.getMonth().getValue() - 1);
        lCalendar.set(5, localDate.getDayOfMonth());
        lCalendar.set(11, 0);
        lCalendar.set(12, 0);
        lCalendar.set(13, 0);
        lCalendar.set(14, 0);
        return lCalendar;
    }

    public static Calendar createCalendarFromZonedDateTime(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        GregorianCalendar lCalendar = GregorianCalendar.from(zonedDateTime);
        return lCalendar;
    }

    public static Calendar createCalendarFromLocalDateTime(LocalDateTime localDateTime, TimeZone timeZone, Locale locale) {
        if (localDateTime == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(timeZone, locale);
        lCalendar.set(1, localDateTime.getYear());
        lCalendar.set(2, localDateTime.getMonth().getValue() - 1);
        lCalendar.set(5, localDateTime.getDayOfMonth());
        lCalendar.set(11, localDateTime.getHour());
        lCalendar.set(12, localDateTime.getMinute());
        lCalendar.set(13, localDateTime.getSecond());
        lCalendar.set(14, localDateTime.getNano() / 1000000);
        return lCalendar;
    }

    public static Calendar createCalendarFromLocalTime(LocalTime localTime, TimeZone timeZone, Locale locale) {
        if (localTime == null) {
            return null;
        }
        Calendar lCalendar = Calendar.getInstance(timeZone, locale);
        lCalendar.set(11, localTime.getHour());
        lCalendar.set(12, localTime.getMinute());
        lCalendar.set(13, localTime.getSecond());
        lCalendar.set(14, localTime.getNano() / 1000000);
        return lCalendar;
    }

    public static LocalDate createLocalDateFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        LocalDate lLocalDate = LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        return lLocalDate;
    }

    public static ZonedDateTime createZonedDateTimeFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(calendar.getTimeInMillis());
        ZoneId zone = DateTimeToCalendarHelper.toZoneId(calendar.getTimeZone());
        return ZonedDateTime.ofInstant(instant, zone);
    }

    public static LocalDateTime createLocalDateTimeFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        LocalDateTime lLocalDateTime = LocalDateTime.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
        return lLocalDateTime;
    }

    public static LocalTime createLocalTimeFromCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        LocalTime lLocalTime = LocalTime.of(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000);
        return lLocalTime;
    }

    public static Date createDateFromLocalDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        Instant lInstant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        Date lDate = Date.from(lInstant);
        return lDate;
    }

    public static LocalDate createLocaleDateFromDate(Date date) {
        if (date == null) {
            return null;
        }
        LocalDate lLocalDate = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return lLocalDate;
    }

    public static Date createDateFromLocalDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        Instant lInstant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Date lDate = Date.from(lInstant);
        return lDate;
    }

    public static LocalDateTime createLocaleDateTimeFromDate(Date date) {
        if (date == null) {
            return null;
        }
        LocalDateTime lLocalDateTime = LocalDateTime.of(1900 + date.getYear(), date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
        return lLocalDateTime;
    }

    public static LocalTime createLocaleTimeFromDate(Date date) {
        if (date == null) {
            return null;
        }
        LocalTime lLocalTime = LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), 0);
        return lLocalTime;
    }

    public static Date createDateFromLocalTime(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        Date lDate = DateTimeToCalendarHelper.createDateFromLocalDateTime(localTime.atDate(LocalDate.now()));
        return lDate;
    }

    public static void syncLocalDate(ObjectProperty<Calendar> calendarProperty, ObjectProperty<LocalDate> localDateProperty, ObjectProperty<Locale> localeProperty) {
        calendarProperty.set(localDateProperty.get() == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDate((LocalDate)localDateProperty.get(), TimeZone.getDefault(), (Locale)localeProperty.get()));
        calendarProperty.addListener(DateTimeToCalendarHelper$$Lambda$1.lambdaFactory$(localDateProperty));
        localDateProperty.addListener(DateTimeToCalendarHelper$$Lambda$3.lambdaFactory$(calendarProperty, localeProperty));
    }

    public static void syncLocalDateTime(ObjectProperty<Calendar> calendarProperty, ObjectProperty<LocalDateTime> localDateTimeProperty, ObjectProperty<Locale> localeProperty) {
        calendarProperty.set(localDateTimeProperty.get() == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDateTime((LocalDateTime)localDateTimeProperty.get(), TimeZone.getDefault(), (Locale)localeProperty.get()));
        calendarProperty.addListener(DateTimeToCalendarHelper$$Lambda$4.lambdaFactory$(localDateTimeProperty));
        localDateTimeProperty.addListener(DateTimeToCalendarHelper$$Lambda$5.lambdaFactory$(calendarProperty, localeProperty));
    }

    public static void syncLocalTime(ObjectProperty<Calendar> calendarProperty, ObjectProperty<LocalTime> localTimeProperty, ObjectProperty<Locale> localeProperty) {
        calendarProperty.set(localTimeProperty.get() == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalTime((LocalTime)localTimeProperty.get(), TimeZone.getDefault(), (Locale)localeProperty.get()));
        calendarProperty.addListener(DateTimeToCalendarHelper$$Lambda$6.lambdaFactory$(localTimeProperty));
        localTimeProperty.addListener(DateTimeToCalendarHelper$$Lambda$7.lambdaFactory$(calendarProperty, localeProperty));
    }

    public static void syncLocalDates(ObservableList<Calendar> calendars, ObservableList<LocalDate> localDates, ObjectProperty<Locale> localeProperty) {
        for (LocalDate lLocalDate : localDates) {
            Calendar lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDate(lLocalDate, TimeZone.getDefault(), (Locale)localeProperty.get());
            calendars.add((Object)lCalendar);
        }
        calendars.addListener(DateTimeToCalendarHelper$$Lambda$8.lambdaFactory$(localDates));
        localDates.addListener(DateTimeToCalendarHelper$$Lambda$9.lambdaFactory$(localeProperty, calendars));
    }

    public static void syncLocalDateTimes(ObservableList<Calendar> calendars, ObservableList<LocalDateTime> localDateTimes, ObjectProperty<Locale> localeProperty) {
        for (LocalDateTime lLocalDateTime : localDateTimes) {
            Calendar lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lLocalDateTime, TimeZone.getDefault(), (Locale)localeProperty.get());
            calendars.add((Object)lCalendar);
        }
        calendars.addListener(DateTimeToCalendarHelper$$Lambda$10.lambdaFactory$(localDateTimes));
        localDateTimes.addListener(DateTimeToCalendarHelper$$Lambda$11.lambdaFactory$(localeProperty, calendars));
    }

    public static void syncDateTimeFormatterForDate(ObjectProperty<DateFormat> dateFormatProperty, ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty) {
        dateFormatProperty.set((Object)(dateTimeFormatterProperty.get() == null ? null : new DateTimeFormatterToDateFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
        dateTimeFormatterProperty.addListener(DateTimeToCalendarHelper$$Lambda$12.lambdaFactory$(dateFormatProperty, dateTimeFormatterProperty));
    }

    public static void syncDateTimeFormattersForDate(ListProperty<DateFormat> dateFormatsProperty, ListProperty<DateTimeFormatter> dateTimeFormattersProperty) {
        WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateFormatWrapper> map = new WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateFormatWrapper>();
        for (DateTimeFormatter lDateTimeFormatter : dateTimeFormattersProperty) {
            DateTimeFormatterToDateFormatWrapper lDateTimeFormatterToDateFormatWrapper = new DateTimeFormatterToDateFormatWrapper(lDateTimeFormatter);
            map.put(lDateTimeFormatter, lDateTimeFormatterToDateFormatWrapper);
            dateFormatsProperty.add((Object)lDateTimeFormatterToDateFormatWrapper);
        }
        dateTimeFormattersProperty.addListener(DateTimeToCalendarHelper$$Lambda$13.lambdaFactory$(map, dateFormatsProperty));
    }

    public static void syncDateTimeFormatterForDateTime(ObjectProperty<DateFormat> dateFormatProperty, ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty) {
        dateFormatProperty.set((Object)(dateTimeFormatterProperty.get() == null ? null : new DateTimeFormatterToDateTimeFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
        dateTimeFormatterProperty.addListener(DateTimeToCalendarHelper$$Lambda$14.lambdaFactory$(dateFormatProperty, dateTimeFormatterProperty));
    }

    public static void syncDateTimeFormattersForDateTime(ListProperty<DateFormat> dateFormatsProperty, ListProperty<DateTimeFormatter> dateTimeFormattersProperty) {
        WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateTimeFormatWrapper> map = new WeakHashMap<DateTimeFormatter, DateTimeFormatterToDateTimeFormatWrapper>();
        for (DateTimeFormatter lDateTimeFormatter : dateTimeFormattersProperty) {
            DateTimeFormatterToDateTimeFormatWrapper lDateTimeFormatterToDateTimeFormatWrapper = new DateTimeFormatterToDateTimeFormatWrapper(lDateTimeFormatter);
            map.put(lDateTimeFormatter, lDateTimeFormatterToDateTimeFormatWrapper);
            dateFormatsProperty.add((Object)lDateTimeFormatterToDateTimeFormatWrapper);
        }
        dateTimeFormattersProperty.addListener(DateTimeToCalendarHelper$$Lambda$15.lambdaFactory$(map, dateFormatsProperty));
    }

    public static void syncDateTimeFormatterForTime(ObjectProperty<DateFormat> dateFormatProperty, ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty) {
        dateFormatProperty.set((Object)(dateTimeFormatterProperty.get() == null ? null : new DateTimeFormatterToTimeFormatWrapper((DateTimeFormatter)dateTimeFormatterProperty.get())));
        dateTimeFormatterProperty.addListener(DateTimeToCalendarHelper$$Lambda$16.lambdaFactory$(dateFormatProperty, dateTimeFormatterProperty));
    }

    public static void syncDateTimeFormattersForTime(ListProperty<DateFormat> dateFormatsProperty, ListProperty<DateTimeFormatter> dateTimeFormattersProperty) {
        WeakHashMap<DateTimeFormatter, DateTimeFormatterToTimeFormatWrapper> map = new WeakHashMap<DateTimeFormatter, DateTimeFormatterToTimeFormatWrapper>();
        for (DateTimeFormatter lDateTimeFormatter : dateTimeFormattersProperty) {
            DateTimeFormatterToTimeFormatWrapper lDateTimeFormatterToTimeFormatWrapper = new DateTimeFormatterToTimeFormatWrapper(lDateTimeFormatter);
            map.put(lDateTimeFormatter, lDateTimeFormatterToTimeFormatWrapper);
            dateFormatsProperty.add((Object)lDateTimeFormatterToTimeFormatWrapper);
        }
        dateTimeFormattersProperty.addListener(DateTimeToCalendarHelper$$Lambda$17.lambdaFactory$(map, dateFormatsProperty));
    }

    public static void sync(ObservableList<Calendar> calendars, ObservableList<Calendar> localDateTimes) {
        calendars.addAll(localDateTimes);
        calendars.addListener(DateTimeToCalendarHelper$$Lambda$18.lambdaFactory$(localDateTimes));
        localDateTimes.addListener(DateTimeToCalendarHelper$$Lambda$19.lambdaFactory$(calendars));
    }

    public static String quickFormatCalendar(Calendar value) {
        if (value == null) {
            return "";
        }
        SimpleDateFormat lSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return lSimpleDateFormat.format(value.getTime());
    }

    public static String quickFormatCalendar(List<Calendar> value) {
        if (value == null) {
            return "null";
        }
        String s = value.size() + "x [";
        for (Calendar lCalendar : value) {
            if (!s.endsWith("[")) {
                s = s + ",";
            }
            s = s + DateTimeToCalendarHelper.quickFormatCalendar(lCalendar);
        }
        s = s + "]";
        return s;
    }

    public static ZoneId toZoneId(TimeZone timeZone) {
        return ZoneId.of(timeZone.getID(), ZoneId.SHORT_IDS);
    }

    private static /* synthetic */ void lambda$sync$62(ObservableList observableList, ListChangeListener.Change change) {
        while (change.next()) {
            for (Calendar lCalendar : change.getRemoved()) {
                if (!observableList.contains((Object)lCalendar)) continue;
                observableList.remove((Object)lCalendar);
            }
            for (Calendar lCalendar : change.getAddedSubList()) {
                if (observableList.contains((Object)lCalendar)) continue;
                observableList.add((Object)lCalendar);
            }
        }
    }

    private static /* synthetic */ void lambda$sync$61(ObservableList observableList, ListChangeListener.Change change) {
        while (change.next()) {
            for (Calendar lCalendar : change.getRemoved()) {
                if (!observableList.contains((Object)lCalendar)) continue;
                observableList.remove((Object)lCalendar);
            }
            for (Calendar lCalendar : change.getAddedSubList()) {
                if (observableList.contains((Object)lCalendar)) continue;
                observableList.add((Object)lCalendar);
            }
        }
    }

    private static /* synthetic */ void lambda$syncDateTimeFormattersForTime$60(Map map, ListProperty listProperty, ListChangeListener.Change change) {
        while (change.next()) {
            DateTimeFormatterToTimeFormatWrapper lDateTimeFormatterToTimeFormatWrapper;
            for (DateTimeFormatter lDateTimeFormatter : change.getRemoved()) {
                lDateTimeFormatterToTimeFormatWrapper = (DateTimeFormatterToTimeFormatWrapper)map.remove(lDateTimeFormatter);
                listProperty.remove((Object)lDateTimeFormatterToTimeFormatWrapper);
            }
            for (DateTimeFormatter lDateTimeFormatter : change.getAddedSubList()) {
                lDateTimeFormatterToTimeFormatWrapper = new DateTimeFormatterToTimeFormatWrapper(lDateTimeFormatter);
                map.put(lDateTimeFormatter, lDateTimeFormatterToTimeFormatWrapper);
                listProperty.add((Object)lDateTimeFormatterToTimeFormatWrapper);
            }
        }
    }

    private static /* synthetic */ void lambda$syncDateTimeFormattersForDateTime$58(Map map, ListProperty listProperty, ListChangeListener.Change change) {
        while (change.next()) {
            DateTimeFormatterToDateTimeFormatWrapper lDateTimeFormatterToDateTimeFormatWrapper;
            for (DateTimeFormatter lDateTimeFormatter : change.getRemoved()) {
                lDateTimeFormatterToDateTimeFormatWrapper = (DateTimeFormatterToDateTimeFormatWrapper)map.remove(lDateTimeFormatter);
                listProperty.remove((Object)lDateTimeFormatterToDateTimeFormatWrapper);
            }
            for (DateTimeFormatter lDateTimeFormatter : change.getAddedSubList()) {
                lDateTimeFormatterToDateTimeFormatWrapper = new DateTimeFormatterToDateTimeFormatWrapper(lDateTimeFormatter);
                map.put(lDateTimeFormatter, lDateTimeFormatterToDateTimeFormatWrapper);
                listProperty.add((Object)lDateTimeFormatterToDateTimeFormatWrapper);
            }
        }
    }

    private static /* synthetic */ void lambda$syncDateTimeFormattersForDate$56(Map map, ListProperty listProperty, ListChangeListener.Change change) {
        while (change.next()) {
            DateTimeFormatterToDateFormatWrapper lDateTimeFormatterToDateFormatWrapper;
            for (DateTimeFormatter lDateTimeFormatter : change.getRemoved()) {
                lDateTimeFormatterToDateFormatWrapper = (DateTimeFormatterToDateFormatWrapper)map.remove(lDateTimeFormatter);
                listProperty.remove((Object)lDateTimeFormatterToDateFormatWrapper);
            }
            for (DateTimeFormatter lDateTimeFormatter : change.getAddedSubList()) {
                lDateTimeFormatterToDateFormatWrapper = new DateTimeFormatterToDateFormatWrapper(lDateTimeFormatter);
                map.put(lDateTimeFormatter, lDateTimeFormatterToDateFormatWrapper);
                listProperty.add((Object)lDateTimeFormatterToDateFormatWrapper);
            }
        }
    }

    private static /* synthetic */ void lambda$syncLocalDateTimes$54(ObjectProperty objectProperty, ObservableList observableList, ListChangeListener.Change change) {
        while (change.next()) {
            Calendar lCalendar;
            for (LocalDateTime lLocalDateTime : change.getRemoved()) {
                lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lLocalDateTime, TimeZone.getDefault(), (Locale)objectProperty.get());
                if (!observableList.contains((Object)lCalendar)) continue;
                observableList.remove((Object)lCalendar);
            }
            for (LocalDateTime lLocalDateTime : change.getAddedSubList()) {
                lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lLocalDateTime, TimeZone.getDefault(), (Locale)objectProperty.get());
                if (observableList.contains((Object)lCalendar)) continue;
                observableList.add((Object)lCalendar);
            }
        }
    }

    private static /* synthetic */ void lambda$syncLocalDateTimes$53(ObservableList observableList, ListChangeListener.Change change) {
        while (change.next()) {
            LocalDateTime lLocalDateTime;
            for (Calendar lCalendar : change.getRemoved()) {
                lLocalDateTime = DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(lCalendar);
                if (!observableList.contains((Object)lLocalDateTime)) continue;
                observableList.remove((Object)lLocalDateTime);
            }
            for (Calendar lCalendar : change.getAddedSubList()) {
                lLocalDateTime = DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(lCalendar);
                if (observableList.contains((Object)lLocalDateTime)) continue;
                observableList.add((Object)lLocalDateTime);
            }
        }
    }

    private static /* synthetic */ void lambda$syncLocalDates$52(ObjectProperty objectProperty, ObservableList observableList, ListChangeListener.Change change) {
        while (change.next()) {
            Calendar lCalendar;
            for (LocalDate lLocalDate : change.getRemoved()) {
                lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDate(lLocalDate, TimeZone.getDefault(), (Locale)objectProperty.get());
                if (!observableList.contains((Object)lCalendar)) continue;
                observableList.remove((Object)lCalendar);
            }
            for (LocalDate lLocalDate : change.getAddedSubList()) {
                lCalendar = DateTimeToCalendarHelper.createCalendarFromLocalDate(lLocalDate, TimeZone.getDefault(), (Locale)objectProperty.get());
                if (observableList.contains((Object)lCalendar)) continue;
                observableList.add((Object)lCalendar);
            }
        }
    }

    private static /* synthetic */ void lambda$syncLocalDates$51(ObservableList observableList, ListChangeListener.Change change) {
        while (change.next()) {
            LocalDate lLocalDate;
            for (Calendar lCalendar : change.getRemoved()) {
                lLocalDate = DateTimeToCalendarHelper.createLocalDateFromCalendar(lCalendar);
                if (!observableList.contains((Object)lLocalDate)) continue;
                observableList.remove((Object)lLocalDate);
            }
            for (Calendar lCalendar : change.getAddedSubList()) {
                lLocalDate = DateTimeToCalendarHelper.createLocalDateFromCalendar(lCalendar);
                if (observableList.contains((Object)lLocalDate)) continue;
                observableList.add((Object)lLocalDate);
            }
        }
    }

    static /* synthetic */ void access$lambda$0(ObjectProperty objectProperty, ObservableValue observableValue, Calendar calendar, Calendar calendar2) {
        objectProperty.set((Object)DateTimeToCalendarHelper.createLocalDateFromCalendar(calendar2));
    }

    static /* synthetic */ void access$lambda$1(ObjectProperty objectProperty, ObjectProperty objectProperty2, ObservableValue observableValue, LocalDate localDate, LocalDate localDate2) {
        objectProperty.set(localDate2 == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDate(localDate2, TimeZone.getDefault(), (Locale)objectProperty2.get()));
    }

    static /* synthetic */ void access$lambda$2(ObjectProperty objectProperty, ObservableValue observableValue, Calendar calendar, Calendar calendar2) {
        objectProperty.set((Object)DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(calendar2));
    }

    static /* synthetic */ void access$lambda$3(ObjectProperty objectProperty, ObjectProperty objectProperty2, ObservableValue observableValue, LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        objectProperty.set(localDateTime2 == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalDateTime(localDateTime2, TimeZone.getDefault(), (Locale)objectProperty2.get()));
    }

    static /* synthetic */ void access$lambda$4(ObjectProperty objectProperty, ObservableValue observableValue, Calendar calendar, Calendar calendar2) {
        objectProperty.set((Object)DateTimeToCalendarHelper.createLocalTimeFromCalendar(calendar2));
    }

    static /* synthetic */ void access$lambda$5(ObjectProperty objectProperty, ObjectProperty objectProperty2, ObservableValue observableValue, LocalTime localTime, LocalTime localTime2) {
        objectProperty.set(localTime2 == null ? null : DateTimeToCalendarHelper.createCalendarFromLocalTime(localTime2, TimeZone.getDefault(), (Locale)objectProperty2.get()));
    }

    static /* synthetic */ void access$lambda$6(ObservableList observableList, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$syncLocalDates$51(observableList, change);
    }

    static /* synthetic */ void access$lambda$7(ObjectProperty objectProperty, ObservableList observableList, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$syncLocalDates$52(objectProperty, observableList, change);
    }

    static /* synthetic */ void access$lambda$8(ObservableList observableList, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$syncLocalDateTimes$53(observableList, change);
    }

    static /* synthetic */ void access$lambda$9(ObjectProperty objectProperty, ObservableList observableList, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$syncLocalDateTimes$54(objectProperty, observableList, change);
    }

    static /* synthetic */ void access$lambda$10(ObjectProperty objectProperty, ObjectProperty objectProperty2, Observable observable) {
        objectProperty.set((Object)new DateTimeFormatterToDateFormatWrapper((DateTimeFormatter)objectProperty2.get()));
    }

    static /* synthetic */ void access$lambda$11(Map map, ListProperty listProperty, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$syncDateTimeFormattersForDate$56(map, listProperty, change);
    }

    static /* synthetic */ void access$lambda$12(ObjectProperty objectProperty, ObjectProperty objectProperty2, Observable observable) {
        objectProperty.set((Object)new DateTimeFormatterToDateTimeFormatWrapper((DateTimeFormatter)objectProperty2.get()));
    }

    static /* synthetic */ void access$lambda$13(Map map, ListProperty listProperty, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$syncDateTimeFormattersForDateTime$58(map, listProperty, change);
    }

    static /* synthetic */ void access$lambda$14(ObjectProperty objectProperty, ObjectProperty objectProperty2, Observable observable) {
        objectProperty.set((Object)new DateTimeFormatterToTimeFormatWrapper((DateTimeFormatter)objectProperty2.get()));
    }

    static /* synthetic */ void access$lambda$15(Map map, ListProperty listProperty, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$syncDateTimeFormattersForTime$60(map, listProperty, change);
    }

    static /* synthetic */ void access$lambda$16(ObservableList observableList, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$sync$61(observableList, change);
    }

    static /* synthetic */ void access$lambda$17(ObservableList observableList, ListChangeListener.Change change) {
        DateTimeToCalendarHelper.lambda$sync$62(observableList, change);
    }

    static class DateTimeFormatterToTimeFormatWrapper
    extends DateFormat {
        private final DateTimeFormatter dateTimeFormatter;

        public DateTimeFormatterToTimeFormatWrapper(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            LocalTime lLocalTime = DateTimeToCalendarHelper.createLocaleTimeFromDate(date);
            String s = this.dateTimeFormatter.format(lLocalTime);
            toAppendTo.append(s);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            LocalTime lLocalTime = LocalTime.parse(source, this.dateTimeFormatter);
            Date lDate = DateTimeToCalendarHelper.createDateFromLocalTime(lLocalTime);
            pos.setIndex(source.length());
            return lDate;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj;
        }

        public String toString() {
            return this.dateTimeFormatter.toString();
        }
    }

    static class DateTimeFormatterToDateTimeFormatWrapper
    extends DateFormat {
        private final DateTimeFormatter dateTimeFormatter;

        public DateTimeFormatterToDateTimeFormatWrapper(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            LocalDateTime lLocalDateTime = DateTimeToCalendarHelper.createLocaleDateTimeFromDate(date);
            String s = this.dateTimeFormatter.format(lLocalDateTime);
            toAppendTo.append(s);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            LocalDateTime lLocalDateTime = LocalDateTime.parse(source, this.dateTimeFormatter);
            Date lDate = DateTimeToCalendarHelper.createDateFromLocalDateTime(lLocalDateTime);
            pos.setIndex(source.length());
            return lDate;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj;
        }

        public String toString() {
            return this.dateTimeFormatter.toString();
        }
    }

    static class DateTimeFormatterToDateFormatWrapper
    extends DateFormat {
        private final DateTimeFormatter dateTimeFormatter;

        public DateTimeFormatterToDateFormatWrapper(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            LocalDate lLocalDate = DateTimeToCalendarHelper.createLocaleDateFromDate(date);
            String s = this.dateTimeFormatter.format(lLocalDate);
            toAppendTo.append(s);
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            LocalDate lLocalDate = LocalDate.parse(source, this.dateTimeFormatter);
            Date lDate = DateTimeToCalendarHelper.createDateFromLocalDate(lLocalDate);
            pos.setIndex(source.length());
            return lDate;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj;
        }

        public String toString() {
            return this.dateTimeFormatter.toString();
        }
    }
}

