/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Collection;
import javafx.beans.property.Property;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.CalendarTextField;
import jfxtras.scene.control.LocalDateTimePicker;
import jfxtras.scene.control.LocalDateTimeTextField;

public class LocalDateTimeTextFieldSkin
extends SkinBase<LocalDateTimeTextField> {
    private CalendarTextField calendarTextField = null;

    public LocalDateTimeTextFieldSkin(LocalDateTimeTextField control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        this.calendarTextField.setShowTime(true);
        this.calendarTextField.getStyleClass().addAll((Object[])new String[]{((Object)((Object)((LocalDateTimeTextField)this.getSkinnable()))).getClass().getSimpleName()});
        this.calendarTextField.getStyleClass().addAll((Collection)((LocalDateTimeTextField)this.getSkinnable()).getStyleClass());
        this.calendarTextField.styleProperty().bindBidirectional((Property)((LocalDateTimeTextField)this.getSkinnable()).styleProperty());
        this.calendarTextField.tooltipProperty().bindBidirectional((Property)((LocalDateTimeTextField)this.getSkinnable()).tooltipProperty());
        this.calendarTextField.textProperty().bindBidirectional(((LocalDateTimeTextField)this.getSkinnable()).textProperty());
        this.calendarTextField.pickerShowingProperty().bindBidirectional((Property)((LocalDateTimeTextField)this.getSkinnable()).pickerShowingProperty());
        this.calendarTextField.localeProperty().bindBidirectional(((LocalDateTimeTextField)this.getSkinnable()).localeProperty());
        this.calendarTextField.allowNullProperty().bindBidirectional((Property)((LocalDateTimeTextField)this.getSkinnable()).allowNullProperty());
        this.calendarTextField.promptTextProperty().bindBidirectional(((LocalDateTimeTextField)this.getSkinnable()).promptTextProperty());
        this.calendarTextField.parseErrorCallbackProperty().bindBidirectional(((LocalDateTimeTextField)this.getSkinnable()).parseErrorCallbackProperty());
        DateTimeToCalendarHelper.syncLocalDateTime(this.calendarTextField.calendarProperty(), ((LocalDateTimeTextField)this.getSkinnable()).localDateTimeProperty(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncLocalDateTimes(this.calendarTextField.highlightedCalendars(), ((LocalDateTimeTextField)this.getSkinnable()).highlightedLocalDateTimes(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncLocalDateTimes(this.calendarTextField.disabledCalendars(), ((LocalDateTimeTextField)this.getSkinnable()).disabledLocalDateTimes(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncLocalDateTime(this.calendarTextField.displayedCalendar(), ((LocalDateTimeTextField)this.getSkinnable()).displayedLocalDateTime(), this.calendarTextField.localeProperty());
        DateTimeToCalendarHelper.syncDateTimeFormatterForDateTime(this.calendarTextField.dateFormatProperty(), ((LocalDateTimeTextField)this.getSkinnable()).dateTimeFormatterProperty());
        DateTimeToCalendarHelper.syncDateTimeFormattersForDateTime(this.calendarTextField.dateFormatsProperty(), ((LocalDateTimeTextField)this.getSkinnable()).dateTimeFormattersProperty());
        this.calendarTextField.setCalendarRangeCallback(new Callback<CalendarPicker.CalendarRange, Void>(){

            public Void call(CalendarPicker.CalendarRange calendarRange) {
                Callback<LocalDateTimePicker.LocalDateTimeRange, Void> lCallback = ((LocalDateTimeTextField)LocalDateTimeTextFieldSkin.this.getSkinnable()).getLocalDateTimeRangeCallback();
                if (lCallback == null) {
                    return null;
                }
                return (Void)lCallback.call((Object)new LocalDateTimePicker.LocalDateTimeRange(DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(calendarRange.getStartCalendar()), DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(calendarRange.getEndCalendar())));
            }
        });
        this.calendarTextField.setValueValidationCallback(new Callback<Calendar, Boolean>(){

            public Boolean call(Calendar calendar) {
                Callback<LocalDateTime, Boolean> lCallback = ((LocalDateTimeTextField)LocalDateTimeTextFieldSkin.this.getSkinnable()).getValueValidationCallback();
                if (lCallback == null) {
                    return true;
                }
                return (Boolean)lCallback.call((Object)DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(calendar));
            }
        });
    }

    private void createNodes() {
        this.calendarTextField = new CalendarTextField();
        this.getChildren().add((Object)this.calendarTextField);
        ((LocalDateTimeTextField)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }
}

