/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.CalendarTimeTextFieldSkin;

public class CalendarTimeTextField
extends Control {
    private final ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty((Object)this, "calendar", null);
    private final ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty<Locale>(Locale.getDefault()){

        public void set(Locale value) {
            super.set((Object)value);
            if (!CalendarTimeTextField.this.dateFormatManual) {
                CalendarTimeTextField.this.setDateFormat(null);
            }
        }
    };
    private final ObjectProperty<DateFormat> dateFormatObjectProperty = new SimpleObjectProperty<DateFormat>((Object)this, "dateFormat", SimpleDateFormat.getTimeInstance(3, this.getLocale())){

        public void set(DateFormat value) {
            String lFormattedDate;
            if (value != null && (lFormattedDate = value.format(DATE_WITH_TIME)).contains("1")) {
                throw new IllegalArgumentException("The date format may only show time");
            }
            super.set((Object)(value != null ? value : SimpleDateFormat.getTimeInstance(3, CalendarTimeTextField.this.getLocale())));
            CalendarTimeTextField.this.dateFormatManual = value != null;
        }
    };
    private static final Date DATE_WITH_TIME = new GregorianCalendar(1111, 0, 1, 9, 33, 44).getTime();
    private boolean dateFormatManual = false;
    private final SimpleObjectProperty<Integer> minuteStepProperty = new SimpleObjectProperty((Object)this, "minuteStep", (Object)1);
    private final SimpleObjectProperty<Integer> secondStepProperty = new SimpleObjectProperty((Object)this, "secondStep", (Object)1);
    private final ObjectProperty<String> promptTextObjectProperty = new SimpleObjectProperty((Object)this, "promptText", null);
    private final ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackObjectProperty = new SimpleObjectProperty((Object)this, "parseErrorCallback", null);
    ListProperty<DateFormat> dateFormatsProperty = new SimpleListProperty(FXCollections.observableList(new ArrayList()));
    private final BooleanProperty pickerShowingProperty = new SimpleBooleanProperty();

    public CalendarTimeTextField() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)CalendarTimeTextField.class.getSimpleName());
        this.setFocusTraversable(false);
    }

    public String getUserAgentStylesheet() {
        return CalendarTimeTextField.class.getResource("/jfxtras/internal/scene/control/" + CalendarTimeTextField.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new CalendarTimeTextFieldSkin(this);
    }

    public CalendarTimeTextField withId(String value) {
        this.setId(value);
        return this;
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendarObjectProperty;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.calendarObjectProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public ObjectProperty<DateFormat> dateFormatProperty() {
        return this.dateFormatObjectProperty;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormatObjectProperty.getValue();
    }

    public void setDateFormat(DateFormat value) {
        this.dateFormatObjectProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withDateFormat(DateFormat value) {
        this.setDateFormat(value);
        return this;
    }

    public ObjectProperty<Integer> minuteStepProperty() {
        return this.minuteStepProperty;
    }

    public Integer getMinuteStep() {
        return (Integer)this.minuteStepProperty.getValue();
    }

    public void setMinuteStep(Integer value) {
        this.minuteStepProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withMinuteStep(Integer value) {
        this.setMinuteStep(value);
        return this;
    }

    public ObjectProperty<Integer> secondStepProperty() {
        return this.secondStepProperty;
    }

    public Integer getSecondStep() {
        return (Integer)this.secondStepProperty.getValue();
    }

    public void setSecondStep(Integer value) {
        this.secondStepProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withSecondStep(Integer value) {
        this.setSecondStep(value);
        return this;
    }

    public ObjectProperty<String> promptTextProperty() {
        return this.promptTextObjectProperty;
    }

    public String getPromptText() {
        return (String)this.promptTextObjectProperty.get();
    }

    public void setPromptText(String value) {
        this.promptTextObjectProperty.set((Object)value);
    }

    public CalendarTimeTextField withPromptText(String value) {
        this.setPromptText(value);
        return this;
    }

    public ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackProperty() {
        return this.parseErrorCallbackObjectProperty;
    }

    public Callback<Throwable, Void> getParseErrorCallback() {
        return (Callback)this.parseErrorCallbackObjectProperty.getValue();
    }

    public void setParseErrorCallback(Callback<Throwable, Void> value) {
        this.parseErrorCallbackObjectProperty.setValue(value);
    }

    public CalendarTimeTextField withParseErrorCallback(Callback<Throwable, Void> value) {
        this.setParseErrorCallback(value);
        return this;
    }

    public ListProperty<DateFormat> dateFormatsProperty() {
        return this.dateFormatsProperty;
    }

    public ObservableList<DateFormat> getDateFormats() {
        return this.dateFormatsProperty.getValue();
    }

    public void setDateFormats(ObservableList<DateFormat> value) {
        this.dateFormatsProperty.setValue(value);
    }

    public CalendarTimeTextField withDateFormat(ObservableList<DateFormat> value) {
        this.setDateFormats(value);
        return this;
    }

    public BooleanProperty pickerShowingProperty() {
        return this.pickerShowingProperty;
    }

    public boolean isPickerShowing() {
        return this.pickerShowingProperty.get();
    }

    public void setPickerShowing(boolean value) {
        this.pickerShowingProperty.set(value);
    }
}

