/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.fxml;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import jfxtras.fxml.BuilderService;
import jfxtras.internal.scene.control.fxml.AbstractBuilder;
import jfxtras.scene.control.CalendarTextField;

public class CalendarTextFieldBuilder
extends AbstractBuilder
implements BuilderService<CalendarTextField> {
    private Locale iLocale = null;
    private String iPromptText = null;
    private String iDateFormat = null;
    private List<String> iDateFormats = null;

    public String getLocale() {
        return null;
    }

    public void setLocale(String value) {
        this.iLocale = Locale.forLanguageTag(value);
    }

    public String getPromptText() {
        return null;
    }

    public void setPromptText(String value) {
        this.iPromptText = value;
    }

    public String getDateFormat() {
        return null;
    }

    public void setDateFormat(String value) {
        this.iDateFormat = value;
    }

    public String getDateFormats() {
        return null;
    }

    public void setDateFormats(String value) {
        String[] lParts = value.split(",");
        this.iDateFormats = new ArrayList<String>();
        for (String lPart : lParts) {
            this.iDateFormats.add(lPart.trim());
        }
    }

    public CalendarTextField build() {
        Locale lLocale = this.iLocale == null ? Locale.getDefault() : this.iLocale;
        CalendarTextField lCalendarTextField = new CalendarTextField();
        if (this.iDateFormat != null) {
            lCalendarTextField.setDateFormat(new SimpleDateFormat(this.iDateFormat, lLocale));
        }
        if (this.iLocale != null) {
            lCalendarTextField.setLocale(this.iLocale);
        }
        if (this.iPromptText != null) {
            lCalendarTextField.setPromptText(this.iPromptText);
        }
        if (this.iDateFormats != null) {
            ObservableList lDateFormats = FXCollections.observableArrayList();
            for (String lPart : this.iDateFormats) {
                lDateFormats.add((Object)new SimpleDateFormat(lPart.trim(), lLocale));
            }
            lCalendarTextField.setDateFormats((ObservableList<DateFormat>)lDateFormats);
        }
        this.applyCommonProperties((Node)lCalendarTextField);
        return lCalendarTextField;
    }

    public boolean isBuilderFor(Class<?> clazz) {
        return CalendarTextField.class.isAssignableFrom(clazz);
    }
}

