/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.util.Callback;
import javafx.util.Duration;
import jfxtras.animation.Timer;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.scene.control.ListSpinner;
import jfxtras.scene.layout.HBox;
import jfxtras.scene.layout.VBox;
import jfxtras.util.NodeUtil;

public class ListSpinnerSkin<T>
extends SkinBase<ListSpinner<T>> {
    private ObjectProperty<ArrowPosition> arrowPosition = new SimpleStyleableObjectProperty<ArrowPosition>(StyleableProperties.access$000(), (Object)this, "arrowPosition", (ArrowPosition)((Object)StyleableProperties.access$000().getInitialValue(null))){
        {
            this.addListener(invalidationEvent -> {
                ListSpinnerSkin.this.setArrowCSS();
                ListSpinnerSkin.this.layout();
            });
        }
    };
    private ObjectProperty<ArrowDirection> arrowDirection = new SimpleStyleableObjectProperty<ArrowDirection>(StyleableProperties.access$300(), (Object)this, "arrowDirection", (ArrowDirection)((Object)StyleableProperties.access$300().getInitialValue(null))){
        {
            this.addListener(invalidationEvent -> {
                ListSpinnerSkin.this.setArrowCSS();
                ListSpinnerSkin.this.layout();
            });
        }
    };
    private ObjectProperty<Pos> valueAlignment = new SimpleStyleableObjectProperty<Pos>(StyleableProperties.access$400(), (Object)this, "valueAlignment", (Pos)StyleableProperties.access$400().getInitialValue(null)){
        {
            this.addListener(invalidationEvent -> ListSpinnerSkin.this.alignValue());
        }
    };
    private Region decrementArrow = null;
    private Region incrementArrow = null;
    private BorderPane skinNode = null;
    private BorderPane valueHolderNode;
    private final Timer unclickTimer = new Timer(() -> this.unclickArrows()).withDelay(Duration.millis((double)100.0)).withRepeats(false);
    private final Timer repeatDecrementClickTimer = new Timer(() -> ((ListSpinner)this.getSkinnable()).decrement()).withDelay(Duration.millis((double)500.0)).withCycleDuration(Duration.millis((double)50.0));
    private final Timer repeatIncrementClickTimer = new Timer(() -> ((ListSpinner)this.getSkinnable()).increment()).withDelay(Duration.millis((double)500.0)).withCycleDuration(Duration.millis((double)50.0));
    private TextField textField = null;

    public ListSpinnerSkin(ListSpinner<T> control) {
        super(control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((ListSpinner)this.getSkinnable()).editableProperty().addListener((observable, oldValue, newValue) -> this.replaceValueNode());
        this.replaceValueNode();
        ((ListSpinner)this.getSkinnable()).valueProperty().addListener((observable, oldValue, newValue) -> this.refreshValue());
        this.refreshValue();
        this.setArrowCSS();
        this.layout();
        this.alignValue();
    }

    private void refreshValue() {
        if (((ListSpinner)this.getSkinnable()).isEditable().booleanValue()) {
            Object lValue = ((ListSpinner)this.getSkinnable()).getValue();
            this.textField.setText(((ListSpinner)this.getSkinnable()).getPrefix() + ((ListSpinner)this.getSkinnable()).getStringConverter().toString(lValue) + ((ListSpinner)this.getSkinnable()).getPostfix());
        } else {
            ((ListSpinner)this.getSkinnable()).getCellFactory().call((Object)((ListSpinner)this.getSkinnable()));
        }
    }

    public final ObjectProperty<ArrowPosition> arrowPositionProperty() {
        return this.arrowPosition;
    }

    public final void setArrowPosition(ArrowPosition value) {
        this.arrowPositionProperty().set((Object)value);
    }

    public final ArrowPosition getArrowPosition() {
        return (ArrowPosition)((Object)this.arrowPosition.get());
    }

    public final ListSpinnerSkin<T> withArrowPosition(ArrowPosition value) {
        this.setArrowPosition(value);
        return this;
    }

    public final ObjectProperty<ArrowDirection> arrowDirectionProperty() {
        return this.arrowDirection;
    }

    public final void setArrowDirection(ArrowDirection value) {
        this.arrowDirectionProperty().set((Object)value);
    }

    public final ArrowDirection getArrowDirection() {
        return (ArrowDirection)((Object)this.arrowDirection.get());
    }

    public final ListSpinnerSkin<T> withArrowDirection(ArrowDirection value) {
        this.setArrowDirection(value);
        return this;
    }

    public final ObjectProperty<Pos> valueAlignmentProperty() {
        return this.valueAlignment;
    }

    public final void setValueAlignment(Pos value) {
        this.valueAlignmentProperty().set((Object)value);
    }

    public final Pos getValueAlignment() {
        return (Pos)this.valueAlignment.get();
    }

    public final ListSpinnerSkin<T> withValueAlignment(Pos value) {
        this.setValueAlignment(value);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ListSpinnerSkin.getClassCssMetaData();
    }

    private void createNodes() {
        this.decrementArrow = new Region();
        this.decrementArrow.getStyleClass().add((Object)"idle");
        this.valueHolderNode = new BorderPane();
        this.valueHolderNode.getStyleClass().add((Object)"valuePane");
        this.incrementArrow = new Region();
        this.incrementArrow.getStyleClass().add((Object)"idle");
        this.skinNode = new BorderPane();
        this.skinNode.setCenter((Node)this.valueHolderNode);
        this.skinNode.setOnMouseClicked(mouseEvent -> {
            if (this.mouseEventOverArrow((MouseEvent)mouseEvent, this.decrementArrow)) {
                NodeUtil.addStyleClass((Node)this.decrementArrow, (String)"clicked");
                NodeUtil.removeStyleClass((Node)this.incrementArrow, (String)"clicked");
                ((ListSpinner)this.getSkinnable()).decrement();
                this.unclickTimer.restart();
                return;
            }
            if (this.mouseEventOverArrow((MouseEvent)mouseEvent, this.incrementArrow)) {
                NodeUtil.removeStyleClass((Node)this.decrementArrow, (String)"clicked");
                NodeUtil.addStyleClass((Node)this.incrementArrow, (String)"clicked");
                ((ListSpinner)this.getSkinnable()).increment();
                this.unclickTimer.restart();
                return;
            }
        });
        this.skinNode.setOnMousePressed(evt -> {
            if (this.mouseEventOverArrow((MouseEvent)evt, this.decrementArrow)) {
                this.decrementArrow.getStyleClass().add((Object)"clicked");
                this.repeatDecrementClickTimer.restart();
            } else if (this.mouseEventOverArrow((MouseEvent)evt, this.incrementArrow)) {
                this.incrementArrow.getStyleClass().add((Object)"clicked");
                this.repeatIncrementClickTimer.restart();
                return;
            }
            ListSpinner lControl = (ListSpinner)this.getSkinnable();
            if (!lControl.isFocused() && lControl.isFocusTraversable()) {
                lControl.requestFocus();
            }
        });
        this.skinNode.setOnMouseReleased(evt -> {
            this.unclickArrows();
            this.repeatDecrementClickTimer.stop();
            this.repeatIncrementClickTimer.stop();
        });
        this.skinNode.setOnMouseExited(evt -> {
            this.unclickArrows();
            this.repeatDecrementClickTimer.stop();
            this.repeatIncrementClickTimer.stop();
        });
        this.skinNode.setOnScroll(evt -> {
            if (evt.getDeltaY() < 0.0 || evt.getDeltaX() < 0.0) {
                NodeUtil.addStyleClass((Node)this.decrementArrow, (String)"clicked");
                NodeUtil.removeStyleClass((Node)this.incrementArrow, (String)"clicked");
                ((ListSpinner)this.getSkinnable()).decrement();
                this.unclickTimer.restart();
                return;
            }
            if (evt.getDeltaY() > 0.0 || evt.getDeltaX() > 0.0) {
                NodeUtil.removeStyleClass((Node)this.decrementArrow, (String)"clicked");
                NodeUtil.addStyleClass((Node)this.incrementArrow, (String)"clicked");
                ((ListSpinner)this.getSkinnable()).increment();
                this.unclickTimer.restart();
                return;
            }
        });
        ((ListSpinner)this.getSkinnable()).onKeyTypedProperty().set(keyEvent -> {
            KeyCode lKeyCode = keyEvent.getCode();
            if (KeyCode.MINUS.equals((Object)lKeyCode) || KeyCode.SUBTRACT.equals((Object)lKeyCode) || KeyCode.DOWN.equals((Object)lKeyCode) || KeyCode.LEFT.equals((Object)lKeyCode)) {
                ((ListSpinner)this.getSkinnable()).decrement();
            }
            if (KeyCode.PLUS.equals((Object)lKeyCode) || KeyCode.ADD.equals((Object)lKeyCode) || KeyCode.UP.equals((Object)lKeyCode) || KeyCode.RIGHT.equals((Object)lKeyCode)) {
                ((ListSpinner)this.getSkinnable()).increment();
            }
        });
        ((ListSpinner)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.skinNode);
    }

    private boolean mouseEventOverArrow(MouseEvent evt, Region region) {
        Point2D lClickInRelationToArrow = region.sceneToLocal(evt.getSceneX(), evt.getSceneY());
        return lClickInRelationToArrow.getX() >= 0.0 && lClickInRelationToArrow.getX() <= region.getWidth() && lClickInRelationToArrow.getY() >= 0.0 && lClickInRelationToArrow.getY() <= region.getHeight();
    }

    private void unclickArrows() {
        this.decrementArrow.getStyleClass().remove((Object)"clicked");
        this.incrementArrow.getStyleClass().remove((Object)"clicked");
    }

    private void replaceValueNode() {
        this.valueHolderNode.getChildren().clear();
        if (!((ListSpinner)this.getSkinnable()).isEditable().booleanValue()) {
            Node lNode = (Node)((ListSpinner)this.getSkinnable()).getCellFactory().call((Object)((ListSpinner)this.getSkinnable()));
            this.valueHolderNode.setCenter(lNode);
            if (!lNode.getStyleClass().contains((Object)"value")) {
                lNode.getStyleClass().add((Object)"value");
            }
            if (!lNode.getStyleClass().contains((Object)"readonly")) {
                lNode.getStyleClass().add((Object)"readonly");
            }
        } else {
            if (this.textField == null) {
                this.textField = new TextField();
                this.textField.getStyleClass().add((Object)"value");
                this.textField.getStyleClass().add((Object)"editable");
                this.textField.focusedProperty().addListener(new InvalidationListener(){

                    public void invalidated(Observable arg0) {
                        if (!ListSpinnerSkin.this.textField.isFocused()) {
                            ListSpinnerSkin.this.parse(ListSpinnerSkin.this.textField);
                        }
                    }
                });
                this.textField.setOnAction(actionEvent -> this.parse(this.textField));
                this.textField.setOnKeyPressed(keyEvent -> {
                    if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        this.refreshValue();
                    }
                });
                this.textField.alignmentProperty().bind(this.valueAlignmentProperty());
            }
            this.valueHolderNode.setCenter((Node)this.textField);
        }
        this.alignValue();
    }

    private void alignValue() {
        BorderPane.setAlignment((Node)((Node)this.valueHolderNode.getChildren().get(0)), (Pos)((Pos)this.valueAlignmentProperty().getValue()));
    }

    protected void parse(TextField textField) {
        String lText = textField.getText();
        this.parse(lText);
        this.refreshValue();
    }

    private void layout() {
        ArrowDirection lArrowDirection = this.getArrowDirection();
        ArrowPosition lArrowPosition = this.getArrowPosition();
        ColumnConstraints lColumnValue = new ColumnConstraints(this.valueHolderNode.getMinWidth(), this.valueHolderNode.getPrefWidth(), Double.MAX_VALUE);
        lColumnValue.setHgrow(Priority.ALWAYS);
        RowConstraints lRowValue = new RowConstraints(this.valueHolderNode.getMinHeight(), this.valueHolderNode.getPrefHeight(), Double.MAX_VALUE);
        lRowValue.setVgrow(Priority.ALWAYS);
        this.skinNode.getChildren().clear();
        this.skinNode.setCenter((Node)this.valueHolderNode);
        if (lArrowDirection == ArrowDirection.HORIZONTAL) {
            HBox lHBox;
            if (lArrowPosition == ArrowPosition.LEADING) {
                lHBox = new HBox(0.0);
                lHBox.add((Node)this.decrementArrow, new HBox.C().hgrow(Priority.ALWAYS));
                lHBox.add((Node)this.incrementArrow, new HBox.C().hgrow(Priority.ALWAYS));
                this.skinNode.setLeft((Node)lHBox);
                BorderPane.setAlignment((Node)lHBox, (Pos)Pos.CENTER_LEFT);
            }
            if (lArrowPosition == ArrowPosition.TRAILING) {
                lHBox = new HBox(0.0);
                lHBox.add((Node)this.decrementArrow, new HBox.C().hgrow(Priority.ALWAYS));
                lHBox.add((Node)this.incrementArrow, new HBox.C().hgrow(Priority.ALWAYS));
                this.skinNode.setRight((Node)lHBox);
                BorderPane.setAlignment((Node)lHBox, (Pos)Pos.CENTER_RIGHT);
            }
            if (lArrowPosition == ArrowPosition.SPLIT) {
                this.skinNode.setLeft((Node)this.decrementArrow);
                this.skinNode.setRight((Node)this.incrementArrow);
                BorderPane.setAlignment((Node)this.decrementArrow, (Pos)Pos.CENTER_LEFT);
                BorderPane.setAlignment((Node)this.incrementArrow, (Pos)Pos.CENTER_RIGHT);
            }
        }
        if (lArrowDirection == ArrowDirection.VERTICAL) {
            VBox lVBox;
            if (lArrowPosition == ArrowPosition.LEADING) {
                lVBox = new VBox(0.0);
                lVBox.add((Node)this.incrementArrow, new VBox.C().vgrow(Priority.ALWAYS));
                lVBox.add((Node)this.decrementArrow, new VBox.C().vgrow(Priority.ALWAYS));
                this.skinNode.setLeft((Node)lVBox);
                BorderPane.setAlignment((Node)lVBox, (Pos)Pos.CENTER_LEFT);
            }
            if (lArrowPosition == ArrowPosition.TRAILING) {
                lVBox = new VBox(0.0);
                lVBox.add((Node)this.incrementArrow, new VBox.C().vgrow(Priority.ALWAYS));
                lVBox.add((Node)this.decrementArrow, new VBox.C().vgrow(Priority.ALWAYS));
                this.skinNode.setRight((Node)lVBox);
                BorderPane.setAlignment((Node)lVBox, (Pos)Pos.CENTER_RIGHT);
            }
            if (lArrowPosition == ArrowPosition.SPLIT) {
                this.skinNode.setTop((Node)this.incrementArrow);
                this.skinNode.setBottom((Node)this.decrementArrow);
                BorderPane.setAlignment((Node)this.incrementArrow, (Pos)Pos.TOP_CENTER);
                BorderPane.setAlignment((Node)this.decrementArrow, (Pos)Pos.BOTTOM_CENTER);
            }
        }
    }

    private void setArrowCSS() {
        this.decrementArrow.getStyleClass().remove((Object)"down-arrow");
        this.decrementArrow.getStyleClass().remove((Object)"left-arrow");
        this.incrementArrow.getStyleClass().remove((Object)"up-arrow");
        this.incrementArrow.getStyleClass().remove((Object)"right-arrow");
        if (this.getArrowDirection().equals((Object)ArrowDirection.HORIZONTAL)) {
            this.decrementArrow.getStyleClass().add((Object)"left-arrow");
            this.incrementArrow.getStyleClass().add((Object)"right-arrow");
        } else {
            this.decrementArrow.getStyleClass().add((Object)"down-arrow");
            this.incrementArrow.getStyleClass().add((Object)"up-arrow");
        }
    }

    public void parse(String text) {
        Integer lIndex;
        String lPrefix;
        String lText = text;
        String lPostfix = ((ListSpinner)this.getSkinnable()).getPostfix();
        if (lPostfix.length() > 0 && lText.endsWith(lPostfix)) {
            lText = lText.substring(0, lText.length() - lPostfix.length());
        }
        if ((lPrefix = ((ListSpinner)this.getSkinnable()).getPrefix()).length() > 0 && lText.startsWith(lPrefix)) {
            lText = lText.substring(lPrefix.length());
        }
        Object lValue = ((ListSpinner)this.getSkinnable()).getStringConverter().fromString(lText);
        int lItemIndex = ((ListSpinner)this.getSkinnable()).getItems().indexOf(lValue);
        if (lItemIndex >= 0) {
            ((ListSpinner)this.getSkinnable()).setValue(lValue);
            return;
        }
        Callback lAddCallback = ((ListSpinner)this.getSkinnable()).getAddCallback();
        if (lAddCallback != null && (lIndex = (Integer)lAddCallback.call(lValue)) != null) {
            ((ListSpinner)this.getSkinnable()).setIndex(lIndex);
            return;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<ListSpinner<?>, ArrowPosition> ARROW_POSITION = new CssMetaDataForSkinProperty<ListSpinner<?>, ListSpinnerSkin<?>, ArrowPosition>("-fxx-arrow-position", (StyleConverter)new EnumConverter(ArrowPosition.class), ArrowPosition.TRAILING){

            protected ObjectProperty<ArrowPosition> getProperty(ListSpinnerSkin<?> s) {
                return s.arrowPositionProperty();
            }
        };
        private static final CssMetaData<ListSpinner<?>, ArrowDirection> ARROW_DIRECTION = new CssMetaDataForSkinProperty<ListSpinner<?>, ListSpinnerSkin<?>, ArrowDirection>("-fxx-arrow-direction", (StyleConverter)new EnumConverter(ArrowDirection.class), ArrowDirection.HORIZONTAL){

            protected ObjectProperty<ArrowDirection> getProperty(ListSpinnerSkin<?> s) {
                return s.arrowDirectionProperty();
            }
        };
        private static final CssMetaData<ListSpinner<?>, Pos> VALUE_ALIGNMENT = new CssMetaDataForSkinProperty<ListSpinner<?>, ListSpinnerSkin<?>, Pos>("-fxx-value-alignment", (StyleConverter)new EnumConverter(Pos.class), Pos.CENTER_LEFT){

            protected ObjectProperty<Pos> getProperty(ListSpinnerSkin<?> s) {
                return s.valueAlignmentProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return ARROW_POSITION;
        }

        static /* synthetic */ CssMetaData access$300() {
            return ARROW_DIRECTION;
        }

        static /* synthetic */ CssMetaData access$400() {
            return VALUE_ALIGNMENT;
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(ARROW_POSITION);
            styleables.add(ARROW_DIRECTION);
            styleables.add(VALUE_ALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum ArrowDirection {
        VERTICAL,
        HORIZONTAL;

    }

    public static enum ArrowPosition {
        LEADING,
        TRAILING,
        SPLIT;

    }
}

