package jfxtras.labs.scene.control.scheduler.skin;

import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.css.converters.IntegerConverter;
import jfxtras.labs.scene.control.scheduler.Scheduler;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SchedulerDaysFromDisplayedSkin extends SchedulerSkinAbstract<SchedulerDaysFromDisplayedSkin> {

    public SchedulerDaysFromDisplayedSkin(Scheduler control) {
        super(control);

        construct();
    }

    /**
     *
     */
    private void construct() {
        // days back
        daysBeforeSlider = new Slider(-20.0, 0.0, (double)daysBackDefault);
        daysBeforeSlider.setId("daysBeforeSlider");
        daysBeforeSlider.minProperty().bind(daysBeforeFurthestProperty);
        daysBeforeSlider.snapToTicksProperty().set(true);
        daysBeforeSlider.majorTickUnitProperty().set(1.0);
        daysBeforeSlider.minorTickCountProperty().set(0);
        daysBeforeSlider.showTickLabelsProperty().set(true);
        daysBeforeSlider.prefWidthProperty().bind(borderPane.widthProperty().divide(2.0));
// Until JDK-8133008 is fixed we use the valueChangingProperty and Math.round:
//		daysBeforeSlider.valueProperty().addListener( (observable) -> {
//			System.out.println("back " + daysBeforeSlider.getValue());
//			if (daysBeforeSlider.valueChangingProperty().get() == false) {
//				System.out.println("back reconstruct"); // TBEERNOT: min and max slider positions are not processed
//				reconstruct();
//			}
//		});
        daysBeforeSlider.valueChangingProperty().addListener( (observable) -> {
            if (!daysBeforeSlider.valueChangingProperty().get()) {
                reconstruct();
            }
        });


        // days forward
        daysAfterSlider = new Slider(0.0, 20.0, (double)daysForwardDefault);
        daysAfterSlider.setId("daysAfterSlider");
        daysAfterSlider.maxProperty().bind(daysAfterFurthestProperty);
        daysAfterSlider.snapToTicksProperty().set(true);
        daysAfterSlider.majorTickUnitProperty().set(1.0);
        daysAfterSlider.minorTickCountProperty().set(0);
        daysAfterSlider.showTickLabelsProperty().set(true);
        daysAfterSlider.prefWidthProperty().bind(borderPane.widthProperty().divide(2.0));
// Until JDK-8133008 is fixed we use the valueChangingProperty and Math.round:
//		daysAfterSlider.valueProperty().addListener( (observable) -> {
//			System.out.println("forward " + daysAfterSlider.getValue());
//			if (daysAfterSlider.valueChangingProperty().get() == false) {
//				System.out.println("forward reconstruct"); // TBEERNOT: min and max slider positions are not processed
//				reconstruct();
//			}
//		});
        daysAfterSlider.valueChangingProperty().addListener( (observable) -> {
            if (!daysAfterSlider.valueChangingProperty().get()) {
                reconstruct();
            }
        });

        // put the sliders at the bottom
        borderPane.setBottom(new HBox(daysBeforeSlider, daysAfterSlider));
    }
    private Slider daysBeforeSlider;
    private Slider daysAfterSlider;
    final private int daysBackDefault = -1;
    final private int daysForwardDefault = 6;

    /**
     *
     */
    protected void reconstruct() {
        super.reconstruct();

        // put the sliders at the bottom
        borderPane.setBottom(new HBox(daysBeforeSlider, daysAfterSlider));
    }

    /**
     * Assign a calendar to each day, so it knows what it must draw.
     */
    protected List<LocalDate> determineDisplayedLocalDates()
    {
        // get slider positions
        int lStartOffset = (daysBeforeSlider == null ? daysBackDefault : (int) Math.round(daysBeforeSlider.valueProperty().get())); // Until JDK-8133008 is fixed we use the valueChangingProperty and Math.round:
        int lEndOffset = (daysAfterSlider == null ? daysForwardDefault : (int) Math.round(daysAfterSlider.valueProperty().get())); // Until JDK-8133008 is fixed we use the valueChangingProperty and Math.round:
        LocalDate lStartLocalDate = getSkinnable().getDisplayedLocalDateTime().toLocalDate();

        // determine displayed calendars
        String lKey = lStartOffset + " / "  + lEndOffset + " / " + lStartLocalDate;
        if (!lKey.equals(displayedLocalDatesKey)) {

            // determine displayed calendars
            displayedLocalDates = new ArrayList<>();
            for (int i = lStartOffset; i < lEndOffset + 1; i++) { // + 1 = always show today
                displayedLocalDates.add(lStartLocalDate.plusDays(i));
            }
            displayedLocalDatesKey = lKey;
        }

        // done
        return displayedLocalDates;
    }
    private String displayedLocalDatesKey = "";
    private List<LocalDate> displayedLocalDates;

    // ==================================================================================================================
    // StyleableProperties

    /**
     * daysBeforeFurthestProperty
     */
    public final ObjectProperty<Integer> daysBeforeFurthestProperty() { return daysBeforeFurthestProperty; }
    private ObjectProperty<Integer> daysBeforeFurthestProperty = new SimpleStyleableObjectProperty<Integer>(SchedulerDaysFromDisplayedSkin.StyleableProperties.DAYS_BEFORE_FURTHEST_CSSMETADATA, SchedulerDaysFromDisplayedSkin.StyleableProperties.DAYS_BEFORE_FURTHEST_CSSMETADATA.getInitialValue(null)) {
//		{ // anonymous constructor
//			addListener( (invalidationEvent) -> {
//				if (daysBeforeFurthestProperty.get() > 0) {
//					daysBeforeFurthestProperty.set(0);
//				}
//			});
//		}
    };
    public final void setDaysBeforeFurthest(int value) { daysBeforeFurthestProperty.set(value); }
    public final int getDaysBeforeFurthest() { return daysBeforeFurthestProperty.get(); }
    public final SchedulerDaysFromDisplayedSkin withDaysBeforeFurthest(int value) { setDaysBeforeFurthest(value); return this; }

    /**
     * daysAfterFurthestProperty
     */
    public final ObjectProperty<Integer> daysAfterFurthestProperty() { return daysAfterFurthestProperty; }
    private ObjectProperty<Integer> daysAfterFurthestProperty = new SimpleStyleableObjectProperty<Integer>(SchedulerDaysFromDisplayedSkin.StyleableProperties.DAYS_AFTER_FURTHEST_CSSMETADATA, SchedulerDaysFromDisplayedSkin.StyleableProperties.DAYS_AFTER_FURTHEST_CSSMETADATA.getInitialValue(null)) {
//		{ // anonymous constructor
//			addListener( (invalidationEvent) -> {
//				if (daysAfterFurthestProperty.get() < 0) {
//					daysAfterFurthestProperty.set(0);
//				}
//			});
//		}
    };
    public final void setDaysAfterFurthest(int value) { daysAfterFurthestProperty.set(value); }
    public final int getDaysAfterFurthest() { return daysAfterFurthestProperty.get(); }
    public final SchedulerDaysFromDisplayedSkin withDaysAfterFurthest(int value) { setDaysAfterFurthest(value); return this; }


    // -------------------------

    private static class StyleableProperties
    {
        private static final CssMetaData<Scheduler, Integer> DAYS_BEFORE_FURTHEST_CSSMETADATA = new CssMetaDataForSkinProperty<Scheduler, SchedulerDaysFromDisplayedSkin, Integer>("-fxx-days-before-furthest", IntegerConverter.getInstance(), -9 ) {
            @Override
            protected ObjectProperty<Integer> getProperty(SchedulerDaysFromDisplayedSkin s) {
                return s.daysBeforeFurthestProperty;
            }
        };

        private static final CssMetaData<Scheduler, Integer> DAYS_AFTER_FURTHEST_CSSMETADATA = new CssMetaDataForSkinProperty<Scheduler, SchedulerDaysFromDisplayedSkin, Integer>("-fxx-days-after-furthest", IntegerConverter.getInstance(), 9 ) {
            @Override
            protected ObjectProperty<Integer> getProperty(SchedulerDaysFromDisplayedSkin s) {
                return s.daysAfterFurthestProperty;
            }
        };

        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        static  {
            final List<CssMetaData<? extends Styleable, ?>> classCssMetaData = new ArrayList<CssMetaData<? extends Styleable, ?>>(SchedulerSkinAbstract.getClassCssMetaData());
            classCssMetaData.add(DAYS_BEFORE_FURTHEST_CSSMETADATA);
            classCssMetaData.add(DAYS_AFTER_FURTHEST_CSSMETADATA);
            STYLEABLES = Collections.unmodifiableList(classCssMetaData);
        }
    }

    /**
     * @return The CssMetaData associated with this class, which may include the
     * CssMetaData of its super classes.
     */
    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return SchedulerDaysFromDisplayedSkin.StyleableProperties.STYLEABLES;
    }

    /**
     * This method should delegate to {@link Node#getClassCssMetaData()} so that
     * a Node's CssMetaData can be accessed without the need for reflection.
     * @return The CssMetaData associated with this node, which may include the
     * CssMetaData of its super classes.
     */
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return getClassCssMetaData();
    }
}
