/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.TranslateTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.ToggleSwitch;

public class ToggleSwitchSkin
extends SkinBase<ToggleSwitch> {
    private HBox mainContainer = new HBox();
    private final Label label = new Label();
    private final StackPane labelContainer = new StackPane();
    private final InnerToggleSwitch innerToggleSwitch;
    private InvalidationListener thumbDisplayChanged = observable -> this.updateThumbDisplay(this.getThumbDisplay());
    private DoubleProperty thumbMoveAnimationTime = null;
    private StyleableObjectProperty<ThumbDisplay> thumbDisplay = new SimpleStyleableObjectProperty<ThumbDisplay>(THUMB_DISPLAY_META_DATA, ThumbDisplay.LEFT){

        protected void invalidated() {
            ((ToggleSwitch)ToggleSwitchSkin.this.getSkinnable()).requestLayout();
        }
    };
    private static final CssMetaData<ToggleSwitch, Number> THUMB_MOVE_ANIMATION_TIME_META_DATA = new CssMetaData<ToggleSwitch, Number>("-thumb-move-animation-time", SizeConverter.getInstance(), (Number)200){

        public boolean isSettable(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return skin.thumbMoveAnimationTime == null || !skin.thumbMoveAnimationTime.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return (StyleableProperty)skin.thumbMoveAnimationTimeProperty();
        }
    };
    private static final CssMetaData<ToggleSwitch, ThumbDisplay> THUMB_DISPLAY_META_DATA = new CssMetaData<ToggleSwitch, ThumbDisplay>("-toggle-display", (StyleConverter)new EnumConverter(ThumbDisplay.class)){

        public boolean isSettable(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return !skin.thumbDisplay.isBound();
        }

        public StyleableProperty<ThumbDisplay> getStyleableProperty(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return skin.thumbDisplayProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ToggleSwitchSkin(ToggleSwitch control) {
        super((Control)control);
        this.innerToggleSwitch = new InnerToggleSwitch(this);
        this.label.textProperty().bind((ObservableValue)control.textProperty());
        this.mainContainer.getStyleClass().setAll((Object[])new String[]{"main-container"});
        this.getChildren().setAll((Object[])new Node[]{this.mainContainer});
        this.labelContainer.getChildren().addAll((Object[])new Node[]{this.label});
        StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
        this.labelContainer.getStyleClass().setAll((Object[])new String[]{"label-container"});
        this.updateThumbDisplay(this.getThumbDisplay());
        this.thumbDisplay.addListener(this.thumbDisplayChanged);
    }

    private void updateThumbDisplay(ThumbDisplay thumbDisplay) {
        switch (thumbDisplay) {
            case LEFT: {
                this.mainContainer.getChildren().setAll((Object[])new Node[]{this.innerToggleSwitch, this.labelContainer});
                break;
            }
            case RIGHT: {
                this.mainContainer.getChildren().setAll((Object[])new Node[]{this.labelContainer, this.innerToggleSwitch});
                break;
            }
            case THUMB_ONLY: {
                this.mainContainer.getChildren().setAll((Object[])new Node[]{this.innerToggleSwitch});
            }
        }
    }

    public void dispose() {
        this.thumbDisplay.removeListener(this.thumbDisplayChanged);
        super.dispose();
    }

    private DoubleProperty thumbMoveAnimationTimeProperty() {
        if (this.thumbMoveAnimationTime == null) {
            this.thumbMoveAnimationTime = new StyleableDoubleProperty(200.0){

                public Object getBean() {
                    return ToggleSwitchSkin.this;
                }

                public String getName() {
                    return "thumbMoveAnimationTime";
                }

                public CssMetaData<ToggleSwitch, Number> getCssMetaData() {
                    return THUMB_MOVE_ANIMATION_TIME_META_DATA;
                }
            };
        }
        return this.thumbMoveAnimationTime;
    }

    private double getThumbMoveAnimationTime() {
        return this.thumbMoveAnimationTime == null ? 200.0 : this.thumbMoveAnimationTime.get();
    }

    private StyleableObjectProperty<ThumbDisplay> thumbDisplayProperty() {
        return this.thumbDisplay;
    }

    private ThumbDisplay getThumbDisplay() {
        return (ThumbDisplay)((Object)this.thumbDisplay.get());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToggleSwitchSkin.getClassCssMetaData();
    }

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
        styleables.add(THUMB_MOVE_ANIMATION_TIME_META_DATA);
        styleables.add(THUMB_DISPLAY_META_DATA);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static class InnerToggleSwitch
    extends Region {
        private boolean isFirstLayoutPass = true;
        private final ToggleSwitchSkin toggleSwitchSkin;
        private final TranslateTransition transition;
        private final StackPane thumb = new StackPane();
        private InvalidationListener selectionChanged = observable -> this.selectedStateChanged();
        private EventHandler<MouseEvent> mouseReleased;

        public InnerToggleSwitch(ToggleSwitchSkin toggleSwitchSkin) {
            this.transition = new TranslateTransition(Duration.millis((double)toggleSwitchSkin.getThumbMoveAnimationTime()), (Node)this.thumb);
            this.transition.setInterpolator(Interpolator.EASE_OUT);
            this.toggleSwitchSkin = toggleSwitchSkin;
            this.getStyleClass().setAll((Object[])new String[]{"thumb-area"});
            this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
            this.getChildren().add((Object)this.thumb);
            this.thumb.setMouseTransparent(true);
            ToggleSwitch skinnable = (ToggleSwitch)toggleSwitchSkin.getSkinnable();
            this.mouseReleased = event -> this.onMouseReleased(skinnable);
            this.setOnMouseReleased(this.mouseReleased);
            this.initThumbTransformX();
            skinnable.selectedProperty().addListener(this.selectionChanged);
        }

        private void onMouseReleased(ToggleSwitch toggleSwitch) {
            toggleSwitch.setSelected(!toggleSwitch.isSelected());
        }

        private void initThumbTransformX() {
            if (!((ToggleSwitch)this.toggleSwitchSkin.getSkinnable()).isSelected()) {
                this.thumb.setTranslateX(0.0);
            } else {
                this.thumb.setTranslateX(this.calculateSelectedToggleTranslateX());
            }
        }

        private void selectedStateChanged() {
            ToggleSwitch toggleSwitch = (ToggleSwitch)this.toggleSwitchSkin.getSkinnable();
            this.transition.stop();
            this.transition.setDuration(Duration.millis((double)this.toggleSwitchSkin.getThumbMoveAnimationTime()));
            double thumbTranslateSelectedX = this.calculateSelectedToggleTranslateX();
            if (!toggleSwitch.isSelected()) {
                this.transition.setFromX(thumbTranslateSelectedX);
                this.transition.setToX(0.0);
            } else {
                this.transition.setFromX(0.0);
                this.transition.setToX(thumbTranslateSelectedX);
            }
            this.transition.setCycleCount(1);
            this.transition.play();
        }

        private double calculateSelectedToggleTranslateX() {
            double thumbAreaWidth = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            double thumbWidth = this.snapSizeX(this.thumb.prefWidth(-1.0));
            return thumbAreaWidth - thumbWidth;
        }

        protected void layoutChildren() {
            double x = this.snappedLeftInset();
            double y = this.snappedTopInset();
            double height = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
            double thumbWidth = this.thumb.prefWidth(-1.0);
            double thumbHeight = this.thumb.prefHeight(-1.0);
            this.thumb.resize(this.snapSizeX(thumbWidth), this.snapSizeY(thumbHeight));
            this.thumb.setLayoutX(this.snapPositionX(x));
            this.thumb.setLayoutY(this.snapPositionY(y + height / 2.0) - thumbHeight / 2.0);
            if (this.isFirstLayoutPass) {
                this.initThumbTransformX();
            }
        }
    }

    private static enum ThumbDisplay {
        LEFT,
        RIGHT,
        THUMB_ONLY;

    }
}

