/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.styles.jmetro;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import jfxtras.styles.jmetro.FlatDialog;

public class FlatTextInputDialog
extends TextInputDialog {
    private BooleanProperty iconless = new SimpleBooleanProperty(true);
    private boolean isResettingIcon;

    public FlatTextInputDialog() {
        this.init();
    }

    public FlatTextInputDialog(String defaultValue) {
        super(defaultValue);
        this.init();
    }

    private void init() {
        FlatDialog.initDialog(this, this.isIconless());
        this.setupDialogIconsListener();
    }

    private void setupDialogIconsListener() {
        Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
        stage.getIcons().addListener(this::dialogIconsChanged);
    }

    private void dialogIconsChanged(ListChangeListener.Change<? extends Image> c) {
        if (this.isResettingIcon) {
            return;
        }
        this.isResettingIcon = true;
        FlatDialog.initDialogIcon(this, this.isIconless());
        this.isResettingIcon = false;
    }

    public boolean isIconless() {
        return this.iconless.get();
    }

    public BooleanProperty iconlessProperty() {
        return this.iconless;
    }

    public void setIconless(boolean iconless) {
        this.iconless.set(iconless);
    }
}

