/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro8;

import javafx.animation.Interpolator;
import javafx.animation.ScaleTransition;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

class ButtonAnimationHelper {
    public static final String SHRINK_ANIMATE_ON_PRESS_PROPERTY_NAME = "-shrink-animate-on-press";
    private static final Duration SCALE_TRANSITION_DURATION = Duration.millis((double)400.0);
    private static final double SCALE_ON_PRESS = 0.97;
    private boolean keyPressed = false;
    private BooleanProperty buttonShrinkAnimateOnPressProperty;

    private ButtonAnimationHelper(ButtonBase button, BooleanProperty buttonShrinkAnimateOnPressProperty) {
        this.buttonShrinkAnimateOnPressProperty = buttonShrinkAnimateOnPressProperty;
        button.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.onButtonPressed(button));
        button.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> this.onButtonReleased(button));
        button.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.SPACE) {
                this.onButtonPressed(button);
                this.keyPressed = true;
            }
        });
        button.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (this.keyPressed) {
                this.onButtonReleased(button);
                this.keyPressed = false;
            }
        });
    }

    static ButtonAnimationHelper setupButton(ButtonBase button, BooleanProperty buttonShrinkAnimateOnPressProperty) {
        return new ButtonAnimationHelper(button, buttonShrinkAnimateOnPressProperty);
    }

    private void onButtonPressed(ButtonBase button) {
        if (this.buttonShrinkAnimateOnPressProperty.get()) {
            button.setScaleX(0.97);
            button.setScaleY(0.97);
        }
    }

    private void onButtonReleased(ButtonBase button) {
        if (this.buttonShrinkAnimateOnPressProperty.get()) {
            ScaleTransition scaleTransition = new ScaleTransition(SCALE_TRANSITION_DURATION, (Node)button);
            scaleTransition.setInterpolator(Interpolator.EASE_OUT);
            scaleTransition.setToX(1.0);
            scaleTransition.setToY(1.0);
            scaleTransition.play();
        }
    }
}

