/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro8;

import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;

class SliderPopup
extends PopupControl {
    private static final String DEFAULT_STYLE_CLASS = "slider-popup";
    private DoubleProperty value = new SimpleDoubleProperty();

    SliderPopup() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    DoubleProperty valueProperty() {
        return this.value;
    }

    double getValue() {
        return this.value.get();
    }

    void setValue(double value) {
        this.value.set(value);
    }

    protected Skin<?> createDefaultSkin() {
        return new SliderPopupSkin(this);
    }

    private class SliderPopupSkin
    implements Skin<SliderPopup> {
        SliderPopup skinnable;
        Label valueText;

        SliderPopupSkin(SliderPopup control) {
            this.skinnable = control;
            this.valueText = new Label();
            this.valueText.textProperty().bind((ObservableValue)new StringBinding(){
                {
                    super.bind(new Observable[]{SliderPopupSkin.this.skinnable.valueProperty()});
                }

                protected String computeValue() {
                    return String.valueOf(Math.round(SliderPopupSkin.this.skinnable.getValue()));
                }
            });
        }

        public SliderPopup getSkinnable() {
            return this.skinnable;
        }

        public Node getNode() {
            return this.valueText;
        }

        public void dispose() {
        }
    }
}

