/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro8;

import com.sun.javafx.scene.control.skin.TextFieldSkin;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class TextFieldWithButtonSkin
extends TextFieldSkin {
    private StackPane rightButton;
    private Region rightButtonGraphic;
    protected TextField textField;

    public TextFieldWithButtonSkin(TextField textField) {
        super(textField);
        this.textField = textField;
        this.rightButton = new StackPane();
        this.rightButton.getStyleClass().setAll((Object[])new String[]{"right-button"});
        this.rightButton.setFocusTraversable(false);
        this.rightButtonGraphic = new Region();
        this.rightButtonGraphic.getStyleClass().setAll((Object[])new String[]{"right-button-graphic"});
        this.rightButtonGraphic.setFocusTraversable(false);
        this.rightButtonGraphic.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.rightButtonGraphic.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.rightButton.setVisible(false);
        this.rightButtonGraphic.setVisible(false);
        this.rightButton.getChildren().add((Object)this.rightButtonGraphic);
        this.getChildren().add((Object)this.rightButton);
        this.setupListeners();
    }

    private void setupListeners() {
        TextField textField = (TextField)this.getSkinnable();
        this.rightButton.setOnMousePressed(event -> this.rightButtonPressed());
        this.rightButton.setOnMouseReleased(event -> this.rightButtonReleased());
        textField.textProperty().addListener((observable, oldValue, newValue) -> this.textChanged());
        textField.focusedProperty().addListener((observable, oldValue, newValue) -> this.focusChanged());
    }

    protected void textChanged() {
        if (this.textField.getText() == null) {
            return;
        }
        this.rightButton.setVisible(!this.textField.getText().isEmpty());
        this.rightButtonGraphic.setVisible(!this.textField.getText().isEmpty());
    }

    protected void focusChanged() {
        if (this.textField.getText() == null) {
            return;
        }
        this.rightButton.setVisible(this.textField.isFocused() && !this.textField.getText().isEmpty());
        this.rightButtonGraphic.setVisible(this.textField.isFocused() && !this.textField.getText().isEmpty());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double clearGraphicWidth = this.snapSize(this.rightButtonGraphic.prefWidth(-1.0));
        double clearButtonWidth = this.rightButton.snappedLeftInset() + clearGraphicWidth + this.rightButton.snappedRightInset();
        this.rightButton.resize(clearButtonWidth, h);
        this.positionInArea((Node)this.rightButton, x + w - clearButtonWidth, y, clearButtonWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
    }

    protected void rightButtonPressed() {
    }

    protected void rightButtonReleased() {
    }
}

