/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro8;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.ToggleSwitch;

public class ToggleSwitchSkin
extends SkinBase<ToggleSwitch> {
    private final StackPane thumb;
    private final StackPane thumbArea;
    private final Label label;
    private final StackPane labelContainer;
    private final TranslateTransition transition;
    private DoubleProperty thumbMoveAnimationTime = null;
    private StyleableObjectProperty<ThumbDisplay> thumbDisplay = new SimpleStyleableObjectProperty<ThumbDisplay>(THUMB_DISPLAY_META_DATA, ThumbDisplay.RIGHT){

        protected void invalidated() {
            ((ToggleSwitch)ToggleSwitchSkin.this.getSkinnable()).requestLayout();
        }
    };
    private static final CssMetaData<ToggleSwitch, Number> THUMB_MOVE_ANIMATION_TIME_META_DATA = new CssMetaData<ToggleSwitch, Number>("-thumb-move-animation-time", SizeConverter.getInstance(), (Number)200){

        public boolean isSettable(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return skin.thumbMoveAnimationTime == null || !skin.thumbMoveAnimationTime.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return (StyleableProperty)skin.thumbMoveAnimationTimeProperty();
        }
    };
    private static final CssMetaData<ToggleSwitch, ThumbDisplay> THUMB_DISPLAY_META_DATA = new CssMetaData<ToggleSwitch, ThumbDisplay>("-toggle-display", (StyleConverter)new EnumConverter(ThumbDisplay.class)){

        public boolean isSettable(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return !skin.thumbDisplay.isBound();
        }

        public StyleableProperty<ThumbDisplay> getStyleableProperty(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return skin.thumbDisplayProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ToggleSwitchSkin(ToggleSwitch control) {
        super((Control)control);
        this.thumb = new StackPane();
        this.thumbArea = new StackPane();
        this.label = new Label();
        this.labelContainer = new StackPane();
        this.transition = new TranslateTransition(Duration.millis((double)this.getThumbMoveAnimationTime()), (Node)this.thumb);
        this.transition.setInterpolator(Interpolator.EASE_OUT);
        this.label.textProperty().bind((ObservableValue)control.textProperty());
        this.getChildren().addAll((Object[])new Node[]{this.labelContainer, this.thumbArea, this.thumb});
        this.labelContainer.getChildren().addAll((Object[])new Node[]{this.label});
        StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumbArea.getStyleClass().setAll((Object[])new String[]{"thumb-area"});
        this.thumbArea.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        this.thumb.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        control.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() != oldValue.booleanValue()) {
                this.selectedStateChanged();
            }
        });
    }

    private void selectedStateChanged() {
        if (this.transition != null) {
            this.transition.stop();
            this.transition.setDuration(Duration.millis((double)this.getThumbMoveAnimationTime()));
        }
        double thumbAreaWidth = this.snapSize(this.thumbArea.prefWidth(-1.0));
        Insets thumbAreaPadding = this.thumbArea.getPadding();
        double thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        double distance = thumbAreaWidth - thumbWidth - thumbAreaPadding.getRight() - thumbAreaPadding.getLeft();
        if (!((ToggleSwitch)this.getSkinnable()).isSelected()) {
            this.thumb.setLayoutX(this.thumbArea.getLayoutX());
            this.transition.setFromX(distance);
            this.transition.setToX(0.0);
        } else {
            this.thumb.setTranslateX(this.thumbArea.getLayoutX());
            this.transition.setFromX(0.0);
            this.transition.setToX(distance);
        }
        this.transition.setCycleCount(1);
        this.transition.play();
    }

    private void mousePressedOnToggleSwitch(ToggleSwitch toggleSwitch) {
        toggleSwitch.setSelected(!toggleSwitch.isSelected());
    }

    private DoubleProperty thumbMoveAnimationTimeProperty() {
        if (this.thumbMoveAnimationTime == null) {
            this.thumbMoveAnimationTime = new StyleableDoubleProperty(200.0){

                public Object getBean() {
                    return ToggleSwitchSkin.this;
                }

                public String getName() {
                    return "thumbMoveAnimationTime";
                }

                public CssMetaData<ToggleSwitch, Number> getCssMetaData() {
                    return THUMB_MOVE_ANIMATION_TIME_META_DATA;
                }
            };
        }
        return this.thumbMoveAnimationTime;
    }

    private double getThumbMoveAnimationTime() {
        return this.thumbMoveAnimationTime == null ? 200.0 : this.thumbMoveAnimationTime.get();
    }

    private StyleableObjectProperty<ThumbDisplay> thumbDisplayProperty() {
        return this.thumbDisplay;
    }

    private ThumbDisplay getThumbDisplay() {
        return (ThumbDisplay)((Object)this.thumbDisplay.get());
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double labelX;
        double thumbAreaX;
        ToggleSwitch toggleSwitch = (ToggleSwitch)this.getSkinnable();
        double thumbWidth = this.thumb.prefWidth(-1.0);
        double thumbHeight = this.thumb.prefHeight(-1.0);
        this.thumb.resize(this.snapSize(thumbWidth), this.snapSize(thumbHeight));
        double labelWidth = this.labelContainer.prefWidth(-1.0);
        Insets thumbAreaPadding = this.thumbArea.getPadding();
        double thumbAreaWidth = this.thumbArea.prefWidth(-1.0);
        double thumbAreaHeight = this.thumbArea.prefHeight(-1.0);
        if (this.getThumbDisplay().equals((Object)ThumbDisplay.RIGHT)) {
            thumbAreaX = contentWidth - thumbAreaWidth;
            labelX = contentX;
        } else if (this.getThumbDisplay().equals((Object)ThumbDisplay.LEFT)) {
            thumbAreaX = contentX;
            labelX = contentWidth - labelWidth;
        } else {
            thumbAreaX = contentX;
            labelX = 0.0;
        }
        double thumbAreaY = contentY;
        this.thumbArea.resize(this.snapSize(thumbAreaWidth), this.snapSize(thumbAreaHeight));
        this.thumbArea.setLayoutX(this.snapPosition(thumbAreaX));
        this.thumbArea.setLayoutY(this.snapPosition(thumbAreaY));
        if (!this.getThumbDisplay().equals((Object)ThumbDisplay.THUMB_ONLY)) {
            this.labelContainer.resize(this.snapSize(contentWidth - thumbAreaWidth), this.snapSize(thumbAreaHeight));
            this.labelContainer.setLayoutY(this.snapPosition(thumbAreaY));
            this.labelContainer.setLayoutX(this.snapPosition(labelX));
        }
        if (!toggleSwitch.isSelected()) {
            this.thumb.setLayoutX(this.snapPosition(thumbAreaX + thumbAreaPadding.getLeft()));
        } else {
            this.thumb.setLayoutX(this.snapPosition(thumbAreaX + thumbAreaWidth - thumbAreaPadding.getRight() - thumbWidth));
        }
        this.thumb.setLayoutY(this.snapPosition(thumbAreaY + thumbAreaPadding.getBottom()));
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + 20.0 + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + bottomInset;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToggleSwitchSkin.getClassCssMetaData();
    }

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
        styleables.add(THUMB_MOVE_ANIMATION_TIME_META_DATA);
        styleables.add(THUMB_DISPLAY_META_DATA);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static enum ThumbDisplay {
        LEFT,
        RIGHT,
        THUMB_ONLY;

    }
}

