/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle.input;

import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.util.IntSet;

public class MouseState {
    public static final int WHEEL_NONE = 0;
    public static final int WHEEL_UP = 1;
    public static final int WHEEL_DOWN = -1;
    private int x;
    private int y;
    private int wheel;
    private MonocleWindow window;
    private IntSet buttonsPressed = new IntSet();

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWheel() {
        return this.wheel;
    }

    public void setWheel(int wheel) {
        this.wheel = wheel;
    }

    public void pressButton(int button) {
        this.buttonsPressed.addInt(button);
    }

    public void releaseButton(int button) {
        this.buttonsPressed.removeInt(button);
    }

    MonocleWindow getWindow(boolean recalculateCache) {
        if (this.window == null || recalculateCache) {
            this.window = MonocleWindowManager.getInstance().getWindowForLocation(this.x, this.y);
        }
        return this.window;
    }

    int getButton() {
        return this.buttonsPressed.isEmpty() ? 211 : this.buttonsPressed.get(0);
    }

    int getModifiers() {
        int modifiers = 0;
        block5: for (int i = 0; i < this.buttonsPressed.size(); ++i) {
            switch (this.buttonsPressed.get(i)) {
                case 212: {
                    modifiers |= 0x20;
                    continue block5;
                }
                case 214: {
                    modifiers |= 0x80;
                    continue block5;
                }
                case 213: {
                    modifiers |= 0x40;
                }
            }
        }
        return modifiers;
    }

    public void copyTo(MouseState target) {
        target.x = this.x;
        target.y = this.y;
        target.wheel = this.wheel;
        this.buttonsPressed.copyTo(target.buttonsPressed);
        target.window = this.window;
    }

    public IntSet getButtonsPressed() {
        return this.buttonsPressed;
    }

    public String toString() {
        return "MouseState[x=" + this.x + ",y=" + this.y + ",wheel=" + this.wheel + ",buttonsPressed=" + this.buttonsPressed + "]";
    }

    public boolean canBeFoldedWith(MouseState ms) {
        return ms.buttonsPressed.equals(this.buttonsPressed) && ms.wheel == this.wheel;
    }
}

