/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.jsse;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jsse.GlobusSSLConfigurationException;
import org.globus.gsi.jsse.GlobusSSLHelper;
import org.globus.gsi.provider.GlobusTrustManagerFactoryParameters;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.proxy.ProxyPolicyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLConfigurator {
    private String provider;
    private String protocol = "TLS";
    private String secureRandomAlgorithm;
    private KeyStore credentialStore;
    private KeyStore trustAnchorStore;
    private CertStore crlStore;
    private SigningPolicyStore policyStore;
    private boolean rejectLimitProxy;
    private Map<String, ProxyPolicyHandler> handlers;
    private String trustAnchorStoreType;
    private String trustAnchorStoreLocation;
    private String trustAnchorStorePassword;
    private String credentialStoreType;
    private String credentialStoreLocation;
    private String credentialStorePassword;
    private String crlStoreType;
    private String crlLocationPattern;
    private SSLContext sslContext;
    private Log logger = LogFactory.getLog(this.getClass());
    private String sslKeyManagerFactoryAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");

    public SSLSocketFactory createFactory() throws GlobusSSLConfigurationException {
        return this.getSSLContext().getSocketFactory();
    }

    public SSLContext getSSLContext() throws GlobusSSLConfigurationException {
        if (this.sslContext == null) {
            this.configureContext();
        }
        return this.sslContext;
    }

    public SSLServerSocketFactory createServerFactory() throws GlobusSSLConfigurationException {
        SSLContext context = this.getSSLContext();
        return context.getServerSocketFactory();
    }

    private void configureContext() throws GlobusSSLConfigurationException {
        TrustManager[] trustManagers;
        ManagerFactoryParameters parameters = this.getCertPathParameters();
        try {
            TrustManagerFactory fact = TrustManagerFactory.getInstance("GSI");
            fact.init(parameters);
            trustManagers = fact.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e1) {
            throw new GlobusSSLConfigurationException(e1);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        KeyManager[] keyManagers = this.loadKeyManagers();
        SecureRandom secureRandom = this.loadSecureRandom();
        this.sslContext = this.loadSSLContext();
        try {
            this.sslContext.init(keyManagers, trustManagers, secureRandom);
        }
        catch (KeyManagementException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    private ManagerFactoryParameters getCertPathParameters() throws GlobusSSLConfigurationException {
        KeyStore inputTrustStore;
        if (this.trustAnchorStore == null) {
            this.logger.trace((Object)"No trustAnchorStore available");
            inputTrustStore = GlobusSSLHelper.buildTrustStore(this.provider, this.trustAnchorStoreType, this.trustAnchorStoreLocation, this.trustAnchorStorePassword);
        } else {
            inputTrustStore = this.trustAnchorStore;
        }
        CertStore inputCertStore = this.crlStore != null ? this.crlStore : GlobusSSLHelper.findCRLStore(this.crlLocationPattern);
        GlobusTrustManagerFactoryParameters parameters = this.handlers == null ? new GlobusTrustManagerFactoryParameters(inputTrustStore, inputCertStore, this.policyStore, this.rejectLimitProxy) : new GlobusTrustManagerFactoryParameters(inputTrustStore, inputCertStore, this.policyStore, this.rejectLimitProxy, this.handlers);
        return parameters;
    }

    private SSLContext loadSSLContext() throws GlobusSSLConfigurationException {
        try {
            return this.provider == null ? SSLContext.getInstance(this.protocol) : SSLContext.getInstance(this.protocol, this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchProviderException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    private SecureRandom loadSecureRandom() throws GlobusSSLConfigurationException {
        try {
            return this.secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this.secureRandomAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    private KeyManager[] loadKeyManagers() throws GlobusSSLConfigurationException {
        try {
            KeyStore inputKeyStore;
            if (this.credentialStore == null) {
                if (this.credentialStoreLocation == null) {
                    return null;
                }
                inputKeyStore = GlobusSSLHelper.findCredentialStore(this.provider, this.credentialStoreType, this.credentialStoreLocation, this.credentialStorePassword);
            } else {
                inputKeyStore = this.credentialStore;
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.sslKeyManagerFactoryAlgorithm);
            keyManagerFactory.init(inputKeyStore, this.credentialStorePassword == null ? null : this.credentialStorePassword.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getCredentialStorePassword() {
        return this.credentialStorePassword;
    }

    public void setCredentialStorePassword(String credentialStorePassword) {
        this.credentialStorePassword = credentialStorePassword;
    }

    public KeyStore getTrustAnchorStore() {
        return this.trustAnchorStore;
    }

    public void setTrustAnchorStore(KeyStore trustAnchorStore) {
        this.trustAnchorStore = trustAnchorStore;
    }

    public CertStore getCrlStore() {
        return this.crlStore;
    }

    public void setCrlStore(CertStore crlStore) {
        this.crlStore = crlStore;
    }

    public SigningPolicyStore getPolicyStore() {
        return this.policyStore;
    }

    public void setPolicyStore(SigningPolicyStore policyStore) {
        this.policyStore = policyStore;
    }

    public boolean isRejectLimitProxy() {
        return this.rejectLimitProxy;
    }

    public void setRejectLimitProxy(boolean rejectLimitProxy) {
        this.rejectLimitProxy = rejectLimitProxy;
    }

    public Map<String, ProxyPolicyHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Map<String, ProxyPolicyHandler> handlers) {
        this.handlers = handlers;
    }

    public String getCredentialStoreLocation() {
        return this.credentialStoreLocation;
    }

    public void setCredentialStoreLocation(String credentialStoreLocation) {
        this.credentialStoreLocation = credentialStoreLocation;
    }

    public String getCredentialStoreType() {
        return this.credentialStoreType;
    }

    public void setCredentialStoreType(String credentialStoreType) {
        this.credentialStoreType = credentialStoreType;
    }

    public String getTrustAnchorStoreType() {
        return this.trustAnchorStoreType;
    }

    public void setTrustAnchorStoreType(String trustAnchorStoreType) {
        this.trustAnchorStoreType = trustAnchorStoreType;
    }

    public String getTrustAnchorStoreLocation() {
        return this.trustAnchorStoreLocation;
    }

    public void setTrustAnchorStoreLocation(String trustAnchorStoreLocation) {
        this.trustAnchorStoreLocation = trustAnchorStoreLocation;
    }

    public String getTrustAnchorStorePassword() {
        return this.trustAnchorStorePassword;
    }

    public void setTrustAnchorStorePassword(String trustAnchorStorePassword) {
        this.trustAnchorStorePassword = trustAnchorStorePassword;
    }

    public String getCrlStoreType() {
        return this.crlStoreType;
    }

    public void setCrlStoreType(String crlStoreType) {
        this.crlStoreType = crlStoreType;
    }

    public String getCrlLocationPattern() {
        return this.crlLocationPattern;
    }

    public void setCrlLocationPattern(String crlLocationPattern) {
        this.crlLocationPattern = crlLocationPattern;
    }

    public KeyStore getCredentialStore() {
        return this.credentialStore;
    }

    public void setCredentialStore(KeyStore credentialStore) {
        this.credentialStore = credentialStore;
    }
}

