/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.trustmanager.CertificateChecker;
import org.globus.gsi.util.ProxyCertificateUtil;

public class SigningPolicyChecker
implements CertificateChecker {
    private SigningPolicyStore policyStore;

    public SigningPolicyChecker(SigningPolicyStore policyStore) {
        this.policyStore = policyStore;
    }

    public void invoke(X509Certificate cert, GSIConstants.CertificateType certType) throws CertPathValidatorException {
        SigningPolicy policy;
        if (!this.requireSigningPolicyCheck(certType)) {
            return;
        }
        X500Principal caPrincipal = cert.getIssuerX500Principal();
        try {
            policy = this.policyStore.getSigningPolicy(caPrincipal);
        }
        catch (CertStoreException e) {
            throw new CertPathValidatorException(e);
        }
        if (policy == null) {
            throw new CertPathValidatorException("No signing policy for " + cert.getIssuerDN());
        }
        boolean valid = policy.isValidSubject(cert.getSubjectX500Principal());
        if (!valid) {
            throw new CertPathValidatorException("Certificate " + cert.getSubjectDN() + " violates signing policy for CA " + caPrincipal.getName());
        }
    }

    private boolean requireSigningPolicyCheck(GSIConstants.CertificateType certType) {
        return !ProxyCertificateUtil.isProxy(certType) && certType != GSIConstants.CertificateType.CA;
    }
}

