/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapes.webconlet.examples.login;

import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Future;
import javax.security.auth.Subject;
import org.jgrapes.core.Channel;
import org.jgrapes.core.Components;
import org.jgrapes.core.Event;
import org.jgrapes.core.annotation.Handler;
import org.jgrapes.http.Session;
import org.jgrapes.http.events.DiscardSession;
import org.jgrapes.io.events.Close;
import org.jgrapes.webconsole.base.Conlet;
import org.jgrapes.webconsole.base.ConletBaseModel;
import org.jgrapes.webconsole.base.ConsoleConnection;
import org.jgrapes.webconsole.base.ConsoleUser;
import org.jgrapes.webconsole.base.WebConsoleUtils;
import org.jgrapes.webconsole.base.events.AddConletRequest;
import org.jgrapes.webconsole.base.events.AddConletType;
import org.jgrapes.webconsole.base.events.AddPageResources;
import org.jgrapes.webconsole.base.events.CloseModalDialog;
import org.jgrapes.webconsole.base.events.ConsolePrepared;
import org.jgrapes.webconsole.base.events.ConsoleReady;
import org.jgrapes.webconsole.base.events.NotifyConletModel;
import org.jgrapes.webconsole.base.events.NotifyConletView;
import org.jgrapes.webconsole.base.events.OpenModalDialog;
import org.jgrapes.webconsole.base.events.RenderConlet;
import org.jgrapes.webconsole.base.events.RenderConletRequestBase;
import org.jgrapes.webconsole.base.events.SetLocale;
import org.jgrapes.webconsole.base.events.SimpleConsoleCommand;
import org.jgrapes.webconsole.base.freemarker.FreeMarkerConlet;

public class LoginConlet
extends FreeMarkerConlet<AccountModel> {
    private static final String PENDING_CONSOLE_PREPARED = "pendingCosolePrepared";

    public LoginConlet(Channel componentChannel) {
        super(componentChannel);
    }

    protected String generateInstanceId(AddConletRequest event, ConsoleConnection session) {
        return "Singleton";
    }

    @Handler
    public void onConsoleReady(ConsoleReady event, ConsoleConnection channel) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        channel.respond((Event)new AddConletType(this.type()).addScript(new AddPageResources.ScriptResource().setScriptUri(event.renderSupport().conletResource(this.type(), "Login-functions.js")).setScriptType("module")).addCss(event.renderSupport(), WebConsoleUtils.uriFromPath((String)"Login-style.css")).addPageContent("headerIcons", Map.of("priority", "1000")).addRenderMode(Conlet.RenderMode.Content));
    }

    protected Optional<AccountModel> createNewState(AddConletRequest event, ConsoleConnection session, String conletId) throws Exception {
        Optional model = this.stateFromSession(session.session(), conletId);
        if (model.isPresent()) {
            return model;
        }
        return super.createNewState(event, session, conletId);
    }

    protected Optional<AccountModel> createStateRepresentation(RenderConletRequestBase<?> event, ConsoleConnection channel, String conletId) throws IOException {
        return Optional.of(new AccountModel(conletId));
    }

    @Handler(priority=1000)
    public void onConsolePrepared(ConsolePrepared event, ConsoleConnection channel) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        if (channel.session().containsKey(Subject.class)) {
            return;
        }
        event.suspendHandling();
        channel.setAssociated((Object)PENDING_CONSOLE_PREPARED, (Object)event);
        String conletId = this.type() + "~Singleton";
        AccountModel accountModel = new AccountModel(conletId);
        accountModel.setDialogOpen(true);
        this.putInSession(channel.session(), conletId, (Object)accountModel);
        Template tpl = this.freemarkerConfig().getTemplate("Login-dialog.ftl.html");
        ResourceBundle bundle = this.resourceBundle(channel.locale());
        channel.respond((Event)new OpenModalDialog(this.type(), conletId, this.processTemplate((Event<?>)event, tpl, this.fmSessionModel(channel.session()))).addOption("title", (Object)bundle.getString("title")).addOption("cancelable", (Object)false).addOption("okayLabel", (Object)"").addOption("applyLabel", (Object)bundle.getString("Submit")).addOption("useSubmit", (Object)true));
    }

    private Future<String> processTemplate(Event<?> request, Template template, Object dataModel) {
        return request.processedBy().map(procBy -> procBy.executorService()).orElse(Components.defaultExecutorService()).submit(() -> {
            StringWriter out = new StringWriter();
            try {
                template.process(dataModel, (Writer)out);
            }
            catch (TemplateException | IOException e) {
                throw new IllegalArgumentException(e);
            }
            return out.toString();
        });
    }

    protected Set<Conlet.RenderMode> doRenderConlet(RenderConletRequestBase<?> event, ConsoleConnection channel, String conletId, AccountModel model) throws Exception {
        HashSet<Conlet.RenderMode> renderedAs = new HashSet<Conlet.RenderMode>();
        if (event.renderAs().contains(Conlet.RenderMode.Content)) {
            Template tpl = this.freemarkerConfig().getTemplate("Login-status.ftl.html");
            channel.respond((Event)new RenderConlet(this.type(), conletId, this.processTemplate(event, tpl, this.fmModel(event, channel, conletId, (Object)model))).setRenderAs(Conlet.RenderMode.Content));
            channel.respond((Event)new NotifyConletView(this.type(), conletId, "updateUser", new Object[]{WebConsoleUtils.userFromSession((Session)channel.session()).map(ConsoleUser::getDisplayName).orElse(null)}));
            renderedAs.add(Conlet.RenderMode.Content);
        }
        return renderedAs;
    }

    protected void doUpdateConletState(NotifyConletModel event, ConsoleConnection connection, AccountModel model) throws Exception {
        ResourceBundle bundle = this.resourceBundle(connection.locale());
        if ("loginData".equals(event.method())) {
            String userName = event.params().asString(0);
            if (userName == null || userName.isEmpty()) {
                connection.respond((Event)new NotifyConletView(this.type(), model.getConletId(), "setMessages", new Object[]{null, bundle.getString("emptyUserName")}));
                return;
            }
            model.setDialogOpen(false);
            Subject user = new Subject();
            user.getPrincipals().add((Principal)new ConsoleUser(userName, userName));
            connection.session().put(Subject.class, (Object)user);
            connection.respond((Event)new CloseModalDialog(this.type(), event.conletId()));
            connection.associated((Object)PENDING_CONSOLE_PREPARED, ConsolePrepared.class).ifPresentOrElse(Event::resumeHandling, () -> connection.respond((Event)new SimpleConsoleCommand("reload")));
            return;
        }
        if ("logout".equals(event.method())) {
            ((Close)connection.responsePipeline().fire((Event)new Close(), new Channel[]{connection.upstreamChannel()})).get();
            connection.close();
            connection.respond((Event)new DiscardSession(connection.session(), new Channel[]{connection.webletChannel()}));
        }
    }

    protected boolean doSetLocale(SetLocale event, ConsoleConnection channel, String conletId) throws Exception {
        return this.stateFromSession(channel.session(), this.type() + "~Singleton").map(model -> !model.isDialogOpen()).orElse(true);
    }

    public static class AccountModel
    extends ConletBaseModel {
        private boolean dialogOpen;

        @ConstructorProperties(value={"conletId"})
        public AccountModel(String conletId) {
            super(conletId);
        }

        public boolean isDialogOpen() {
            return this.dialogOpen;
        }

        public void setDialogOpen(boolean dialogOpen) {
            this.dialogOpen = dialogOpen;
        }
    }
}

