import { createApp, reactive, ref } from '../../page-resource/vue/vue.esm-browser.js';
import JGConsole from '../../console-base-resource/jgconsole.js';
import JgwcPlugin, { JGWC } from '../../page-resource/jgwc-vue-components/jgwc-components.js';
import { provideApi, getApi } from '../../page-resource/aash-vue-components/lib/aash-vue-components.js';
import l10nBundles from './Login-l10nBundles.ftl.js';

/*
 * JGrapes Event Driven Framework
 * Copyright (C) 2022 Michael N. Lipp
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program; if not, see <http://www.gnu.org/licenses/>.
 */
window.orgJGrapesExampleLogin = {};
window.orgJGrapesExampleLogin.openDialog
    = function (dialogDom, isUpdate) {
        if (isUpdate) {
            return;
        }
        let app = createApp({
            setup() {
                const formId = dialogDom
                    .closest("*[data-conlet-id]").id + "-form";
                const accountData = reactive({
                    username: "",
                    password: ""
                });
                const localize = (key) => {
                    return JGConsole.localize(l10nBundles, JGWC.lang(), key);
                };
                const info = ref(null);
                const warning = ref(null);
                JGConsole.registerConletFunction("org.jgrapes.webconlet.examples.login.LoginConlet", "setMessages", function (conletId, infoMsg, warnMsg) {
                    info.value = infoMsg;
                    warning.value = warnMsg;
                });
                const formDom = ref(null);
                provideApi(formDom, accountData);
                return { formDom, formId, localize, accountData, info, warning };
            },
            template: `
          <form :id="formId" ref="formDom" onsubmit="return false;">
            <fieldset>
              <legend>{{ localize("Login Data") }}</legend>
              <p>
                <label class="form__label--full-width">
                  <span>
                    {{ localize("User Name") }}
                    <strong>
                      <abbr v-bind:title='localize("required")'>*</abbr>
                    </strong>
                  </span>
                  <input type="text" name="username" v-model="accountData.username"
                    autocomplete="section-test username">
                </label>
              </p>
              <p>
                <label class="form__label--full-width">
                  <span>
                    {{ localize("Password") }}
                    <strong>
                      <abbr v-bind:title='localize("required")'>*</abbr>
                    </strong>
                  </span>
                  <input type="password" name="password" v-model="accountData.password"
                    autocomplete="section-test current-password">
                </label>
              </p>
              <p v-if="info" class="example-conlet-login-form__info">
                {{ info }}
              </p>
              <p v-if="warning" class="example-conlet-login-form__warning">
                {{ warning }}
              </p>
            </fieldset>
          </form>`
        });
        app.use(JgwcPlugin);
        app.mount(dialogDom);
    };
window.orgJGrapesExampleLogin.apply = function (dialogDom, apply, close) {
    if (!apply) {
        return;
    }
    const conletId = dialogDom.closest("[data-conlet-id]")
        .dataset["conletId"];
    const accountData = getApi(dialogDom.querySelector(":scope form"));
    JGConsole.notifyConletModel(conletId, "loginData", accountData.username, accountData.password);
    return;
};
window.orgJGrapesExampleLogin.initStatus
    = function (container, isUpdate) {
        if (isUpdate) {
            return;
        }
        const conletId = container.closest("*[data-conlet-id]")
            .dataset["conletId"];
        let app = createApp({
            setup() {
                const name = ref(null);
                JGConsole.registerConletFunction("org.jgrapes.webconlet.examples.login.LoginConlet", "updateUser", function (conletId, newName) {
                    name.value = newName;
                });
                const localize = (key) => JGConsole.localize(l10nBundles, JGWC.lang(), key);
                const action = (arg) => {
                    JGConsole.notifyConletModel(conletId, "logout");
                };
                return { localize, name, action };
            }
        });
        app.use(JgwcPlugin);
        app.mount(container);
    };
//# sourceMappingURL=Login-functions.js.map
