/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.ext.ComponentAttributeProvider;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.ExportException;
import org.jgrapht.ext.GraphMLExporter;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedPseudograph;

public final class GraphMLExportDemo {
    private static final int SIZE = 6;
    private static Random generator = new Random(17L);

    public static void main(String[] args) {
        DirectedPseudograph g = new DirectedPseudograph(DefaultWeightedEdge.class);
        CompleteGraphGenerator completeGenerator = new CompleteGraphGenerator(6);
        VertexFactory<GraphVertex> vFactory = new VertexFactory<GraphVertex>(){
            private int id = 0;

            public GraphVertex createVertex() {
                GraphVertex v = new GraphVertex(String.valueOf(this.id++));
                if (generator.nextBoolean()) {
                    v.setColor(Color.BLACK);
                } else {
                    v.setColor(Color.WHITE);
                }
                return v;
            }
        };
        completeGenerator.generateGraph((Graph)g, (VertexFactory)vFactory, null);
        for (DefaultWeightedEdge e : g.edgeSet()) {
            g.setEdgeWeight((Object)e, (double)generator.nextInt(100));
        }
        GraphMLExporter exporter = new GraphMLExporter((VertexNameProvider)new VertexNameProvider<GraphVertex>(){

            public String getVertexName(GraphVertex v) {
                return v.id;
            }
        }, null, (EdgeNameProvider)new IntegerEdgeNameProvider(), null);
        exporter.setExportEdgeWeights(true);
        exporter.registerAttribute("color", GraphMLExporter.AttributeCategory.NODE, GraphMLExporter.AttributeType.STRING);
        exporter.registerAttribute("name", GraphMLExporter.AttributeCategory.ALL, GraphMLExporter.AttributeType.STRING);
        ComponentAttributeProvider<GraphVertex> vertexAttributeProvider = new ComponentAttributeProvider<GraphVertex>(){

            public Map<String, String> getComponentAttributes(GraphVertex v) {
                HashMap<String, String> m = new HashMap<String, String>();
                if (v.getColor() != null) {
                    m.put("color", v.getColor().toString());
                }
                m.put("name", "node-" + v.id);
                return m;
            }
        };
        exporter.setVertexAttributeProvider((ComponentAttributeProvider)vertexAttributeProvider);
        ComponentAttributeProvider<DefaultWeightedEdge> edgeAttributeProvider = new ComponentAttributeProvider<DefaultWeightedEdge>(){

            public Map<String, String> getComponentAttributes(DefaultWeightedEdge e) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("name", e.toString());
                return m;
            }
        };
        exporter.setEdgeAttributeProvider((ComponentAttributeProvider)edgeAttributeProvider);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(System.out));
            exporter.exportGraph((Graph)g, (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (IOException | ExportException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(-1);
        }
    }

    static class GraphVertex {
        private String id;
        private Color color;

        public GraphVertex(String id) {
            this(id, null);
        }

        public GraphVertex(String id, Color color) {
            this.id = id;
            this.color = color;
        }

        public int hashCode() {
            return this.id == null ? 0 : this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GraphVertex other = (GraphVertex)obj;
            if (this.id == null) {
                return other.id == null;
            }
            return this.id.equals(other.id);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    static enum Color {
        BLACK("black"),
        WHITE("white");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

