/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public final class CompleteGraphDemo {
    static Graph<String, DefaultEdge> completeGraph;
    static int size;

    public static void main(String[] args) {
        completeGraph = new SimpleGraph(DefaultEdge.class);
        CompleteGraphGenerator completeGenerator = new CompleteGraphGenerator(size);
        VertexFactory<String> vFactory = new VertexFactory<String>(){
            private int id = 0;

            public String createVertex() {
                return "v" + this.id++;
            }
        };
        completeGenerator.generateGraph(completeGraph, (VertexFactory)vFactory, null);
        DepthFirstIterator iter = new DepthFirstIterator(completeGraph);
        while (iter.hasNext()) {
            String vertex = (String)iter.next();
            System.out.println("Vertex " + vertex + " is connected to: " + completeGraph.edgesOf((Object)vertex).toString());
        }
    }

    static {
        size = 10;
    }
}

