/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.ext.ComponentAttributeProvider;
import org.jgrapht.ext.ComponentNameProvider;
import org.jgrapht.ext.EdgeProvider;
import org.jgrapht.ext.ExportException;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.GraphImporter;
import org.jgrapht.ext.GraphMLExporter;
import org.jgrapht.ext.GraphMLImporter;
import org.jgrapht.ext.ImportException;
import org.jgrapht.ext.IntegerComponentNameProvider;
import org.jgrapht.ext.VertexProvider;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedWeightedPseudograph;

public final class GraphMLDemo {
    private static final int SIZE = 6;
    private static Random generator = new Random(17L);

    private static GraphExporter<CustomVertex, DefaultWeightedEdge> createExporter() {
        GraphMLExporter exporter = new GraphMLExporter((ComponentNameProvider)new ComponentNameProvider<CustomVertex>(){

            public String getName(CustomVertex v) {
                return v.id;
            }
        }, null, (ComponentNameProvider)new IntegerComponentNameProvider(), null);
        exporter.setExportEdgeWeights(true);
        exporter.registerAttribute("color", GraphMLExporter.AttributeCategory.NODE, GraphMLExporter.AttributeType.STRING);
        exporter.registerAttribute("name", GraphMLExporter.AttributeCategory.ALL, GraphMLExporter.AttributeType.STRING);
        ComponentAttributeProvider<CustomVertex> vertexAttributeProvider = new ComponentAttributeProvider<CustomVertex>(){

            public Map<String, String> getComponentAttributes(CustomVertex v) {
                HashMap<String, String> m = new HashMap<String, String>();
                if (v.getColor() != null) {
                    m.put("color", v.getColor().toString());
                }
                m.put("name", "node-" + v.id);
                return m;
            }
        };
        exporter.setVertexAttributeProvider((ComponentAttributeProvider)vertexAttributeProvider);
        ComponentAttributeProvider<DefaultWeightedEdge> edgeAttributeProvider = new ComponentAttributeProvider<DefaultWeightedEdge>(){

            public Map<String, String> getComponentAttributes(DefaultWeightedEdge e) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("name", e.toString());
                return m;
            }
        };
        exporter.setEdgeAttributeProvider((ComponentAttributeProvider)edgeAttributeProvider);
        return exporter;
    }

    private static GraphImporter<CustomVertex, DefaultWeightedEdge> createImporter() {
        VertexProvider<CustomVertex> vertexProvider = new VertexProvider<CustomVertex>(){

            public CustomVertex buildVertex(String id, Map<String, String> attributes) {
                CustomVertex cv = new CustomVertex(id);
                String color = attributes.get("color");
                if (color != null) {
                    switch (color) {
                        case "black": {
                            cv.setColor(Color.BLACK);
                            break;
                        }
                        case "white": {
                            cv.setColor(Color.WHITE);
                            break;
                        }
                    }
                }
                return cv;
            }
        };
        EdgeProvider<CustomVertex, DefaultWeightedEdge> edgeProvider = new EdgeProvider<CustomVertex, DefaultWeightedEdge>(){

            public DefaultWeightedEdge buildEdge(CustomVertex from, CustomVertex to, String label, Map<String, String> attributes) {
                return new DefaultWeightedEdge();
            }
        };
        GraphMLImporter importer = new GraphMLImporter((VertexProvider)vertexProvider, (EdgeProvider)edgeProvider);
        return importer;
    }

    public static void main(String[] args) {
        DirectedWeightedPseudograph graph1 = new DirectedWeightedPseudograph(DefaultWeightedEdge.class);
        CompleteGraphGenerator completeGenerator = new CompleteGraphGenerator(6);
        VertexFactory<CustomVertex> vFactory = new VertexFactory<CustomVertex>(){
            private int id = 0;

            public CustomVertex createVertex() {
                CustomVertex v = new CustomVertex(String.valueOf(this.id++));
                if (generator.nextBoolean()) {
                    v.setColor(Color.BLACK);
                } else {
                    v.setColor(Color.WHITE);
                }
                return v;
            }
        };
        System.out.println("-- Generating complete graph");
        completeGenerator.generateGraph((Graph)graph1, (VertexFactory)vFactory, null);
        for (DefaultWeightedEdge e : graph1.edgeSet()) {
            graph1.setEdgeWeight((Object)e, (double)generator.nextInt(100));
        }
        try {
            System.out.println("-- Exporting graph as GraphML");
            GraphExporter<CustomVertex, DefaultWeightedEdge> exporter = GraphMLDemo.createExporter();
            StringWriter writer = new StringWriter();
            exporter.exportGraph((Graph)graph1, (Writer)writer);
            String graph1AsGraphML = ((Object)writer).toString();
            System.out.println(graph1AsGraphML);
            System.out.println("-- Importing graph back from GraphML");
            DirectedWeightedPseudograph graph2 = new DirectedWeightedPseudograph(DefaultWeightedEdge.class);
            GraphImporter<CustomVertex, DefaultWeightedEdge> importer = GraphMLDemo.createImporter();
            importer.importGraph((Graph)graph2, (Reader)new StringReader(graph1AsGraphML));
        }
        catch (ExportException | ImportException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(-1);
        }
    }

    static class CustomVertex {
        private String id;
        private Color color;

        public CustomVertex(String id) {
            this(id, null);
        }

        public CustomVertex(String id, Color color) {
            this.id = id;
            this.color = color;
        }

        public int hashCode() {
            return this.id == null ? 0 : this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomVertex other = (CustomVertex)obj;
            if (this.id == null) {
                return other.id == null;
            }
            return this.id.equals(other.id);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.id);
            if (this.color != null) {
                sb.append(",").append((Object)this.color);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    static enum Color {
        BLACK("black"),
        WHITE("white");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

