/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.ArrayList;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.ClassBasedEdgeFactory;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;

public class LabeledEdges {
    private static final String FRIEND = "friend";
    private static final String ENEMY = "enemy";

    public static void main(String[] args) {
        DirectedMultigraph graph = new DirectedMultigraph((EdgeFactory)new ClassBasedEdgeFactory(RelationshipEdge.class));
        ArrayList<String> people = new ArrayList<String>();
        people.add("John");
        people.add("James");
        people.add("Sarah");
        people.add("Jessica");
        for (String person : people) {
            graph.addVertex((Object)person);
            if (person.equals(people.get(0))) continue;
            graph.addEdge(people.get(0), (Object)person, new RelationshipEdge<String>((String)people.get(0), person, FRIEND));
        }
        graph.addEdge((Object)"James", (Object)"John", new RelationshipEdge<String>("James", "John", ENEMY));
        graph.addEdge((Object)"Jessica", (Object)"Sarah", new RelationshipEdge<String>("Jessica", "Sarah", FRIEND));
        graph.addEdge((Object)"Jessica", (Object)"James", new RelationshipEdge<String>("Jessica", "James", FRIEND));
        graph.addEdge((Object)"Sarah", (Object)"James", new RelationshipEdge<String>("Sarah", "James", ENEMY));
        for (RelationshipEdge edge : graph.edgeSet()) {
            if (edge.toString().equals(ENEMY)) {
                System.out.printf(edge.getV1() + "is an enemy of " + edge.getV2() + "\n", new Object[0]);
                continue;
            }
            if (!edge.toString().equals(FRIEND)) continue;
            System.out.printf(edge.getV1() + " is a friend of " + edge.getV2() + "\n", new Object[0]);
        }
    }

    public static class RelationshipEdge<V>
    extends DefaultEdge {
        private V v1;
        private V v2;
        private String label;

        public RelationshipEdge(V v1, V v2, String label) {
            this.v1 = v1;
            this.v2 = v2;
            this.label = label;
        }

        public V getV1() {
            return this.v1;
        }

        public V getV2() {
            return this.v2;
        }

        public String toString() {
            return this.label;
        }
    }
}

