/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.Iterator;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class DependencyDemo {
    public static void test(boolean createCycles) {
        DefaultDirectedGraph g = new DefaultDirectedGraph(DefaultEdge.class);
        g.addVertex((Object)"a");
        g.addVertex((Object)"b");
        g.addVertex((Object)"c");
        g.addVertex((Object)"d");
        g.addVertex((Object)"e");
        g.addEdge((Object)"b", (Object)"a");
        g.addEdge((Object)"c", (Object)"b");
        if (createCycles) {
            g.addEdge((Object)"a", (Object)"c");
        }
        g.addEdge((Object)"e", (Object)"d");
        if (createCycles) {
            g.addEdge((Object)"d", (Object)"e");
        }
        System.out.println(g.toString());
        CycleDetector cycleDetector = new CycleDetector((Graph)g);
        if (cycleDetector.detectCycles()) {
            System.out.println("Cycles detected.");
            Set cycleVertices = cycleDetector.findCycles();
            while (!cycleVertices.isEmpty()) {
                System.out.println("Cycle:");
                Iterator iterator = cycleVertices.iterator();
                String cycle = (String)iterator.next();
                Set subCycle = cycleDetector.findCyclesContainingVertex((Object)cycle);
                for (String sub : subCycle) {
                    System.out.println("   " + sub);
                    cycleVertices.remove(sub);
                }
            }
        } else {
            TopologicalOrderIterator orderIterator = new TopologicalOrderIterator((Graph)g);
            System.out.println("\nTopological Ordering:");
            while (orderIterator.hasNext()) {
                String v = (String)orderIterator.next();
                System.out.println(v);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("\nCase 1: There are cycles.");
        DependencyDemo.test(true);
        System.out.println("\nCase 2: There are no cycles.");
        DependencyDemo.test(false);
        System.out.println("\nAll done");
        System.exit(0);
    }
}

