/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedWeightedPseudograph;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.AttributeType;
import org.jgrapht.io.ComponentAttributeProvider;
import org.jgrapht.io.ComponentNameProvider;
import org.jgrapht.io.DefaultAttribute;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.ExportException;
import org.jgrapht.io.GraphExporter;
import org.jgrapht.io.GraphImporter;
import org.jgrapht.io.GraphMLExporter;
import org.jgrapht.io.GraphMLImporter;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.IntegerComponentNameProvider;
import org.jgrapht.io.VertexProvider;
import org.jgrapht.util.SupplierUtil;

public final class GraphMLDemo {
    private static final int SIZE = 6;
    private static final Random GENERATOR = new Random(17L);

    private static GraphExporter<CustomVertex, DefaultWeightedEdge> createExporter() {
        ComponentNameProvider vertexIdProvider = v -> ((CustomVertex)v).id;
        ComponentNameProvider vertexLabelProvider = null;
        ComponentAttributeProvider vertexAttributeProvider = v -> {
            HashMap<String, Attribute> m = new HashMap<String, Attribute>();
            if (v.getColor() != null) {
                m.put("color", DefaultAttribute.createAttribute((String)v.getColor().toString()));
            }
            m.put("name", DefaultAttribute.createAttribute((String)("node-" + ((CustomVertex)v).id)));
            return m;
        };
        IntegerComponentNameProvider edgeIdProvider = new IntegerComponentNameProvider();
        ComponentNameProvider edgeLabelProvider = null;
        ComponentAttributeProvider edgeAttributeProvider = e -> {
            HashMap<String, Attribute> m = new HashMap<String, Attribute>();
            m.put("name", DefaultAttribute.createAttribute((String)e.toString()));
            return m;
        };
        GraphMLExporter exporter = new GraphMLExporter(vertexIdProvider, vertexLabelProvider, vertexAttributeProvider, (ComponentNameProvider)edgeIdProvider, edgeLabelProvider, edgeAttributeProvider);
        exporter.setExportEdgeWeights(true);
        exporter.registerAttribute("color", GraphMLExporter.AttributeCategory.NODE, AttributeType.STRING);
        exporter.registerAttribute("name", GraphMLExporter.AttributeCategory.ALL, AttributeType.STRING);
        return exporter;
    }

    private static GraphImporter<CustomVertex, DefaultWeightedEdge> createImporter() {
        VertexProvider vertexProvider = (id, attributes) -> {
            CustomVertex cv = new CustomVertex(id);
            if (attributes.containsKey("color")) {
                String color;
                switch (color = ((Attribute)attributes.get("color")).getValue()) {
                    case "black": {
                        cv.setColor(Color.BLACK);
                        break;
                    }
                    case "white": {
                        cv.setColor(Color.WHITE);
                        break;
                    }
                }
            }
            return cv;
        };
        EdgeProvider edgeProvider = (from, to, label, attributes) -> new DefaultWeightedEdge();
        GraphMLImporter importer = new GraphMLImporter(vertexProvider, edgeProvider);
        return importer;
    }

    public static void main(String[] args) {
        Supplier<CustomVertex> vSupplier = new Supplier<CustomVertex>(){
            private int id = 0;

            @Override
            public CustomVertex get() {
                return new CustomVertex(String.valueOf(this.id++), GENERATOR.nextBoolean() ? Color.BLACK : Color.WHITE);
            }
        };
        DirectedWeightedPseudograph graph1 = new DirectedWeightedPseudograph((Supplier)vSupplier, SupplierUtil.createDefaultWeightedEdgeSupplier());
        CompleteGraphGenerator completeGenerator = new CompleteGraphGenerator(6);
        System.out.println("-- Generating complete graph");
        completeGenerator.generateGraph((Graph)graph1);
        for (DefaultWeightedEdge e : graph1.edgeSet()) {
            graph1.setEdgeWeight((Object)e, (double)GENERATOR.nextInt(100));
        }
        try {
            System.out.println("-- Exporting graph as GraphML");
            GraphExporter<CustomVertex, DefaultWeightedEdge> exporter = GraphMLDemo.createExporter();
            StringWriter writer = new StringWriter();
            exporter.exportGraph((Graph)graph1, (Writer)writer);
            String graph1AsGraphML = ((Object)writer).toString();
            System.out.println(graph1AsGraphML);
            System.out.println("-- Importing graph back from GraphML");
            DirectedWeightedPseudograph graph2 = new DirectedWeightedPseudograph(DefaultWeightedEdge.class);
            GraphImporter<CustomVertex, DefaultWeightedEdge> importer = GraphMLDemo.createImporter();
            importer.importGraph((Graph)graph2, (Reader)new StringReader(graph1AsGraphML));
        }
        catch (ExportException | ImportException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(-1);
        }
    }

    static class CustomVertex {
        private String id;
        private Color color;

        public CustomVertex(String id) {
            this(id, null);
        }

        public CustomVertex(String id, Color color) {
            this.id = id;
            this.color = color;
        }

        public int hashCode() {
            return this.id == null ? 0 : this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomVertex other = (CustomVertex)obj;
            if (this.id == null) {
                return other.id == null;
            }
            return this.id.equals(other.id);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append(this.id);
            if (this.color != null) {
                sb.append(",").append((Object)this.color);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    static enum Color {
        BLACK("black"),
        WHITE("white");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

