/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.alg.util.Pair;

class KnightTour {
    private final DoublyLinkedList<Pair<Integer, Integer>> list;
    private final ArrayList<Node<Pair<Integer, Integer>>> structured = new ArrayList(Collections.nCopies(8, new Node()));
    private List<Pair<Integer, Integer>> arrayList = null;

    public KnightTour() {
        this.list = new DoublyLinkedList();
    }

    public List<Pair<Integer, Integer>> toList() {
        if (this.arrayList != null) {
            return this.arrayList;
        }
        Node<Pair<Integer, Integer>> startNode = this.list.getStartNode();
        startNode.setVisited(true);
        this.arrayList = new ArrayList<Pair<Integer, Integer>>();
        this.arrayList.add(startNode.getValue());
        while (startNode.getNext().isVisited() || startNode.getPrev().isVisited()) {
            startNode = startNode.getNext().isVisited() ? startNode.getNext() : startNode.getPrev();
            this.arrayList.add(startNode.getValue());
            startNode.setVisited(true);
        }
        return this.arrayList;
    }

    public DoublyLinkedList<Pair<Integer, Integer>> getList() {
        return this.list;
    }

    public ArrayList<Node<Pair<Integer, Integer>>> getStructured() {
        return this.structured;
    }

    static class Node<E> {
        private Node<E> next;
        private Node<E> prev;
        private E value;
        private boolean visited = false;

        public Node(E value) {
            this.value = value;
        }

        public Node() {
        }

        public boolean isVisited() {
            return !this.visited;
        }

        public void setVisited(boolean visited) {
            this.visited = visited;
        }

        public E getValue() {
            return this.value;
        }

        public Node<E> getNext() {
            return this.next;
        }

        public Node<E> getPrev() {
            return this.prev;
        }

        public void setPrev(Node<E> prev) {
            this.prev = prev;
        }

        public void setNext(Node<E> next) {
            this.next = next;
        }
    }

    class DoublyLinkedList<E> {
        private Node<E> head = null;
        private Node<E> tail = null;
        private Node<E> startNode = null;
        private int size = 0;

        public int getSize() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public void add(E element) {
            Node<E> node = new Node<E>(element);
            ++this.size;
            if (this.isEmpty()) {
                ((Node)node).next = null;
                ((Node)node).prev = null;
                this.head = node;
                this.tail = node;
                return;
            }
            ((Node)this.tail).next = (Node)node;
            ((Node)node).prev = (Node)this.tail;
            ((Node)node).next = null;
            this.tail = node;
        }

        public void remove() {
            if (this.isEmpty()) {
                throw new IndexOutOfBoundsException("The list is empty!");
            }
            --this.size;
            if (((Node)this.tail).prev == null) {
                this.head = null;
                this.tail = null;
                return;
            }
            this.tail = ((Node)this.tail).prev;
            ((Node)this.tail).next = null;
        }

        public Node<E> getHead() {
            return this.head;
        }

        public Node<E> getTail() {
            return this.tail;
        }

        public void clear() {
            this.head = null;
            this.tail = null;
            this.size = 0;
        }

        public void setStartNode(Node<E> startNode) {
            this.startNode = startNode;
        }

        public Node<E> getStartNode() {
            return this.startNode;
        }

        public void setSize(int i) {
            this.size = i;
        }
    }
}

