/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.ArrayList;
import org.jgrapht.Graph;
import org.jgrapht.demo.RelationshipEdge;
import org.jgrapht.graph.DefaultDirectedGraph;

public class LabeledEdges {
    private static final String FRIEND = "friend";
    private static final String ENEMY = "enemy";

    public static void main(String[] args) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(RelationshipEdge.class);
        ArrayList<String> people = new ArrayList<String>();
        people.add("John");
        people.add("James");
        people.add("Sarah");
        people.add("Jessica");
        for (String person : people) {
            graph.addVertex((Object)person);
            if (person.equals("John")) continue;
            graph.addEdge((Object)"John", (Object)person, (Object)new RelationshipEdge(FRIEND));
        }
        graph.addEdge((Object)"James", (Object)"John", (Object)new RelationshipEdge(ENEMY));
        graph.addEdge((Object)"Jessica", (Object)"Sarah", (Object)new RelationshipEdge(FRIEND));
        graph.addEdge((Object)"Jessica", (Object)"James", (Object)new RelationshipEdge(FRIEND));
        graph.addEdge((Object)"Sarah", (Object)"James", (Object)new RelationshipEdge(ENEMY));
        for (RelationshipEdge edge : graph.edgeSet()) {
            String v1 = (String)graph.getEdgeSource((Object)edge);
            String v2 = (String)graph.getEdgeTarget((Object)edge);
            if (edge.getLabel().equals(ENEMY)) {
                System.out.printf(v1 + " is an enemy of " + v2 + "\n", new Object[0]);
                continue;
            }
            if (!edge.getLabel().equals(FRIEND)) continue;
            System.out.printf(v1 + " is a friend of " + v2 + "\n", new Object[0]);
        }
        assert (LabeledEdges.isEnemyOf((Graph<String, RelationshipEdge>)graph, "James", "John"));
    }

    private static boolean isEnemyOf(Graph<String, RelationshipEdge> graph, String person1, String person2) {
        return ((RelationshipEdge)((Object)graph.getEdge((Object)person1, (Object)person2))).getLabel().equals(ENEMY);
    }
}

