/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.demo.KnightTour;
import org.jgrapht.demo.TourType;

public class WarnsdorffRuleKnightTourHeuristic {
    private int n;
    private int m;
    private boolean[][] chessBoard;
    private static final int[] DX = new int[]{1, 2, 2, 1, -1, -2, -2, -1};
    private static final int[] DY = new int[]{2, 1, -1, -2, -2, -1, 1, 2};

    public WarnsdorffRuleKnightTourHeuristic(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Incorrect board size!");
        }
        this.n = n;
        this.m = n;
        this.chessBoard = new boolean[n][n];
    }

    public WarnsdorffRuleKnightTourHeuristic(int n, int m) {
        if (n < 3 && m < 3 || n <= 1 || m <= 1) {
            throw new IllegalArgumentException("Incorrect board size!");
        }
        this.n = n;
        this.m = m;
        this.chessBoard = new boolean[n][m];
    }

    private int getNumberOfUnusedNeighbours(Pair<Integer, Integer> currentCell) {
        int ans = 0;
        for (int i = 0; i < 8; ++i) {
            int newX = (Integer)currentCell.getFirst() + DX[i];
            int newY = (Integer)currentCell.getSecond() + DY[i];
            if (newX < 0 || newX >= this.n || newY < 0 || newY >= this.m || this.chessBoard[newX][newY]) continue;
            ++ans;
        }
        return ans;
    }

    private int handleTie(ArrayList<Pair<Integer, Integer>> array) {
        int index = -1;
        int distance = -1;
        int xCenter = this.n / 2;
        int yCenter = this.m / 2;
        for (int i = 0; i < array.size(); ++i) {
            int y;
            int x = (Integer)array.get(i).getFirst();
            if ((x - xCenter) * (x - xCenter) + ((y = ((Integer)array.get(i).getSecond()).intValue()) - yCenter) * (y - yCenter) <= distance) continue;
            distance = (x - xCenter) * (x - xCenter) + (y - yCenter) * (y - yCenter);
            index = i;
        }
        return index;
    }

    private Pair<Integer, Integer> getMoveWarnsdorff(Pair<Integer, Integer> cell) {
        int curValue = Integer.MAX_VALUE;
        Pair currentCell = new Pair((Object)-1, (Object)-1);
        Pair nextCell = new Pair((Object)-1, (Object)-1);
        ArrayList<Pair<Integer, Integer>> tie = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < 8; ++i) {
            int newX = (Integer)cell.getFirst() + DX[i];
            int newY = (Integer)cell.getSecond() + DY[i];
            currentCell.setFirst((Object)newX);
            currentCell.setSecond((Object)newY);
            if (newX < 0 || newX >= this.n || newY < 0 || newY >= this.m || this.chessBoard[newX][newY]) continue;
            int adjValue = this.getNumberOfUnusedNeighbours((Pair<Integer, Integer>)currentCell);
            if (adjValue < curValue) {
                curValue = adjValue;
                nextCell.setFirst((Object)((Integer)currentCell.getFirst()));
                nextCell.setSecond((Object)((Integer)currentCell.getSecond()));
                tie.clear();
                tie.add((Pair<Integer, Integer>)new Pair((Object)((Integer)currentCell.getFirst()), (Object)((Integer)currentCell.getSecond())));
                continue;
            }
            if (adjValue != curValue) continue;
            tie.add((Pair<Integer, Integer>)new Pair((Object)newX, (Object)newY));
        }
        if (tie.size() > 1) {
            int index = this.handleTie(tie);
            nextCell.setFirst((Object)((Integer)tie.get(index).getFirst()));
            nextCell.setSecond((Object)((Integer)tie.get(index).getSecond()));
        }
        return nextCell;
    }

    private boolean checkType(int startX, int startY, int endX, int endY, TourType type) {
        if (type == TourType.CLOSED) {
            return Math.abs(startX - endX) == 1 && Math.abs(startY - endY) == 2 || Math.abs(startX - endX) == 2 && Math.abs(startY - endY) == 1;
        }
        return !(Math.abs(startX - endX) == 1 && Math.abs(startY - endY) == 2 || Math.abs(startX - endX) == 2 && Math.abs(startY - endY) == 1);
    }

    private boolean checkStructured(HashSet<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> moves, boolean structured) {
        return !structured || (moves.contains(new Pair((Object)new Pair((Object)1, (Object)0), (Object)new Pair((Object)0, (Object)2))) || moves.contains(new Pair((Object)new Pair((Object)0, (Object)2), (Object)new Pair((Object)1, (Object)0)))) && moves.contains(new Pair((Object)new Pair((Object)2, (Object)0), (Object)new Pair((Object)0, (Object)1))) || moves.contains(new Pair((Object)new Pair((Object)0, (Object)1), (Object)new Pair((Object)2, (Object)0))) && moves.contains(new Pair((Object)new Pair((Object)(this.n - 3), (Object)0), (Object)new Pair((Object)(this.n - 1), (Object)1))) || moves.contains(new Pair((Object)new Pair((Object)(this.n - 1), (Object)1), (Object)new Pair((Object)(this.n - 3), (Object)0))) && moves.contains(new Pair((Object)new Pair((Object)(this.n - 2), (Object)0), (Object)new Pair((Object)(this.n - 1), (Object)2))) || moves.contains(new Pair((Object)new Pair((Object)(this.n - 1), (Object)2), (Object)new Pair((Object)(this.n - 2), (Object)0))) && moves.contains(new Pair((Object)new Pair((Object)0, (Object)(this.m - 3)), (Object)new Pair((Object)1, (Object)(this.m - 1)))) || moves.contains(new Pair((Object)new Pair((Object)1, (Object)(this.m - 1)), (Object)new Pair((Object)0, (Object)(this.m - 3)))) && moves.contains(new Pair((Object)new Pair((Object)0, (Object)(this.m - 2)), (Object)new Pair((Object)2, (Object)(this.m - 1)))) || moves.contains(new Pair((Object)new Pair((Object)2, (Object)(this.m - 1)), (Object)new Pair((Object)0, (Object)(this.m - 2)))) && moves.contains(new Pair((Object)new Pair((Object)(this.n - 3), (Object)(this.m - 1)), (Object)new Pair((Object)(this.n - 1), (Object)(this.m - 2)))) || moves.contains(new Pair((Object)new Pair((Object)(this.n - 1), (Object)(this.m - 2)), (Object)new Pair((Object)(this.n - 3), (Object)(this.m - 1)))) && moves.contains(new Pair((Object)new Pair((Object)(this.n - 2), (Object)(this.m - 1)), (Object)new Pair((Object)(this.n - 1), (Object)(this.m - 3)))) || moves.contains(new Pair((Object)new Pair((Object)(this.n - 1), (Object)(this.m - 3)), (Object)new Pair((Object)(this.n - 2), (Object)(this.m - 2))));
    }

    private HashSet<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> getMoves(KnightTour.DoublyLinkedList<Pair<Integer, Integer>> tour) {
        HashSet<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> moves = new HashSet<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>>();
        KnightTour.Node<Pair<Integer, Integer>> headNode = tour.getHead();
        for (KnightTour.Node<Pair<Integer, Integer>> nextNode = headNode.getNext(); nextNode != null; nextNode = nextNode.getNext()) {
            moves.add((Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>)new Pair(headNode.getValue(), nextNode.getValue()));
            headNode = headNode.getNext();
        }
        return moves;
    }

    private boolean checkExistence(TourType type) {
        int newN = Math.min(this.n, this.m);
        int newM = Math.max(this.n, this.m);
        if (type == TourType.CLOSED) {
            return (newN % 2 != 1 || newM % 2 != 1) && newN != 1 && newN != 2 && newN != 4 && (newN != 3 || newM != 4 && newM != 6 && newM != 8);
        }
        return newN == 3 && newM == 4 || newN == 3 && newM >= 7 || newN >= 4 && newM >= 5;
    }

    private int updateStructuredPosition(Pair<Integer, Integer> cell) {
        if ((Integer)cell.getFirst() == 2 && (Integer)cell.getSecond() == 0) {
            return 0;
        }
        if ((Integer)cell.getFirst() == 0 && (Integer)cell.getSecond() == 1) {
            return 1;
        }
        if ((Integer)cell.getFirst() == this.n - 1 && (Integer)cell.getSecond() == 0) {
            return 2;
        }
        if ((Integer)cell.getFirst() == this.n - 2 && (Integer)cell.getSecond() == 2) {
            return 3;
        }
        if ((Integer)cell.getFirst() == 1 && (Integer)cell.getSecond() == this.m - 3) {
            return 4;
        }
        if ((Integer)cell.getFirst() == 0 && (Integer)cell.getSecond() == this.m - 1) {
            return 5;
        }
        if ((Integer)cell.getFirst() == this.n - 1 && (Integer)cell.getSecond() == this.m - 2) {
            return 6;
        }
        if ((Integer)cell.getFirst() == this.n - 3 && (Integer)cell.getSecond() == this.m - 1) {
            return 7;
        }
        return -1;
    }

    public KnightTour getTour(TourType type, boolean structured, int shiftX, int shiftY) {
        if (shiftX < 0 || shiftY < 0) {
            throw new IllegalArgumentException("Incorrect shift value!");
        }
        if (!this.checkExistence(type)) {
            throw new IllegalArgumentException("No solution exist for such configuration!");
        }
        KnightTour tour = new KnightTour();
        Random rand = new Random();
        Pair<Integer, Integer> currentCell = new Pair<Integer, Integer>((Object)-1, (Object)-1);
        int run = 0;
        boolean[][] wasStartingVertex = new boolean[this.n][this.m];
        boolean found = false;
        while (!found) {
            HashSet<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> moves;
            int visited = 0;
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.m; ++j) {
                    this.chessBoard[i][j] = false;
                }
            }
            tour.getList().clear();
            int startX = rand.nextInt(this.n);
            int startY = rand.nextInt(this.m);
            currentCell.setFirst((Object)startX);
            currentCell.setSecond((Object)startY);
            while (wasStartingVertex[startX][startY]) {
                startX = rand.nextInt(this.n);
                startY = rand.nextInt(this.m);
                currentCell.setFirst((Object)startX);
                currentCell.setSecond((Object)startY);
            }
            wasStartingVertex[startX][startY] = true;
            ++run;
            while (visited < this.n * this.m) {
                int val;
                this.chessBoard[((Integer)currentCell.getFirst()).intValue()][((Integer)currentCell.getSecond()).intValue()] = true;
                tour.getList().add(currentCell);
                if (structured && (val = this.updateStructuredPosition(currentCell)) != -1) {
                    tour.getStructured().set(val, tour.getList().getTail());
                }
                ++visited;
                if ((Integer)(currentCell = this.getMoveWarnsdorff(currentCell)).getFirst() != -1) continue;
            }
            Pair<Integer, Integer> endCell = tour.getList().getTail().getValue();
            if (visited == this.n * this.m && this.checkType(startX, startY, (Integer)endCell.getFirst(), (Integer)endCell.getSecond(), type) && this.checkStructured(moves = this.getMoves(tour.getList()), structured)) {
                found = true;
            }
            if (run != this.n * this.m || found) continue;
            return null;
        }
        for (KnightTour.Node<Pair<Integer, Integer>> node = tour.getList().getHead(); node != null; node = node.getNext()) {
            node.getValue().setFirst((Object)((Integer)node.getValue().getFirst() + shiftX));
            node.getValue().setSecond((Object)((Integer)node.getValue().getSecond() + shiftY));
        }
        tour.getList().getHead().setPrev(tour.getList().getTail());
        tour.getList().getTail().setNext(tour.getList().getHead());
        tour.getList().setStartNode(tour.getList().getHead());
        return tour;
    }
}

