/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import org.jgrapht.alg.util.Pair;
import org.jgrapht.demo.KnightTour;
import org.jgrapht.demo.TourType;
import org.jgrapht.demo.WarnsdorffRuleKnightTourHeuristic;

public class ParberryKnightTour {
    private int n;
    private int m;

    public ParberryKnightTour(int n, int m) {
        if (n < 6 || n % 2 != 0) {
            throw new IllegalArgumentException("n has to be greater than 5 and even!");
        }
        if (m != n + 2 && m != n) {
            throw new IllegalArgumentException("n x n and n x (n + 2) are the only possible board configurations!");
        }
        this.n = n;
        this.m = m;
    }

    private KnightTour generateTour(Pair<Integer, Integer> start, Pair<Integer, Integer> end) {
        Pair end1;
        Pair start1;
        int mDim;
        int nDim = (Integer)end.getFirst() - (Integer)start.getFirst() + 1;
        if (Math.max(nDim, mDim = (Integer)end.getSecond() - (Integer)start.getSecond() + 1) <= 12) {
            return new WarnsdorffRuleKnightTourHeuristic(nDim, mDim).getTour(TourType.CLOSED, true, (Integer)start.getFirst(), (Integer)start.getSecond());
        }
        int k = nDim / 4;
        int rem = nDim % 4;
        if (nDim + 2 == mDim && rem == 2) {
            start1 = new Pair((Object)((Integer)start.getFirst()), (Object)((Integer)start.getSecond()));
            end1 = new Pair((Object)((Integer)start.getFirst() + 2 * k - 1), (Object)((Integer)start.getSecond() + mDim / 2 - 1));
        } else {
            start1 = new Pair((Object)((Integer)start.getFirst()), (Object)((Integer)start.getSecond()));
            end1 = new Pair((Object)((Integer)start.getFirst() + 2 * k - 1), (Object)((Integer)start.getSecond() + 2 * k - 1));
        }
        Pair start2 = new Pair((Object)((Integer)end1.getFirst() + 1), (Object)((Integer)start1.getSecond()));
        Pair end2 = new Pair((Object)((Integer)end.getFirst()), (Object)((Integer)end1.getSecond()));
        Pair start3 = new Pair((Object)((Integer)start.getFirst()), (Object)((Integer)end1.getSecond() + 1));
        Pair end3 = new Pair((Object)((Integer)end1.getFirst()), (Object)((Integer)end.getSecond()));
        Pair start4 = new Pair((Object)((Integer)end1.getFirst() + 1), (Object)((Integer)end1.getSecond() + 1));
        Pair end4 = new Pair((Object)((Integer)end.getFirst()), (Object)((Integer)end.getSecond()));
        KnightTour tour1 = this.generateTour((Pair<Integer, Integer>)start1, (Pair<Integer, Integer>)end1);
        KnightTour tour2 = this.generateTour((Pair<Integer, Integer>)start2, (Pair<Integer, Integer>)end2);
        KnightTour tour3 = this.generateTour((Pair<Integer, Integer>)start3, (Pair<Integer, Integer>)end3);
        KnightTour tour4 = this.generateTour((Pair<Integer, Integer>)start4, (Pair<Integer, Integer>)end4);
        if (tour1.getStructured().get(7).getNext() == tour1.getStructured().get(6)) {
            tour1.getStructured().get(7).setNext(tour3.getStructured().get(2));
            tour1.getStructured().get(6).setPrev(tour2.getStructured().get(4));
        } else {
            tour1.getStructured().get(7).setPrev(tour3.getStructured().get(2));
            tour1.getStructured().get(6).setNext(tour2.getStructured().get(4));
        }
        if (tour3.getStructured().get(2).getPrev() == tour3.getStructured().get(3)) {
            tour3.getStructured().get(2).setPrev(tour1.getStructured().get(7));
            tour3.getStructured().get(3).setNext(tour4.getStructured().get(1));
        } else {
            tour3.getStructured().get(2).setNext(tour1.getStructured().get(7));
            tour3.getStructured().get(3).setPrev(tour4.getStructured().get(1));
        }
        if (tour4.getStructured().get(1).getPrev() == tour4.getStructured().get(0)) {
            tour4.getStructured().get(1).setPrev(tour3.getStructured().get(3));
            tour4.getStructured().get(0).setNext(tour2.getStructured().get(5));
        } else {
            tour4.getStructured().get(1).setNext(tour3.getStructured().get(3));
            tour4.getStructured().get(0).setPrev(tour2.getStructured().get(5));
        }
        if (tour2.getStructured().get(5).getPrev() == tour2.getStructured().get(4)) {
            tour2.getStructured().get(5).setPrev(tour4.getStructured().get(0));
            tour2.getStructured().get(4).setNext(tour1.getStructured().get(6));
        } else {
            tour2.getStructured().get(5).setNext(tour4.getStructured().get(0));
            tour2.getStructured().get(4).setPrev(tour1.getStructured().get(6));
        }
        tour1.getList().setStartNode(tour3.getStructured().get(2));
        tour1.getStructured().set(2, tour2.getStructured().get(2));
        tour1.getStructured().set(3, tour2.getStructured().get(3));
        tour1.getStructured().set(4, tour3.getStructured().get(4));
        tour1.getStructured().set(5, tour3.getStructured().get(5));
        tour1.getStructured().set(6, tour4.getStructured().get(6));
        tour1.getStructured().set(7, tour4.getStructured().get(7));
        tour1.getList().setSize(tour1.getList().getSize() + tour2.getList().getSize() + tour3.getList().getSize() + tour4.getList().getSize());
        return tour1;
    }

    public KnightTour getTour() {
        return this.generateTour((Pair<Integer, Integer>)new Pair((Object)0, (Object)0), (Pair<Integer, Integer>)new Pair((Object)(this.n - 1), (Object)(this.m - 1)));
    }
}

