/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import com.mxgraph.model.mxICell;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.HashMap;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;

public class JGraphXAdapter<V, E>
extends mxGraph
implements GraphListener<V, E> {
    private Graph<V, E> graphT;
    private HashMap<V, mxICell> vertexToCellMap = new HashMap();
    private HashMap<E, mxICell> edgeToCellMap = new HashMap();
    private HashMap<mxICell, V> cellToVertexMap = new HashMap();
    private HashMap<mxICell, E> cellToEdgeMap = new HashMap();

    public JGraphXAdapter(ListenableGraph<V, E> graph) {
        this((Graph<V, E>)graph);
        graph.addGraphListener(this);
    }

    public JGraphXAdapter(Graph<V, E> graph) {
        if (graph == null) {
            throw new IllegalArgumentException();
        }
        this.graphT = graph;
        this.insertJGraphT(graph);
        this.setAutoSizeCells(true);
    }

    public HashMap<V, mxICell> getVertexToCellMap() {
        return this.vertexToCellMap;
    }

    public HashMap<E, mxICell> getEdgeToCellMap() {
        return this.edgeToCellMap;
    }

    public HashMap<mxICell, E> getCellToEdgeMap() {
        return this.cellToEdgeMap;
    }

    public HashMap<mxICell, V> getCellToVertexMap() {
        return this.cellToVertexMap;
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> e) {
        this.addJGraphTVertex(e.getVertex());
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> e) {
        mxICell cell = this.vertexToCellMap.remove(e.getVertex());
        this.removeCells(new Object[]{cell});
        this.cellToVertexMap.remove(cell);
        this.vertexToCellMap.remove(e.getVertex());
        ArrayList<E> removedEdges = new ArrayList<E>();
        for (E edge : this.cellToEdgeMap.values()) {
            if (this.graphT.edgeSet().contains(edge)) continue;
            removedEdges.add(edge);
        }
        for (E edge : removedEdges) {
            this.removeEdge(edge);
        }
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
        this.addJGraphTEdge(e.getEdge());
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
        this.removeEdge(e.getEdge());
    }

    private void removeEdge(E edge) {
        mxICell cell = this.edgeToCellMap.remove(edge);
        this.removeCells(new Object[]{cell});
        this.cellToEdgeMap.remove(cell);
        this.edgeToCellMap.remove(edge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJGraphTVertex(V vertex) {
        this.getModel().beginUpdate();
        try {
            mxICell cell = (mxICell)this.insertVertex(this.defaultParent, null, vertex, 0.0, 0.0, 0.0, 0.0);
            this.updateCellSize(cell);
            this.vertexToCellMap.put((mxICell)vertex, cell);
            this.cellToVertexMap.put(cell, vertex);
        }
        finally {
            this.getModel().endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJGraphTEdge(E edge) {
        this.getModel().beginUpdate();
        try {
            V sourceVertex = this.graphT.getEdgeSource(edge);
            V targetVertex = this.graphT.getEdgeTarget(edge);
            if (!this.vertexToCellMap.containsKey(sourceVertex) || !this.vertexToCellMap.containsKey(targetVertex)) {
                return;
            }
            mxICell sourceCell = this.vertexToCellMap.get(sourceVertex);
            mxICell targetCell = this.vertexToCellMap.get(targetVertex);
            mxICell cell = (mxICell)this.insertEdge(this.defaultParent, null, edge, sourceCell, targetCell);
            this.updateCellSize(cell);
            this.edgeToCellMap.put(edge, cell);
            this.cellToEdgeMap.put(cell, edge);
        }
        finally {
            this.getModel().endUpdate();
        }
    }

    private void insertJGraphT(Graph<V, E> graph) {
        for (V vertex : graph.vertexSet()) {
            this.addJGraphTVertex(vertex);
        }
        for (Object edge : graph.edgeSet()) {
            this.addJGraphTEdge(edge);
        }
    }
}

