/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.jgrapht.Graph;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class VisioExporter<V, E> {
    private VertexNameProvider<V> vertexNameProvider;

    public VisioExporter(VertexNameProvider<V> vertexNameProvider) {
        this.vertexNameProvider = vertexNameProvider;
    }

    public VisioExporter() {
        this(new StringNameProvider());
    }

    public void export(OutputStream output, Graph<V, E> g) {
        PrintStream out = new PrintStream(output);
        Iterator i = g.vertexSet().iterator();
        while (i.hasNext()) {
            this.exportVertex(out, i.next());
        }
        i = g.edgeSet().iterator();
        while (i.hasNext()) {
            this.exportEdge(out, i.next(), g);
        }
        out.flush();
    }

    private void exportEdge(PrintStream out, E edge, Graph<V, E> g) {
        String sourceName = this.vertexNameProvider.getVertexName(g.getEdgeSource(edge));
        String targetName = this.vertexNameProvider.getVertexName(g.getEdgeTarget(edge));
        out.print("Link,");
        out.print(sourceName);
        out.print("-->");
        out.print(targetName);
        out.print(",,,");
        out.print(sourceName);
        out.print(",");
        out.print(targetName);
        out.print("\n");
    }

    private void exportVertex(PrintStream out, V vertex) {
        String name = this.vertexNameProvider.getVertexName(vertex);
        out.print("Shape,");
        out.print(name);
        out.print(",,");
        out.print(name);
        out.print("\n");
    }
}

