/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class GmlExporter<V, E> {
    private static final String creator = "JGraphT GML Exporter";
    private static final String version = "1";
    private static final String delim = " ";
    private static final String tab1 = "\t";
    private static final String tab2 = "\t\t";
    public static final Integer PRINT_NO_LABELS = 1;
    public static final Integer PRINT_EDGE_LABELS = 2;
    public static final Integer PRINT_EDGE_VERTEX_LABELS = 3;
    public static final Integer PRINT_VERTEX_LABELS = 4;
    private Integer printLabels = PRINT_NO_LABELS;
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeIDProvider;
    private EdgeNameProvider<E> edgeLabelProvider;

    public GmlExporter() {
        this(new IntegerNameProvider(), null, new IntegerEdgeNameProvider(), null);
    }

    public GmlExporter(VertexNameProvider<V> vertexIDProvider, VertexNameProvider<V> vertexLabelProvider, EdgeNameProvider<E> edgeIDProvider, EdgeNameProvider<E> edgeLabelProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeIDProvider = edgeIDProvider;
        this.edgeLabelProvider = edgeLabelProvider;
    }

    private String quoted(String s) {
        return "\"" + s + "\"";
    }

    private void exportHeader(PrintWriter out) {
        out.println("Creator " + this.quoted(creator));
        out.println("Version 1");
    }

    private void exportVertices(PrintWriter out, Graph<V, E> g) {
        for (V from : g.vertexSet()) {
            out.println("\tnode");
            out.println("\t[");
            out.println("\t\tid " + this.vertexIDProvider.getVertexName(from));
            if (this.printLabels == PRINT_VERTEX_LABELS || this.printLabels == PRINT_EDGE_VERTEX_LABELS) {
                String label = this.vertexLabelProvider == null ? from.toString() : this.vertexLabelProvider.getVertexName(from);
                out.println("\t\tlabel " + this.quoted(label));
            }
            out.println("\t]");
        }
    }

    private void exportEdges(PrintWriter out, Graph<V, E> g) {
        for (E edge : g.edgeSet()) {
            out.println("\tedge");
            out.println("\t[");
            String id = this.edgeIDProvider.getEdgeName(edge);
            out.println("\t\tid " + id);
            String s = this.vertexIDProvider.getVertexName(g.getEdgeSource(edge));
            out.println("\t\tsource " + s);
            String t = this.vertexIDProvider.getVertexName(g.getEdgeTarget(edge));
            out.println("\t\ttarget " + t);
            if (this.printLabels == PRINT_EDGE_LABELS || this.printLabels == PRINT_EDGE_VERTEX_LABELS) {
                String label = this.edgeLabelProvider == null ? edge.toString() : this.edgeLabelProvider.getEdgeName(edge);
                out.println("\t\tlabel " + this.quoted(label));
            }
            out.println("\t]");
        }
    }

    private void export(Writer output, Graph<V, E> g, boolean directed) {
        PrintWriter out = new PrintWriter(output);
        for (V from : g.vertexSet()) {
            this.vertexIDProvider.getVertexName(from);
        }
        this.exportHeader(out);
        out.println("graph");
        out.println("[");
        out.println("\tlabel " + this.quoted(""));
        if (directed) {
            out.println("\tdirected 1");
        } else {
            out.println("\tdirected 0");
        }
        this.exportVertices(out, g);
        this.exportEdges(out, g);
        out.println("]");
        out.flush();
    }

    public void export(Writer output, UndirectedGraph<V, E> g) {
        this.export(output, g, false);
    }

    public void export(Writer output, DirectedGraph<V, E> g) {
        this.export(output, g, true);
    }

    public void setPrintLabels(Integer i) {
        if (i != PRINT_NO_LABELS && i != PRINT_EDGE_LABELS && i != PRINT_EDGE_VERTEX_LABELS && i != PRINT_VERTEX_LABELS) {
            throw new IllegalArgumentException("Non-supported parameter value: " + Integer.toString(i));
        }
        this.printLabels = i;
    }

    public Integer getPrintLabels() {
        return this.printLabels;
    }
}

