/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.Graph;
import org.jgrapht.ext.ExportException;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class VisioExporter<V, E>
implements GraphExporter<V, E> {
    private VertexNameProvider<V> vertexNameProvider;

    public VisioExporter(VertexNameProvider<V> vertexNameProvider) {
        this.vertexNameProvider = vertexNameProvider;
    }

    public VisioExporter() {
        this(new StringNameProvider());
    }

    @Deprecated
    public void export(OutputStream output, Graph<V, E> g) {
        try {
            this.exportGraph(g, output);
        }
        catch (ExportException exportException) {
            // empty catch block
        }
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        for (Object v : g.vertexSet()) {
            this.exportVertex(out, v);
        }
        for (Object e : g.edgeSet()) {
            this.exportEdge(out, e, g);
        }
        out.flush();
    }

    private void exportEdge(PrintWriter out, E edge, Graph<V, E> g) {
        String sourceName = this.vertexNameProvider.getVertexName(g.getEdgeSource(edge));
        String targetName = this.vertexNameProvider.getVertexName(g.getEdgeTarget(edge));
        out.print("Link,");
        out.print(sourceName);
        out.print("-->");
        out.print(targetName);
        out.print(",,,");
        out.print(sourceName);
        out.print(",");
        out.print(targetName);
        out.print("\n");
    }

    private void exportVertex(PrintWriter out, V vertex) {
        String name = this.vertexNameProvider.getVertexName(vertex);
        out.print("Shape,");
        out.print(name);
        out.print(",,");
        out.print(name);
        out.print("\n");
    }
}

