/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.guava.ElementOrder;
import org.jgrapht.graph.guava.ElementOrderMethod;

public abstract class BaseGraphAdapter<V, G extends com.google.common.graph.Graph<V>>
extends AbstractGraph<V, EndpointPair<V>>
implements Graph<V, EndpointPair<V>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6742507788742087708L;
    protected static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    protected transient Set<V> unmodifiableVertexSet = null;
    protected transient Set<EndpointPair<V>> unmodifiableEdgeSet = null;
    protected Supplier<V> vertexSupplier;
    protected Supplier<EndpointPair<V>> edgeSupplier;
    protected transient G graph;
    protected ElementOrderMethod<V> vertexOrderMethod;
    protected transient ElementOrder<V> vertexOrder;

    public BaseGraphAdapter(G graph) {
        this(graph, null, null);
    }

    public BaseGraphAdapter(G graph, Supplier<V> vertexSupplier, Supplier<EndpointPair<V>> edgeSupplier) {
        this(graph, vertexSupplier, edgeSupplier, ElementOrderMethod.internal());
    }

    public BaseGraphAdapter(G graph, Supplier<V> vertexSupplier, Supplier<EndpointPair<V>> edgeSupplier, ElementOrderMethod<V> vertexOrderMethod) {
        this.vertexSupplier = vertexSupplier;
        this.edgeSupplier = edgeSupplier;
        this.graph = (com.google.common.graph.Graph)Objects.requireNonNull(graph);
        this.vertexOrderMethod = Objects.requireNonNull(vertexOrderMethod);
        this.vertexOrder = this.createVertexOrder(vertexOrderMethod);
    }

    public Supplier<V> getVertexSupplier() {
        return this.vertexSupplier;
    }

    public void setVertexSupplier(Supplier<V> vertexSupplier) {
        this.vertexSupplier = vertexSupplier;
    }

    public Supplier<EndpointPair<V>> getEdgeSupplier() {
        return this.edgeSupplier;
    }

    public void setEdgeSupplier(Supplier<EndpointPair<V>> edgeSupplier) {
        this.edgeSupplier = edgeSupplier;
    }

    public EndpointPair<V> getEdge(V sourceVertex, V targetVertex) {
        if (sourceVertex == null || targetVertex == null) {
            return null;
        }
        if (!this.graph.hasEdgeConnecting(sourceVertex, targetVertex)) {
            return null;
        }
        return this.createEdge(sourceVertex, targetVertex);
    }

    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.graph.nodes());
        }
        return this.unmodifiableVertexSet;
    }

    public V getEdgeSource(EndpointPair<V> e) {
        Object v;
        if (this.graph.isDirected()) {
            return (V)e.nodeU();
        }
        Object u = e.nodeU();
        int c = this.vertexOrder.compare(u, v = e.nodeV());
        if (c <= 0) {
            return (V)u;
        }
        return (V)v;
    }

    public V getEdgeTarget(EndpointPair<V> e) {
        Object v;
        if (this.graph.isDirected()) {
            return (V)e.nodeV();
        }
        Object u = e.nodeU();
        int c = this.vertexOrder.compare(u, v = e.nodeV());
        if (c <= 0) {
            return (V)v;
        }
        return (V)u;
    }

    public GraphType getType() {
        return (this.graph.isDirected() ? new DefaultGraphType.Builder().directed() : new DefaultGraphType.Builder().undirected()).weighted(false).allowMultipleEdges(false).allowSelfLoops(this.graph.allowsSelfLoops()).build();
    }

    public boolean containsEdge(EndpointPair<V> e) {
        return this.graph.edges().contains(e);
    }

    public boolean containsVertex(V v) {
        return this.graph.nodes().contains(v);
    }

    public Set<EndpointPair<V>> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.graph.edges());
        }
        return this.unmodifiableEdgeSet;
    }

    public int degreeOf(V vertex) {
        return this.graph.degree(vertex);
    }

    public Set<EndpointPair<V>> edgesOf(V vertex) {
        return this.graph.incidentEdges(vertex);
    }

    public int inDegreeOf(V vertex) {
        return this.graph.inDegree(vertex);
    }

    public Set<EndpointPair<V>> incomingEdgesOf(V vertex) {
        return this.graph.predecessors(vertex).stream().map(other -> this.createEdge(other, vertex)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public int outDegreeOf(V vertex) {
        return this.graph.outDegree(vertex);
    }

    public Set<EndpointPair<V>> outgoingEdgesOf(V vertex) {
        return this.graph.successors(vertex).stream().map(other -> this.createEdge(vertex, other)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public double getEdgeWeight(EndpointPair<V> e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (!this.graph.hasEdgeConnecting(e.nodeU(), e.nodeV())) {
            throw new IllegalArgumentException("no such edge in graph: " + e.toString());
        }
        return 1.0;
    }

    public Set<EndpointPair<V>> getAllEdges(V sourceVertex, V targetVertex) {
        if (sourceVertex == null || targetVertex == null || !this.graph.nodes().contains(sourceVertex) || !this.graph.nodes().contains(targetVertex)) {
            return null;
        }
        if (!this.graph.hasEdgeConnecting(sourceVertex, targetVertex)) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.createEdge(sourceVertex, targetVertex));
    }

    final EndpointPair<V> createEdge(V s, V t) {
        return this.graph.isDirected() ? EndpointPair.ordered(s, t) : EndpointPair.unordered(s, t);
    }

    protected ElementOrder<V> createVertexOrder(ElementOrderMethod<V> vertexOrderMethod) {
        switch (vertexOrderMethod.getType()) {
            case COMPARATOR: {
                return ElementOrder.comparator(vertexOrderMethod.comparator());
            }
            case GUAVA_COMPARATOR: {
                if (!this.graph.nodeOrder().type().equals((Object)ElementOrder.Type.SORTED)) {
                    throw new IllegalArgumentException("Guava comparator only usable if node order is SORTED!");
                }
                return ElementOrder.comparator(this.graph.nodeOrder().comparator());
            }
            case NATURAL: {
                return ElementOrder.natural();
            }
        }
        return ElementOrder.internal();
    }
}

