/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class ElementOrder<V>
implements Serializable {
    private static final long serialVersionUID = -3732847114940656189L;
    private Comparator<V> comparator;
    private Map<V, Long> indices;
    private long nextId;

    private ElementOrder(Comparator<V> comparator, Map<V, Long> indices) {
        this.indices = indices;
        this.comparator = comparator;
        this.nextId = 0L;
    }

    public static <V> ElementOrder<V> comparator(Comparator<V> comparator) {
        return new ElementOrder<V>(comparator, null);
    }

    public static <V> ElementOrder<V> natural() {
        return new ElementOrder<V>(null, null);
    }

    public static <V> ElementOrder<V> internal() {
        return new ElementOrder(null, new HashMap());
    }

    public int compare(V v, V u) {
        if (this.comparator != null) {
            return this.comparator.compare(v, u);
        }
        if (this.indices != null) {
            long vid = this.indices.computeIfAbsent((Long)v, (Function<Long, Long>)((Function<Object, Long>)this::computeNextId));
            long uid = this.indices.computeIfAbsent((Long)u, (Function<Long, Long>)((Function<Object, Long>)this::computeNextId));
            return Long.compare(vid, uid);
        }
        return ((Comparable)v).compareTo(u);
    }

    public V min(V v, V u) {
        return this.compare(v, u) <= 0 ? v : u;
    }

    public void notifyAddition(V v) {
        if (this.indices != null) {
            this.indices.computeIfAbsent((Long)v, (Function<Long, Long>)((Function<Object, Long>)this::computeNextId));
        }
    }

    public void notifyRemoval(V v) {
        if (this.indices != null) {
            this.indices.remove(v);
        }
    }

    private long computeNextId(V vertex) {
        return this.nextId++;
    }
}

