/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.guava.BaseNetworkAdapter;
import org.jgrapht.util.TypeUtil;

public class ImmutableNetworkAdapter<V, E>
extends BaseNetworkAdapter<V, E, ImmutableNetwork<V, E>>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8776276294297681092L;
    protected static final String GRAPH_IS_IMMUTABLE = "Graph is immutable";

    public ImmutableNetworkAdapter(ImmutableNetwork<V, E> network) {
        super(network);
    }

    public E addEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public V addVertex() {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public E removeEdge(V sourceVertex, V targetVertex) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(GRAPH_IS_IMMUTABLE);
    }

    @Override
    public double getEdgeWeight(E e) {
        return 1.0;
    }

    public void setEdgeWeight(E e, double weight) {
        throw new UnsupportedOperationException("Graph is unweighted");
    }

    @Override
    public GraphType getType() {
        return super.getType().asUnmodifiable();
    }

    public Object clone() {
        try {
            ImmutableNetworkAdapter newGraph = (ImmutableNetworkAdapter)TypeUtil.uncheckedCast((Object)super.clone());
            newGraph.vertexSupplier = this.vertexSupplier;
            newGraph.edgeSupplier = this.edgeSupplier;
            newGraph.unmodifiableVertexSet = null;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.network = ImmutableNetwork.copyOf((Network)Graphs.copyOf((Network)this.network));
            newGraph.vertexOrder = this.createVertexOrder(newGraph.vertexOrderMethod);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
        int n = this.vertexSet().size();
        oos.writeInt(n);
        for (Object v : this.vertexSet()) {
            oos.writeObject(v);
        }
        int m = this.edgeSet().size();
        oos.writeInt(m);
        for (Object e : this.edgeSet()) {
            oos.writeObject(this.getEdgeSource(e));
            oos.writeObject(this.getEdgeTarget(e));
            oos.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        GraphType type = (GraphType)ois.readObject();
        if (type.isMixed()) {
            throw new IOException("Graph type not supported");
        }
        MutableNetwork mutableNetwork = (type.isDirected() ? NetworkBuilder.directed() : NetworkBuilder.undirected()).allowsParallelEdges(type.isAllowingMultipleEdges()).allowsSelfLoops(type.isAllowingSelfLoops()).build();
        int n = ois.readInt();
        for (int i = 0; i < n; ++i) {
            Object v = ois.readObject();
            mutableNetwork.addNode(v);
        }
        int m = ois.readInt();
        for (int i = 0; i < m; ++i) {
            Object s = ois.readObject();
            Object t = ois.readObject();
            Object e = ois.readObject();
            mutableNetwork.addEdge(s, t, e);
        }
        this.vertexOrder = this.createVertexOrder(this.vertexOrderMethod);
        this.network = ImmutableNetwork.copyOf((Network)mutableNetwork);
    }
}

