/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.guava;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.guava.BaseValueGraphAdapter;
import org.jgrapht.graph.guava.ElementOrderMethod;
import org.jgrapht.util.TypeUtil;

public class MutableValueGraphAdapter<V, W>
extends BaseValueGraphAdapter<V, W, MutableValueGraph<V, W>>
implements Graph<V, EndpointPair<V>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5095044027783397573L;
    protected final W defaultValue;

    public MutableValueGraphAdapter(MutableValueGraph<V, W> valueGraph, W defaultValue, ToDoubleFunction<W> valueConverter) {
        this(valueGraph, defaultValue, valueConverter, null, null);
    }

    public MutableValueGraphAdapter(MutableValueGraph<V, W> valueGraph, W defaultValue, ToDoubleFunction<W> valueConverter, Supplier<V> vertexSupplier, Supplier<EndpointPair<V>> edgeSupplier) {
        super(valueGraph, valueConverter, vertexSupplier, edgeSupplier, ElementOrderMethod.internal());
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public MutableValueGraphAdapter(MutableValueGraph<V, W> valueGraph, W defaultValue, ToDoubleFunction<W> valueConverter, Supplier<V> vertexSupplier, Supplier<EndpointPair<V>> edgeSupplier, ElementOrderMethod<V> vertexOrderMethod) {
        super(valueGraph, valueConverter, vertexSupplier, edgeSupplier, vertexOrderMethod);
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public EndpointPair<V> addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (this.containsEdge(sourceVertex, targetVertex)) {
            return null;
        }
        if (!((MutableValueGraph)this.valueGraph).allowsSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException("loops not allowed");
        }
        ((MutableValueGraph)this.valueGraph).putEdgeValue(sourceVertex, targetVertex, this.defaultValue);
        return this.createEdge(sourceVertex, targetVertex);
    }

    public boolean addEdge(V sourceVertex, V targetVertex, EndpointPair<V> e) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (e != null) {
            if (!sourceVertex.equals(e.nodeU())) {
                throw new IllegalArgumentException("Provided edge must have node U equal to source vertex");
            }
            if (!targetVertex.equals(e.nodeV())) {
                throw new IllegalArgumentException("Provided edge must have node V equal to target vertex");
            }
        }
        if (this.containsEdge(sourceVertex, targetVertex)) {
            return false;
        }
        if (!((MutableValueGraph)this.valueGraph).allowsSelfLoops() && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException("loops not allowed");
        }
        ((MutableValueGraph)this.valueGraph).putEdgeValue(sourceVertex, targetVertex, this.defaultValue);
        return true;
    }

    public V addVertex() {
        if (this.vertexSupplier == null) {
            throw new UnsupportedOperationException("The graph contains no vertex supplier");
        }
        Object v = this.vertexSupplier.get();
        if (((MutableValueGraph)this.valueGraph).addNode(v)) {
            return (V)v;
        }
        return null;
    }

    public boolean addVertex(V v) {
        return ((MutableValueGraph)this.valueGraph).addNode(v);
    }

    public EndpointPair<V> removeEdge(V sourceVertex, V targetVertex) {
        EndpointPair<V> e = this.getEdge(sourceVertex, targetVertex);
        if (e != null) {
            ((MutableValueGraph)this.valueGraph).removeEdge(sourceVertex, targetVertex);
        }
        return e;
    }

    public boolean removeEdge(EndpointPair<V> e) {
        if (e == null) {
            return false;
        }
        return ((MutableValueGraph)this.valueGraph).removeEdge(e.nodeU(), e.nodeV()) != null;
    }

    public boolean removeVertex(V v) {
        this.vertexOrder.notifyRemoval(v);
        return ((MutableValueGraph)this.valueGraph).removeNode(v);
    }

    public void setEdgeWeight(EndpointPair<V> e, double weight) {
        throw new UnsupportedOperationException("Not supported operation. Change directly the underlying value graph");
    }

    public Object clone() {
        try {
            MutableValueGraphAdapter newGraph = (MutableValueGraphAdapter)TypeUtil.uncheckedCast((Object)super.clone());
            newGraph.vertexSupplier = this.vertexSupplier;
            newGraph.edgeSupplier = this.edgeSupplier;
            newGraph.unmodifiableVertexSet = null;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.valueConverter = this.valueConverter;
            newGraph.valueGraph = Graphs.copyOf((ValueGraph)this.valueGraph);
            newGraph.vertexOrder = this.createVertexOrder(newGraph.vertexOrderMethod);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
        int n = this.vertexSet().size();
        oos.writeInt(n);
        for (Object v : this.vertexSet()) {
            oos.writeObject(v);
        }
        int m = this.edgeSet().size();
        oos.writeInt(m);
        for (EndpointPair e : this.edgeSet()) {
            Object u = e.nodeU();
            Object v = e.nodeV();
            oos.writeObject(u);
            oos.writeObject(v);
            oos.writeObject(((MutableValueGraph)this.valueGraph).edgeValue(u, v).get());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        GraphType type = (GraphType)ois.readObject();
        if (type.isMixed() || type.isAllowingMultipleEdges()) {
            throw new IOException("Graph type not supported");
        }
        this.valueGraph = (type.isDirected() ? ValueGraphBuilder.directed() : ValueGraphBuilder.undirected()).allowsSelfLoops(type.isAllowingSelfLoops()).build();
        int n = ois.readInt();
        for (int i = 0; i < n; ++i) {
            Object v = ois.readObject();
            ((MutableValueGraph)this.valueGraph).addNode(v);
        }
        int m = ois.readInt();
        for (int i = 0; i < m; ++i) {
            Object s = ois.readObject();
            Object t = ois.readObject();
            Object w = ois.readObject();
            ((MutableValueGraph)this.valueGraph).putEdgeValue(s, t, w);
        }
        this.vertexOrder = this.createVertexOrder(this.vertexOrderMethod);
    }
}

