/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.opt.graph.sparse.IncomingEdgesSupport;
import org.jgrapht.opt.graph.sparse.specifics.AbstractSparseSpecificsGraph;
import org.jgrapht.opt.graph.sparse.specifics.IncomingNoReindexSparseDirectedSpecifics;
import org.jgrapht.opt.graph.sparse.specifics.NoIncomingNoReindexSparseDirectedSpecifics;
import org.jgrapht.opt.graph.sparse.specifics.SparseGraphSpecifics;

public class SparseIntDirectedGraph
extends AbstractSparseSpecificsGraph<SparseGraphSpecifics> {
    protected static final String UNMODIFIABLE = "this graph is unmodifiable";

    public SparseIntDirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges) {
        this(numVertices, edges.size(), () -> edges.stream(), IncomingEdgesSupport.FULL_INCOMING_EDGES);
    }

    public SparseIntDirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges, IncomingEdgesSupport incomingEdgesSupport) {
        this(numVertices, edges.size(), () -> edges.stream(), incomingEdgesSupport);
    }

    public SparseIntDirectedGraph(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges, IncomingEdgesSupport incomingEdgesSupport) {
        super(() -> {
            switch (incomingEdgesSupport) {
                case FULL_INCOMING_EDGES: {
                    return new IncomingNoReindexSparseDirectedSpecifics(numVertices, numEdges, edges, false);
                }
                case LAZY_INCOMING_EDGES: {
                    return new IncomingNoReindexSparseDirectedSpecifics(numVertices, numEdges, edges, true);
                }
            }
            return new NoIncomingNoReindexSparseDirectedSpecifics(numVertices, numEdges, edges);
        });
    }
}

