/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse;

import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jgrapht.GraphType;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.alg.util.Triple;
import org.jgrapht.opt.graph.sparse.IncomingEdgesSupport;
import org.jgrapht.opt.graph.sparse.SparseIntDirectedGraph;

public class SparseIntDirectedWeightedGraph
extends SparseIntDirectedGraph
implements Serializable {
    private static final long serialVersionUID = -7601401110000642281L;
    protected double[] weights;

    public SparseIntDirectedWeightedGraph(int numVertices, List<Triple<Integer, Integer, Double>> edges) {
        this(numVertices, edges.size(), () -> edges.stream(), IncomingEdgesSupport.FULL_INCOMING_EDGES);
    }

    public SparseIntDirectedWeightedGraph(int numVertices, List<Triple<Integer, Integer, Double>> edges, IncomingEdgesSupport incomingEdgeSupport) {
        this(numVertices, edges.size(), () -> edges.stream(), incomingEdgeSupport);
    }

    public SparseIntDirectedWeightedGraph(int numVertices, int numEdges, Supplier<Stream<Triple<Integer, Integer, Double>>> edges, IncomingEdgesSupport incomingEdgeSupport) {
        super(numVertices, numEdges, () -> ((Stream)edges.get()).map(e -> Pair.of((Object)((Integer)e.getFirst()), (Object)((Integer)e.getSecond()))), incomingEdgeSupport);
        this.weights = new double[numEdges];
        int[] eIndex = new int[1];
        edges.get().forEach(e -> {
            double edgeWeight = e.getThird() != null ? (Double)e.getThird() : 1.0;
            int n = eIndex[0];
            eIndex[0] = n + 1;
            this.weights[n] = edgeWeight;
        });
    }

    @Override
    public GraphType getType() {
        return super.getType().asWeighted();
    }

    @Override
    public double getEdgeWeight(Integer e) {
        this.specifics.assertEdgeExist(e);
        return this.weights[e];
    }

    @Override
    public void setEdgeWeight(Integer e, double weight) {
        this.specifics.assertEdgeExist(e);
        this.weights[e.intValue()] = weight;
    }
}

