/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.opt.graph.sparse.specifics;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.opt.graph.sparse.specifics.CSRBooleanMatrix;
import org.jgrapht.opt.graph.sparse.specifics.NoIncomingNoReindexSparseDirectedSpecifics;
import org.jgrapht.util.UnmodifiableUnionSet;

public class IncomingNoReindexSparseDirectedSpecifics
extends NoIncomingNoReindexSparseDirectedSpecifics {
    protected CSRBooleanMatrix inIncidenceMatrix;

    public IncomingNoReindexSparseDirectedSpecifics(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges, boolean lazyIncomingEdges) {
        super(numVertices, numEdges, edges);
        if (!lazyIncomingEdges) {
            this.indexIncomingEdges();
        }
    }

    @Override
    public long degreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        if (this.inIncidenceMatrix == null) {
            this.indexIncomingEdges();
        }
        return this.outIncidenceMatrix.nonZeros(vertex) + this.inIncidenceMatrix.nonZeros(vertex);
    }

    @Override
    public Set<Integer> edgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        if (this.inIncidenceMatrix == null) {
            this.indexIncomingEdges();
        }
        return new UnmodifiableUnionSet(this.outIncidenceMatrix.nonZerosSet(vertex), this.inIncidenceMatrix.nonZerosSet(vertex));
    }

    @Override
    public long inDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        if (this.inIncidenceMatrix == null) {
            this.indexIncomingEdges();
        }
        return this.inIncidenceMatrix.nonZeros(vertex);
    }

    @Override
    public Set<Integer> incomingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        if (this.inIncidenceMatrix == null) {
            this.indexIncomingEdges();
        }
        return this.inIncidenceMatrix.nonZerosSet(vertex);
    }

    protected void indexIncomingEdges() {
        int n = this.outIncidenceMatrix.rows();
        int m = this.source.length;
        ArrayList<Pair<Integer, Integer>> incoming = new ArrayList<Pair<Integer, Integer>>(m);
        for (int i = 0; i < m; ++i) {
            incoming.add((Pair<Integer, Integer>)Pair.of((Object)this.target[i], (Object)i));
        }
        this.inIncidenceMatrix = new CSRBooleanMatrix(n, m, incoming);
    }
}

