/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.sux4j;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.sux4j.util.EliasFanoIndexedMonotoneLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.GraphIterables;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.opt.graph.sparse.IncomingEdgesSupport;
import org.jgrapht.opt.graph.sparse.SparseIntDirectedGraph;
import org.jgrapht.sux4j.AbstractSuccinctDirectedGraph;

public class SuccinctDirectedGraph
extends AbstractSuccinctDirectedGraph<IntIntPair>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final EliasFanoIndexedMonotoneLongBigList cumulativeOutdegrees;
    private final EliasFanoMonotoneLongBigList cumulativeIndegrees;
    private final EliasFanoIndexedMonotoneLongBigList successors;
    private final EliasFanoMonotoneLongBigList predecessors;
    private final GraphIterables<Integer, IntIntPair> iterables = new SuccinctGraphIterables(this);

    public <E> SuccinctDirectedGraph(Graph<Integer, E> graph, boolean incomingEdgesSupport) {
        super((int)graph.iterables().vertexCount(), (int)graph.iterables().edgeCount());
        if (graph.getType().isUndirected()) {
            throw new IllegalArgumentException("This class supports directed graphs only");
        }
        assert (graph.getType().isDirected());
        GraphIterables iterables = graph.iterables();
        if (iterables.vertexCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of nodes (" + iterables.vertexCount() + ") is greater than 2147483647");
        }
        if (iterables.edgeCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of edges (" + iterables.edgeCount() + ") is greater than 2147483647");
        }
        this.cumulativeOutdegrees = new EliasFanoIndexedMonotoneLongBigList((long)(this.n + 1), (long)this.m, (LongIterator)new AbstractSuccinctDirectedGraph.CumulativeDegrees(this.n, arg_0 -> graph.outDegreeOf(arg_0)));
        assert (this.cumulativeOutdegrees.getLong(this.cumulativeOutdegrees.size64() - 1L) == (long)this.m);
        this.successors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n << this.sourceShift, new AbstractSuccinctDirectedGraph.CumulativeSuccessors<E>(graph, arg_0 -> ((GraphIterables)iterables).outgoingEdgesOf(arg_0), true));
        if (incomingEdgesSupport) {
            this.cumulativeIndegrees = new EliasFanoMonotoneLongBigList((long)(this.n + 1), (long)this.m, (LongIterator)new AbstractSuccinctDirectedGraph.CumulativeDegrees(this.n, arg_0 -> graph.inDegreeOf(arg_0)));
            assert (this.cumulativeIndegrees.getLong(this.cumulativeIndegrees.size64() - 1L) == (long)this.m);
            this.predecessors = new EliasFanoIndexedMonotoneLongBigList((long)this.m, (long)this.n * (long)this.n - (long)this.m, new AbstractSuccinctDirectedGraph.CumulativeSuccessors<E>(graph, arg_0 -> ((GraphIterables)iterables).incomingEdgesOf(arg_0), false));
        } else {
            this.predecessors = null;
            this.cumulativeIndegrees = null;
        }
    }

    public <E> SuccinctDirectedGraph(Graph<Integer, E> graph) {
        this(graph, true);
    }

    public SuccinctDirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges, boolean incomingEdgesSupport) {
        this((Graph)new SparseIntDirectedGraph(numVertices, edges, incomingEdgesSupport ? IncomingEdgesSupport.FULL_INCOMING_EDGES : IncomingEdgesSupport.NO_INCOMING_EDGES), incomingEdgesSupport);
    }

    public SuccinctDirectedGraph(int numVertices, List<Pair<Integer, Integer>> edges) {
        this(numVertices, edges, true);
    }

    public SuccinctDirectedGraph(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges, boolean incomingEdgesSupport) {
        this((Graph)new SparseIntDirectedGraph(numVertices, numEdges, edges, incomingEdgesSupport ? IncomingEdgesSupport.FULL_INCOMING_EDGES : IncomingEdgesSupport.NO_INCOMING_EDGES));
    }

    public SuccinctDirectedGraph(int numVertices, int numEdges, Supplier<Stream<Pair<Integer, Integer>>> edges) {
        this(numVertices, numEdges, edges, true);
    }

    public boolean containsEdge(IntIntPair e) {
        return this.successors.indexOfUnsafe(((long)e.firstInt() << this.sourceShift) + (long)e.secondInt()) != -1L;
    }

    public Set<IntIntPair> edgeSet() {
        return new ObjectOpenHashSet(this.iterables().edges().iterator());
    }

    public Set<IntIntPair> edgesOf(Integer vertex) {
        Set<IntIntPair> result = this.outgoingEdgesOf(vertex);
        result.addAll(this.incomingEdgesOf(vertex));
        return result;
    }

    public int inDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return (int)this.cumulativeIndegrees.getDelta((long)vertex.intValue());
    }

    public Set<IntIntPair> incomingEdgesOf(Integer target) {
        this.assertVertexExist(target);
        int t = target;
        long[] result = new long[2];
        this.cumulativeIndegrees.get((long)t, result);
        int d = (int)(result[1] - result[0]);
        EliasFanoMonotoneLongBigList.EliasFanoMonotoneLongBigListIterator iterator = this.predecessors.listIterator(result[0]);
        ObjectOpenHashSet s = new ObjectOpenHashSet();
        long base = (long)this.n * (long)t - result[0];
        int i = d;
        while (i-- != 0) {
            long source = iterator.nextLong() - base--;
            s.add((Object)IntIntPair.of((int)((int)source), (int)t));
        }
        return s;
    }

    public int outDegreeOf(Integer vertex) {
        this.assertVertexExist(vertex);
        return (int)this.cumulativeOutdegrees.getDelta((long)vertex.intValue());
    }

    public Set<IntIntPair> outgoingEdgesOf(Integer vertex) {
        this.assertVertexExist(vertex);
        int x = vertex;
        long[] result = new long[2];
        this.cumulativeOutdegrees.get((long)x, result);
        ObjectOpenHashSet s = new ObjectOpenHashSet();
        EliasFanoIndexedMonotoneLongBigList.EliasFanoIndexedMonotoneLongBigListIterator iterator = this.successors.listIterator(result[0]);
        long base = (long)x << this.sourceShift;
        int d = (int)(result[1] - result[0]);
        while (d-- != 0) {
            s.add((Object)IntIntPair.of((int)x, (int)((int)(iterator.nextLong() - base))));
        }
        return s;
    }

    public Integer getEdgeSource(IntIntPair e) {
        return e.firstInt();
    }

    public Integer getEdgeTarget(IntIntPair e) {
        return e.secondInt();
    }

    public long getIndexFromEdge(IntIntPair e) {
        int source = e.firstInt();
        int target = e.secondInt();
        if (source < 0 || source >= this.n || target < 0 || target >= this.n) {
            throw new IllegalArgumentException();
        }
        return this.successors.indexOfUnsafe(((long)source << this.sourceShift) + (long)target);
    }

    public IntIntPair getEdgeFromIndex(long i) {
        if (i < 0L || i >= (long)this.m) {
            throw new IllegalArgumentException();
        }
        long t = this.successors.getLong(i);
        return IntIntPair.of((int)((int)(t >>> this.sourceShift)), (int)((int)(t & this.targetMask)));
    }

    public IntIntPair getEdge(Integer sourceVertex, Integer targetVertex) {
        long index = this.successors.indexOfUnsafe(((long)sourceVertex.intValue() << this.sourceShift) + (long)targetVertex.intValue());
        return index != -1L ? IntIntPair.of((int)sourceVertex, (int)targetVertex) : null;
    }

    public boolean containsEdge(Integer sourceVertex, Integer targetVertex) {
        return this.successors.indexOfUnsafe(((long)sourceVertex.intValue() << this.sourceShift) + (long)targetVertex.intValue()) != -1L;
    }

    public GraphIterables<Integer, IntIntPair> iterables() {
        return this.iterables;
    }

    private static final class SuccinctGraphIterables
    implements GraphIterables<Integer, IntIntPair>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final SuccinctDirectedGraph graph;

        private SuccinctGraphIterables() {
            this.graph = null;
        }

        private SuccinctGraphIterables(SuccinctDirectedGraph graph) {
            this.graph = graph;
        }

        public Graph<Integer, IntIntPair> getGraph() {
            return this.graph;
        }

        public long vertexCount() {
            return this.graph.n;
        }

        public long edgeCount() {
            return this.graph.m;
        }

        public Iterable<IntIntPair> edges() {
            final int sourceShift = this.graph.sourceShift;
            final long targetMask = this.graph.targetMask;
            return () -> new Iterator<IntIntPair>(){
                private final EliasFanoIndexedMonotoneLongBigList.EliasFanoIndexedMonotoneLongBigListIterator iterator;
                private final int n;
                {
                    this.iterator = graph.successors.iterator();
                    this.n = graph.n;
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public IntIntPair next() {
                    long t = this.iterator.nextLong();
                    return IntIntPair.of((int)((int)(t >>> sourceShift)), (int)((int)(t & targetMask)));
                }
            };
        }

        public Iterable<IntIntPair> edgesOf(Integer source) {
            return Iterables.concat(this.outgoingEdgesOf(source), this.incomingEdgesOf(source, true));
        }

        private Iterable<IntIntPair> incomingEdgesOf(int target, boolean skipLoops) {
            SuccinctDirectedGraph graph = this.graph;
            long[] result = new long[2];
            graph.cumulativeIndegrees.get((long)target, result);
            int d = (int)(result[1] - result[0]);
            EliasFanoIndexedMonotoneLongBigList successors = graph.successors;
            EliasFanoMonotoneLongBigList.EliasFanoMonotoneLongBigListIterator iterator = graph.predecessors.listIterator(result[0]);
            return () -> this.lambda$incomingEdgesOf$1(d, graph, target, result, (LongBigListIterator)iterator, skipLoops);
        }

        public Iterable<IntIntPair> outgoingEdgesOf(Integer vertex) {
            int sourceShift = this.graph.sourceShift;
            long targetMask = this.graph.targetMask;
            this.graph.assertVertexExist(vertex);
            int x = vertex;
            long[] result = new long[2];
            this.graph.cumulativeOutdegrees.get((long)x, result);
            EliasFanoIndexedMonotoneLongBigList.EliasFanoIndexedMonotoneLongBigListIterator iterator = this.graph.successors.listIterator(result[0]);
            long base = (long)x << sourceShift;
            return () -> this.lambda$outgoingEdgesOf$2(result, x, (LongBigListIterator)iterator, base);
        }

        public Iterable<IntIntPair> incomingEdgesOf(Integer vertex) {
            this.graph.assertVertexExist(vertex);
            return this.incomingEdgesOf(vertex, false);
        }

        private /* synthetic */ Iterator lambda$outgoingEdgesOf$2(final long[] result, final int x, final LongBigListIterator iterator, final long base) {
            return new Iterator<IntIntPair>(){
                private int d;
                {
                    this.d = (int)(result[1] - result[0]);
                }

                @Override
                public boolean hasNext() {
                    return this.d != 0;
                }

                @Override
                public IntIntPair next() {
                    if (this.d == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.d;
                    return IntIntPair.of((int)x, (int)((int)(iterator.nextLong() - base)));
                }
            };
        }

        private /* synthetic */ Iterator lambda$incomingEdgesOf$1(final int d, final SuccinctDirectedGraph graph, final int target, final long[] result, final LongBigListIterator iterator, final boolean skipLoops) {
            return new Iterator<IntIntPair>(){
                int i;
                IntIntPair edge;
                long n;
                long base;
                {
                    this.i = d;
                    this.edge = null;
                    this.n = graph.n;
                    this.base = (long)target * this.n - result[0];
                }

                @Override
                public boolean hasNext() {
                    if (this.edge == null && this.i > 0) {
                        --this.i;
                        long source = iterator.nextLong() - this.base--;
                        if (skipLoops && source == (long)target && this.i-- != 0) {
                            return false;
                        }
                        this.edge = IntIntPair.of((int)((int)source), (int)target);
                    }
                    return this.edge != null;
                }

                @Override
                public IntIntPair next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    IntIntPair result2 = this.edge;
                    this.edge = null;
                    return result2;
                }
            };
        }
    }
}

