/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.webgraph;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntSkippableIterator;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.graph.AbstractGraph;

public abstract class AbstractImmutableGraphAdapter<E extends IntIntPair>
extends AbstractGraph<Integer, E> {
    protected final ImmutableGraph immutableGraph;
    protected final int n;
    protected long m = -1L;

    protected AbstractImmutableGraphAdapter(ImmutableGraph immutableGraph) {
        this.immutableGraph = immutableGraph;
        this.n = immutableGraph.numNodes();
    }

    public Set<E> getAllEdges(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex == null || targetVertex == null) {
            return null;
        }
        int x = sourceVertex;
        int y = targetVertex;
        if (x < 0 || x >= this.n || y < 0 || y >= this.n) {
            return null;
        }
        return this.containsEdgeFast(x, y) ? Collections.singleton(this.makeEdge(x, y)) : Collections.emptySet();
    }

    protected abstract E makeEdge(int var1, int var2);

    public E getEdge(Integer sourceVertex, Integer targetVertex) {
        int y;
        if (sourceVertex == null || targetVertex == null) {
            return null;
        }
        int x = sourceVertex;
        return this.containsEdgeFast(x, y = targetVertex.intValue()) ? (E)this.makeEdge(x, y) : null;
    }

    public Supplier<Integer> getVertexSupplier() {
        return null;
    }

    public Supplier<E> getEdgeSupplier() {
        return null;
    }

    public E addEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException();
    }

    public boolean addEdge(Integer sourceVertex, Integer targetVertex, E e) {
        throw new UnsupportedOperationException();
    }

    public Integer addVertex() {
        throw new UnsupportedOperationException();
    }

    public boolean addVertex(Integer v) {
        throw new UnsupportedOperationException();
    }

    public boolean containsEdge(Integer sourceVertex, Integer targetVertex) {
        if (sourceVertex == null || targetVertex == null) {
            return false;
        }
        return this.containsEdgeFast(sourceVertex, targetVertex);
    }

    protected boolean containsEdgeFast(int x, int y) {
        int target;
        if (x < 0 || x >= this.n || y < 0 || y >= this.n) {
            return false;
        }
        LazyIntIterator successors = this.immutableGraph.successors(x);
        if (successors instanceof LazyIntSkippableIterator) {
            return y == ((LazyIntSkippableIterator)successors).skipTo(y);
        }
        while ((target = successors.nextInt()) != -1) {
            if (target != y) continue;
            return true;
        }
        return false;
    }

    public boolean containsVertex(Integer v) {
        if (v == null) {
            return false;
        }
        int x = v;
        return x >= 0 && x < this.n;
    }

    public E removeEdge(Integer sourceVertex, Integer targetVertex) {
        throw new UnsupportedOperationException();
    }

    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException();
    }

    public boolean removeVertex(Integer v) {
        throw new UnsupportedOperationException();
    }

    public Set<Integer> vertexSet() {
        return IntSets.fromTo((int)0, (int)this.n);
    }

    public Integer getEdgeSource(E e) {
        return e.leftInt();
    }

    public Integer getEdgeTarget(E e) {
        return e.rightInt();
    }

    public double getEdgeWeight(E e) {
        return 1.0;
    }

    public void setEdgeWeight(E e, double weight) {
        if (weight != 1.0) {
            throw new UnsupportedOperationException();
        }
    }
}

