/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.webgraph;

import it.unimi.dsi.fastutil.ints.IntIntSortedPair;
import it.unimi.dsi.fastutil.objects.ObjectIterables;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashBigSet;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.NodeIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.GraphIterables;
import org.jgrapht.GraphType;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.webgraph.AbstractImmutableGraphAdapter;

public class ImmutableUndirectedGraphAdapter
extends AbstractImmutableGraphAdapter<IntIntSortedPair>
implements FlyweightPrototype<ImmutableUndirectedGraphAdapter> {
    private final GraphIterables<Integer, IntIntSortedPair> iterables = new GraphIterables<Integer, IntIntSortedPair>(){

        public ImmutableUndirectedGraphAdapter getGraph() {
            return ImmutableUndirectedGraphAdapter.this;
        }

        public long vertexCount() {
            return ImmutableUndirectedGraphAdapter.this.n;
        }

        public long edgeCount() {
            if (ImmutableUndirectedGraphAdapter.this.m != -1L) {
                return ImmutableUndirectedGraphAdapter.this.m;
            }
            ImmutableUndirectedGraphAdapter.this.m = ObjectIterables.size(this.edges());
            return ImmutableUndirectedGraphAdapter.this.m;
        }

        public long degreeOf(Integer vertex) {
            return this.inDegreeOf(vertex) + (long)(ImmutableUndirectedGraphAdapter.this.containsEdgeFast(vertex, vertex) ? 1 : 0);
        }

        public Iterable<IntIntSortedPair> edgesOf(Integer vertex) {
            final int x = vertex;
            return () -> new Iterator<IntIntSortedPair>(){
                final LazyIntIterator successors;
                int y;
                {
                    this.successors = ImmutableUndirectedGraphAdapter.this.immutableGraph.successors(x);
                    this.y = this.successors.nextInt();
                }

                @Override
                public boolean hasNext() {
                    if (this.y != -1) {
                        return true;
                    }
                    this.y = this.successors.nextInt();
                    return this.y != -1;
                }

                @Override
                public IntIntSortedPair next() {
                    IntIntSortedPair edge = IntIntSortedPair.of((int)this.y, (int)x);
                    this.y = -1;
                    return edge;
                }
            };
        }

        public long inDegreeOf(Integer vertex) {
            return ImmutableUndirectedGraphAdapter.this.immutableGraph.outdegree(vertex.intValue());
        }

        public Iterable<IntIntSortedPair> incomingEdgesOf(Integer vertex) {
            return this.edgesOf(vertex);
        }

        public long outDegreeOf(Integer vertex) {
            return ImmutableUndirectedGraphAdapter.this.immutableGraph.outdegree(vertex.intValue());
        }

        public Iterable<IntIntSortedPair> outgoingEdgesOf(Integer vertex) {
            return this.edgesOf(vertex);
        }

        public Iterable<IntIntSortedPair> edges() {
            return () -> new Iterator<IntIntSortedPair>(){
                final NodeIterator nodeIterator;
                LazyIntIterator successors;
                int x;
                int y;
                {
                    this.nodeIterator = ImmutableUndirectedGraphAdapter.this.immutableGraph.nodeIterator();
                    this.successors = LazyIntIterators.EMPTY_ITERATOR;
                    this.y = -1;
                }

                @Override
                public boolean hasNext() {
                    if (this.y != -1) {
                        return true;
                    }
                    while (true) {
                        if ((this.y = this.successors.nextInt()) == -1) {
                            if (!this.nodeIterator.hasNext()) {
                                return false;
                            }
                            this.x = this.nodeIterator.nextInt();
                            this.successors = this.nodeIterator.successors();
                            continue;
                        }
                        if (this.y >= this.x) break;
                    }
                    return true;
                }

                @Override
                public IntIntSortedPair next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    IntIntSortedPair edge = IntIntSortedPair.of((int)this.x, (int)this.y);
                    this.y = -1;
                    return edge;
                }
            };
        }
    };

    public ImmutableUndirectedGraphAdapter(ImmutableGraph immutableGraph) {
        super(immutableGraph);
    }

    @Override
    protected IntIntSortedPair makeEdge(int x, int y) {
        return IntIntSortedPair.of((int)x, (int)y);
    }

    public boolean containsEdge(IntIntSortedPair e) {
        if (e == null) {
            return false;
        }
        return this.containsEdgeFast(e.leftInt(), e.rightInt());
    }

    public Set<IntIntSortedPair> edgeSet() {
        NodeIterator nodeIterator = this.immutableGraph.nodeIterator();
        long m = this.iterables().edgeCount();
        ObjectOpenHashBigSet edges = new ObjectOpenHashBigSet(m);
        for (int i = 0; i < this.n; ++i) {
            int y;
            int x = nodeIterator.nextInt();
            LazyIntIterator successors = nodeIterator.successors();
            while ((y = successors.nextInt()) != -1) {
                if (x > y) continue;
                edges.add((Object)IntIntSortedPair.of((int)x, (int)y));
            }
        }
        return edges;
    }

    public int degreeOf(Integer vertex) {
        long d = (long)this.inDegreeOf(vertex) + (this.containsEdgeFast(vertex, vertex) ? 1L : 0L);
        if (d > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)d;
    }

    public Set<IntIntSortedPair> edgesOf(Integer vertex) {
        int target;
        ObjectLinkedOpenHashSet set = new ObjectLinkedOpenHashSet();
        int source = vertex;
        LazyIntIterator successors = this.immutableGraph.successors(source);
        while ((target = successors.nextInt()) != -1) {
            set.add((Object)IntIntSortedPair.of((int)source, (int)target));
        }
        return set;
    }

    public int inDegreeOf(Integer vertex) {
        return this.immutableGraph.outdegree(vertex.intValue());
    }

    public Set<IntIntSortedPair> incomingEdgesOf(Integer vertex) {
        return this.edgesOf(vertex);
    }

    public int outDegreeOf(Integer vertex) {
        return this.immutableGraph.outdegree(vertex.intValue());
    }

    public Set<IntIntSortedPair> outgoingEdgesOf(Integer vertex) {
        return this.edgesOf(vertex);
    }

    public GraphType getType() {
        return new DefaultGraphType.Builder().weighted(false).modifiable(false).allowMultipleEdges(false).allowSelfLoops(true).undirected().build();
    }

    public ImmutableUndirectedGraphAdapter copy() {
        return new ImmutableUndirectedGraphAdapter(this.immutableGraph.copy());
    }

    public GraphIterables<Integer, IntIntSortedPair> iterables() {
        return this.iterables;
    }
}

