/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.google;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

public class GOOGLE_PING2
extends FILE_PING {
    protected static final short GOOGLE_PING_ID = 2018;
    @Property(description="The region (eu, asia, us) where the bucket will be created. If non-null, the storage class will be multi-regional, else regional")
    protected String region;
    @Property(description="Creates the bucket if it doesn't exist")
    protected boolean create_bucket_if_not_exists = true;
    protected Storage store;
    protected Bucket bucket;

    public void init() throws Exception {
        super.init();
        if (this.location == null) {
            throw new IllegalStateException("location must be set");
        }
        this.store = (Storage)StorageOptions.getDefaultInstance().getService();
        this.bucket = this.store.get(this.location, new Storage.BucketGetOption[0]);
        if (this.bucket == null) {
            if (!this.create_bucket_if_not_exists) {
                throw new IllegalStateException("bucket " + this.location + " doesn't exist");
            }
            BucketInfo info = this.region == null ? BucketInfo.of((String)this.location) : BucketInfo.newBuilder((String)this.location).setStorageClass(StorageClass.REGIONAL).setLocation(this.region).build();
            this.bucket = this.store.create(info, new Storage.BucketTargetOption[0]);
            this.log.debug("created bucket %s", new Object[]{this.bucket.getName()});
        }
        this.log.debug("using bucket %s", new Object[]{this.bucket.getName()});
    }

    protected void createRootDir() {
    }

    protected void readAll(List<Address> members, String clustername, Responses responses) {
        if (clustername == null) {
            return;
        }
        try {
            clustername = GOOGLE_PING2.sanitize(clustername);
            for (Blob blob : this.bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)clustername)}).iterateAll()) {
                String name = blob.getName();
                if (!name.endsWith(".list")) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: reading %s", new Object[]{this.local_addr, blob.getName()});
                }
                byte[] contents = blob.getContent(new Blob.BlobSourceOption[0]);
                this.readResponse(contents, members, responses);
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage((String)"FailedReadingAddresses"), (Throwable)ex);
        }
    }

    protected void readResponse(byte[] buf, List<Address> mbrs, Responses responses) {
        if (buf != null && buf.length > 0) {
            try {
                List list = this.read(new ByteArrayInputStream(buf));
                if (list != null) {
                    for (PingData data : list) {
                        if (mbrs == null || mbrs.contains(data.getAddress())) {
                            responses.addResponse(data, data.isCoord());
                        }
                        if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                        this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
                    }
                }
            }
            catch (Throwable e) {
                this.log.error(Util.getMessage((String)"FailedUnmarshallingResponse"), e);
            }
        }
    }

    protected void write(List<PingData> list, String clustername) {
        String filename = GOOGLE_PING2.addressToFilename((Address)this.local_addr);
        String key = GOOGLE_PING2.sanitize(clustername) + "/" + GOOGLE_PING2.sanitize(filename);
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: writing %s", new Object[]{this.local_addr, key});
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.write(list, out);
            byte[] data = out.toByteArray();
            this.bucket.create(key, data, new Bucket.BlobTargetOption[0]);
        }
        catch (Exception e) {
            this.log.error(Util.getMessage((String)"ErrorMarshallingObject"), (Throwable)e);
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        String filename = GOOGLE_PING2.addressToFilename((Address)addr);
        String key = GOOGLE_PING2.sanitize(clustername) + "/" + GOOGLE_PING2.sanitize(filename);
        try {
            BlobId obj = BlobId.of((String)this.location, (String)key);
            boolean success = this.store.delete(obj);
            if (success && this.log.isTraceEnabled()) {
                this.log.trace("%s: removed %s/%s", new Object[]{this.local_addr, this.location, key});
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage((String)"FailureRemovingData"), (Throwable)e);
        }
    }

    protected void removeAll(String clustername) {
        if (clustername == null) {
            return;
        }
        try {
            for (Blob blob : this.bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)clustername)}).iterateAll()) {
                if (!blob.getName().endsWith(".list")) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: deleting %s", new Object[]{this.local_addr, blob.getName()});
                }
                blob.delete(new Blob.BlobSourceOption[0]);
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage((String)"FailedDeletingAllObjects"), (Throwable)ex);
        }
    }

    protected static String sanitize(String name) {
        return name.replace('/', '-').replace('\\', '-');
    }

    static {
        ClassConfigurator.addProtocol((short)2018, GOOGLE_PING2.class);
    }
}

