/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.util.List;
import java.util.Objects;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.raft.election.BaseElection;
import org.jgroups.raft.util.Utils;

@MBean(description="Protocol performing leader election according to the RAFT paper")
public class ELECTION
extends BaseElection {
    protected static final short ELECTION_ID = 520;

    @Override
    protected void handleView(View v) {
        Utils.Majority result = Utils.computeMajority(this.view, v, this.raft().majority(), this.raft.leader());
        this.log.debug("%s: existing view: %s, new view: %s, result: %s", new Object[]{this.local_addr, this.view, v, result});
        List joiners = View.newMembers((View)this.view, (View)v);
        boolean has_new_members = joiners != null && !joiners.isEmpty();
        this.view = v;
        switch (result) {
            case no_change: {
                if (!this.raft.isLeader() || !has_new_members) break;
                this.sendLeaderElectedMessage(this.raft.leader(), this.raft.currentTerm());
                break;
            }
            case reached: 
            case leader_lost: {
                if (!Objects.equals(this.view.getCoord(), this.local_addr)) break;
                this.log.trace("%s: starting voting process (reason: %s, view: %s)", new Object[]{this.local_addr, result, this.view});
                this.startVotingThread();
                break;
            }
            case lost: {
                this.stopVotingThread();
                this.raft.setLeaderAndTerm(null);
            }
        }
    }

    static {
        ClassConfigurator.addProtocol((short)520, ELECTION.class);
    }
}

