/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.jgroups.JChannel;
import org.jgroups.blocks.atomic.CounterFunction;
import org.jgroups.blocks.atomic.CounterView;
import org.jgroups.protocols.raft.InternalCommand;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Role;
import org.jgroups.raft.Options;
import org.jgroups.raft.RaftHandle;
import org.jgroups.raft.StateMachine;
import org.jgroups.raft.blocks.AsyncCounterImpl;
import org.jgroups.raft.blocks.RaftAsyncCounter;
import org.jgroups.raft.blocks.RaftSyncCounter;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.CompletableFutures;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class CounterService
implements StateMachine,
RAFT.RoleChange {
    protected RaftHandle raft;
    protected long repl_timeout = 20000L;
    protected boolean allow_dirty_reads = true;
    @GuardedBy(value="counters")
    protected final Map<String, Long> counters = new HashMap<String, Long>();

    public CounterService(JChannel ch) {
        this.setChannel(ch);
    }

    public void setChannel(JChannel ch) {
        this.raft = new RaftHandle(ch, this).addRoleListener(this);
    }

    public JChannel channel() {
        return this.raft.channel();
    }

    public void addRoleChangeListener(RAFT.RoleChange listener) {
        this.raft.addRoleListener(listener);
    }

    public long replTimeout() {
        return this.repl_timeout;
    }

    public CounterService replTimeout(long timeout) {
        this.repl_timeout = timeout;
        return this;
    }

    public boolean allowDirtyReads() {
        return this.allow_dirty_reads;
    }

    public CounterService allowDirtyReads(boolean flag) {
        this.allow_dirty_reads = flag;
        return this;
    }

    public long lastApplied() {
        return this.raft.lastApplied();
    }

    public long commitIndex() {
        return this.raft.commitIndex();
    }

    public void snapshot() throws Exception {
        this.raft.snapshot();
    }

    public long logSize() {
        return this.raft.logSize();
    }

    public String raftId() {
        return this.raft.raftId();
    }

    public CounterService raftId(String id) {
        this.raft.raftId(id);
        return this;
    }

    public RaftSyncCounter getOrCreateCounter(String name, long initial_value) throws Exception {
        return ((RaftAsyncCounter)CompletableFutures.join(this.getOrCreateAsyncCounter(name, initial_value))).sync();
    }

    public void deleteCounter(String name) throws Exception {
        CompletableFutures.join(this.deleteCounterAsync(name));
    }

    public CompletionStage<Void> deleteCounterAsync(String name) {
        AsciiString counterName = new AsciiString(name);
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(Bits.size((AsciiString)counterName) + 1);
        try {
            CounterService.writeCommandAndName(out, Command.delete.ordinal(), counterName);
            return this.setAsyncWithTimeout(out, Options.DEFAULT_OPTIONS).thenApply(CompletableFutures.toVoidFunction());
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printCounters() {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            return this.counters.entrySet().stream().map(e -> String.format("%s = %d", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
        }
    }

    @Override
    public byte[] apply(byte[] data, int offset, int length, boolean serialize_response) throws Exception {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, offset, length);
        Command command = Command.values()[in.readByte()];
        String name = Bits.readAsciiString((DataInput)in).toString();
        Long retval = null;
        switch (command) {
            case create: {
                long val = Bits.readLongCompressed((DataInput)in);
                retval = this._create(name, val);
                break;
            }
            case delete: {
                this._delete(name);
                break;
            }
            case get: {
                retval = this._get(name);
                break;
            }
            case set: {
                long val = Bits.readLongCompressed((DataInput)in);
                this._set(name, val);
                break;
            }
            case addAndGet: {
                long val = Bits.readLongCompressed((DataInput)in);
                retval = this._add(name, val);
                break;
            }
            case compareAndSwap: {
                retval = this._compareAndSwap(name, Bits.readLongCompressed((DataInput)in), Bits.readLongCompressed((DataInput)in));
                break;
            }
            case updateFunction: {
                retval = this._update(name, (CounterFunction)Util.readGenericStreamable((DataInput)in));
                break;
            }
            default: {
                throw new IllegalArgumentException("command " + command + " is unknown");
            }
        }
        return serialize_response ? Util.objectToByteBuffer((Object)retval) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContentTo(DataOutput out) throws Exception {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            int size = this.counters.size();
            out.writeInt(size);
            for (Map.Entry<String, Long> entry : this.counters.entrySet()) {
                AsciiString name = new AsciiString(entry.getKey());
                Long value = entry.getValue();
                Bits.writeAsciiString((AsciiString)name, (DataOutput)out);
                Bits.writeLongCompressed((long)value, (DataOutput)out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readContentFrom(DataInput in) throws Exception {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                AsciiString name = Bits.readAsciiString((DataInput)in);
                Long value = Bits.readLongCompressed((DataInput)in);
                this.counters.put(name.toString(), value);
            }
        }
    }

    public static String readAndDumpSnapshot(DataInput in) {
        try {
            int size = in.readInt();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                AsciiString name = Bits.readAsciiString((DataInput)in);
                Long value = Bits.readLongCompressed((DataInput)in);
                sb.append(name).append(": ").append(value);
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void dumpLog() {
        this.raft.logEntries((entry, index) -> {
            StringBuilder sb = new StringBuilder().append(index).append(" (").append(entry.term()).append("): ");
            sb.append(CounterService.dumpLogEntry(entry));
            System.out.println(sb);
        });
    }

    public static String dumpLogEntry(LogEntry e) {
        if (e.command() == null) {
            return "<marker record>";
        }
        StringBuilder sb = new StringBuilder();
        if (e.internal()) {
            try {
                InternalCommand cmd = (InternalCommand)Util.streamableFromByteBuffer(InternalCommand.class, (byte[])e.command(), (int)e.offset(), (int)e.length());
                sb.append("[internal] ").append(cmd);
            }
            catch (Exception ex) {
                sb.append("[failure reading internal cmd] ").append(ex);
            }
            return sb.toString();
        }
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(e.command(), e.offset(), e.length());
        try {
            Command cmd = Command.values()[in.readByte()];
            String name = Bits.readAsciiString((DataInput)in).toString();
            switch (cmd) {
                case create: 
                case set: 
                case addAndGet: {
                    sb.append(CounterService.print(cmd, name, 1, (DataInput)in));
                    break;
                }
                case delete: 
                case get: 
                case compareAndSwap: {
                    sb.append(CounterService.print(cmd, name, 2, (DataInput)in));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("command " + cmd + " is unknown");
                }
            }
        }
        catch (Throwable t) {
            sb.append(t);
        }
        return sb.toString();
    }

    @Override
    public void roleChanged(Role role) {
        System.out.println("-- changed role to " + role);
    }

    public String toString() {
        return this.printCounters();
    }

    public RaftAsyncCounter asyncCounter(String name) {
        return new AsyncCounterImpl(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<RaftAsyncCounter> getOrCreateAsyncCounter(String name, long initialValue) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            if (this.counters.containsKey(name)) {
                return CompletableFuture.completedFuture(this.asyncCounter(name));
            }
        }
        return this.invokeAsync(Command.create, new AsciiString(name), initialValue).thenApply(__ -> this.asyncCounter(name));
    }

    protected CompletionStage<Long> asyncGet(AsciiString name) {
        return this.invokeAsyncAndGet(Command.get, name, Options.DEFAULT_OPTIONS);
    }

    protected CompletionStage<Void> asyncSet(AsciiString name, long value) {
        return this.invokeAsync(Command.set, name, value);
    }

    protected CompletionStage<Long> asyncAddAndGet(AsciiString name, long delta, Options opts) {
        return delta == 0L ? this.asyncGet(name) : this.invokeAsyncAddAndGet(name, delta, opts);
    }

    protected CompletionStage<Long> asyncCompareAndSwap(AsciiString name, long expected, long value, Options opts) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(Bits.size((AsciiString)name) + 1 + Bits.size((long)expected) + Bits.size((long)value));
        try {
            CounterService.writeCommandAndName(out, Command.compareAndSwap.ordinal(), name);
            Bits.writeLongCompressed((long)expected, (DataOutput)out);
            Bits.writeLongCompressed((long)value, (DataOutput)out);
            return this.setAsyncWithTimeout(out, opts).thenApply(CounterService::readLong);
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    protected <T extends Streamable> CompletionStage<T> asyncUpdate(AsciiString name, CounterFunction<T> function, Options options) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(Bits.size((AsciiString)name) + 1 + 128);
        try {
            CounterService.writeCommandAndName(out, Command.updateFunction.ordinal(), name);
            Util.writeGenericStreamable(function, (DataOutput)out);
            return this.setAsyncWithTimeout(out, options).thenApply(CounterService::safeStreamableFromBytes);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    protected CompletionStage<Long> invokeAsyncAndGet(Command command, AsciiString name, Options opts) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(Bits.size((AsciiString)name) + 1);
        try {
            CounterService.writeCommandAndName(out, command.ordinal(), name);
            return this.setAsyncWithTimeout(out, opts).thenApply(CounterService::readLong);
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    protected CompletionStage<Long> invokeAsyncAddAndGet(AsciiString name, long arg, Options opts) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(Bits.size((AsciiString)name) + 1 + Bits.size((long)arg));
        try {
            CounterService.writeCommandAndName(out, Command.addAndGet.ordinal(), name);
            Bits.writeLongCompressed((long)arg, (DataOutput)out);
            return this.setAsyncWithTimeout(out, opts).thenApply(CounterService::readLong);
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    protected CompletionStage<Void> invokeAsync(Command command, AsciiString name, long arg) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(Bits.size((AsciiString)name) + 1 + Bits.size((long)arg));
        try {
            CounterService.writeCommandAndName(out, command.ordinal(), name);
            Bits.writeLongCompressed((long)arg, (DataOutput)out);
            return this.setAsyncWithTimeout(out, Options.DEFAULT_OPTIONS).thenApply(CompletableFutures.toVoidFunction());
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    private static void writeCommandAndName(ByteArrayDataOutputStream out, int command, AsciiString name) throws IOException {
        out.writeByte(command);
        Bits.writeAsciiString((AsciiString)name, (DataOutput)out);
    }

    private CompletionStage<byte[]> setAsyncWithTimeout(ByteArrayDataOutputStream out, Options opts) throws Exception {
        return this.raft.setAsync(out.buffer(), 0, out.position(), opts).orTimeout(this.repl_timeout, TimeUnit.MILLISECONDS);
    }

    private static Long readLong(byte[] rsp) {
        try {
            return (Long)Util.objectFromByteBuffer((byte[])rsp);
        }
        catch (IOException | ClassNotFoundException e) {
            throw CompletableFutures.wrapAsCompletionException((Throwable)e);
        }
    }

    protected static String print(Command command, String name, int num_args, DataInput in) {
        StringBuilder sb = new StringBuilder(command.toString()).append("(").append(name);
        for (int i = 0; i < num_args; ++i) {
            try {
                long val = Bits.readLongCompressed((DataInput)in);
                sb.append(", ").append(val);
                continue;
            }
            catch (IOException ignored) {
                break;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _create(String name, long initial_value) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long val = this.counters.get(name);
            if (val != null) {
                return val;
            }
            this.counters.put(name, initial_value);
            return initial_value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(String name) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            this.counters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _get(String name) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long retval = this.counters.get(name);
            return retval != null ? retval : 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _set(String name, long new_val) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            this.counters.put(name, new_val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _add(String name, long delta) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long val = this.counters.get(name);
            if (val == null) {
                val = 0L;
            }
            this.counters.put(name, val + delta);
            return val + delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _compareAndSwap(String name, long expected, long value) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long existing = this.counters.get(name);
            if (existing == null) {
                return expected == 0L ? 1L : 0L;
            }
            if (existing == expected) {
                this.counters.put(name, value);
            }
            return existing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Streamable> T _update(String name, CounterFunction<T> function) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            long original = this.counters.getOrDefault(name, 0L);
            CounterViewImpl view = new CounterViewImpl(original);
            Streamable result = (Streamable)function.apply((Object)view);
            this.counters.put(name, view.value);
            return (T)result;
        }
    }

    private static <T extends Streamable> T safeStreamableFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (T)((Streamable)Util.objectFromByteBuffer((byte[])bytes));
        }
        catch (IOException | ClassNotFoundException e) {
            throw CompletableFutures.wrapAsCompletionException((Throwable)e);
        }
    }

    private static class CounterViewImpl
    implements CounterView {
        long value;

        CounterViewImpl(long value) {
            this.value = value;
        }

        public long get() {
            return this.value;
        }

        public void set(long value) {
            this.value = value;
        }
    }

    protected static enum Command {
        create,
        delete,
        get,
        set,
        addAndGet,
        compareAndSwap,
        updateFunction;

    }
}

